<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "event";
include "inc/header.inc.php";


//append language setup
require_once($languageArrayPath . 'arr_event_type.lang.php');
require_once($languageArrayPath . 'arr_events.lang.php');
require_once($c_node['class_dir'] . 'Calendar.class.php');
require_once($c_node['class_dir'] . 'Group/Group.class.php');

// Set the database connection and id. If a third parameter is set the id is assumed to
// be a group id.
if(!isset($_REQUEST["time"]))
	$time = mktime();
else
	$time = $_REQUEST["time"];

$now = getdate($time);

$cal   = new Calendar($db, $now, $me['user_id']);

$event->event_activity_type = $c_node['activity_user_status'];
$event->thumb = "t1";


//get date
$cal->setCalendarBase();


// get global events

foreach($lang['arr_events'] as $index => $event_tmp)
{
	$events[] = $cal->modifyEventDate($event_tmp);
}

// get all group events
$output_groups = getGroups($c_node['group_status']['active']);

foreach($output_groups as $index1 => $temp)
{
	$events_v = $event->getEvents("group", $temp['group_id']);//getEvents('user', $me['user_id']);
	foreach($events_v as $index => $event_tmp)
	{
		if(isset($event_tmp)) {
			$events[] = $cal->modifyEventDate($event_tmp);
			}
	}


}
// get all user events
$events_v = $event->getEvents("user", $me['user_id']);
foreach($events_v as $index => $event_tmp)
{
	if(isset($event_tmp)) {
		$events[] = $cal->modifyEventDate($event_tmp);
	}
}

// Populate all events
foreach($events as $index => $event_tmp)
	$cal->populateEvent($event_tmp);

$cal->setBlankDays();             // Set blank days in the beginning of the calendar
$calendar = $cal->getCalendar();  // Get the calendar array

/*print '<pre>';
print_r($calendar);
print '</pre>';*/
// get today's day number to highlight today in calendar,
// a string is only returned if the calendar view is current month
$todaynumber = $cal->getToDay(mktime());

// Get last and next months timestamp
$links["last"] = $date->getMonthTime($time, -1);
$links["next"] = $date->getMonthTime($time, 1);

// Get the calendar view month name
$thismonth = $date->getMonthString($time);

// Get the right event
if(!isset($_REQUEST["event"]))
	$event = array();
else
{
	$day_content = $cal->getDayContent($_REQUEST["day"]);
	$event       = $day_content[$_REQUEST["event"]];
}

//move to template
if (isset($event)) {
	$body->set('event', $event);
}

if (isset($time)) {
	$body->set('time', $time);
}

if (isset($calendar)) {
	$body->set('calendar', $calendar);
}

if (isset($todaynumber)) {
	$body->set('todaynumber', $todaynumber);
}

if (isset($thismonth)) {
	$body->set('thismonth', $thismonth);
}

if (isset($links)) {
	$body->set('links', $links);
}

$template_pageLink = "events";
include "inc/footer.inc.php";


/*
* getGroups
* Tom Calthrop 11th April 2004
*/
function getGroups ($group_status) {

	global $db, $me, $image, $log;

	$query = "
		SELECT g.group_title, g.group_id, g.group_synopsis, g.group_image_id
		FROM " . $db->prefix . "_group_member gm
		LEFT JOIN " . $db->prefix . "_group g on gm.group_id=g.group_id
		where
		gm.user_id=" . $me['user_id'] . " and
		g.group_status=" . $group_status
	;

	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else if ($result) {

		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;

			if ($temp1['group_image_id']) {
			    $temp1['image'] = $image->getImage($temp1['group_image_id'], 't2', 'group');
			}

			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();

		return $temp;
	}
}//EO getGroups();


?>
