<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

class User {

	var $email, $password, $node_id, $stat_type_id_friends, $stat_type_id_aqaintances,
	$image, $user_id, $date, $relation_type, $db;


	function checkLogin($email, $password){
	// Check whether the username is in the database
		if(empty($email))
			$state[]  = array('error', 2);
		else{
			$dr = $this->db->Execute("SELECT user_id FROM " . $this->db->prefix . "_user
				WHERE user_email='$email'");

			if(empty($dr->fields["user_id"]))
				$state[]  = array('error', 24);
		}

		// Check whether the password is in the database and correct
		if(empty($password))
			$state[]  = array('error', 25);
		else{
			if(empty($state))
			{
				$query = "
					SELECT user_id, user_locked
					FROM " . $this->db->prefix . "_user
					WHERE
					user_email='" . $email . "' AND
					user_password='" . MD5($password) . "'"
				;
				
				$dr = $this->db->Execute($query);

				if(empty($dr->fields["user_id"]))
					$state[]  = array('error', 19);

				if($dr->fields["user_locked"] == 1)
					$state[]  = array('error', 26);
			}
		}

		if (isset($state)) {
		    return $state;
		}

	}

	function loginUser ($email, $password, $node_id) {

		$query = "SELECT
			u.user_id, u.user_email, u.user_firstname, u.level_id,
			u.user_homepage, t.template_title, u.user_nic,
			u.user_surname, u.language_id, MD5(UNIX_TIMESTAMP() + user_id + RAND(UNIX_TIMESTAMP())) AS session_id
			FROM " . $this->db->prefix . "_user u, " . $this->db->prefix . "_template t
			WHERE u.template_id = t.template_id AND
			user_email='" . $email . "' AND
			user_password='" . MD5($password) . "'"
		;

		// Get data
		$dr = $this->db->Execute($query)
		;

		// Login successful
		if (isset($dr->fields['user_id'])){
			// Starts a session
			if (empty($_SESSION)) {
			    session_start();
			}

			$this->user_id = $dr->fields['user_id'];

			// Sets the sessionvariables
			$_SESSION['s_user_id']       = $dr->fields['user_id'];
			$_SESSION['s_email']         = $dr->fields['user_email'];
			$_SESSION['s_firstname']     = $dr->fields['user_firstname'];
			$_SESSION['s_surname']       = $dr->fields['user_surname'];
			$_SESSION['s_nic']       	 = $dr->fields['user_nic'];
			$_SESSION['s_level_id']      = $dr->fields['level_id'];
			$_SESSION['s_md5']    		 = md5($dr->fields['session_id']);
			$_SESSION['s_node_id']       = $node_id;
			$_SESSION['s_language_id']   = $dr->fields['language_id'];
			$_SESSION['s_homepage']      = $dr->fields['user_homepage'];
			$_SESSION['s_user_template'] = $dr->fields['template_title'];
			$_SESSION['s_breadcrumb']    = array();
			$_SESSION['s_language_ids']   = $this->getLanguages();

			$timestamp = $this->db->DBTimeStamp(mktime());

			$query =
				"INSERT INTO " . $this->db->prefix . "_user_session
				(
				session_md5,
				session_firstused,
				session_lastused,
				session_ip,
				user_id
				) values (
				'" . $_SESSION['s_md5'] . "',
				" . $timestamp . ",
				" . $timestamp . ",
				'" . $_SERVER['REMOTE_ADDR'] . "',
				'" . $this->user_id . "'
				)"
			;

			// Update session-table
			$result = $this->db->Execute($query);

			if (!$result) {
				$state[]  = array('error', 1, $this->db->ErrorMsg());
			}
			else {
				//get friends and aquintances
				$_SESSION['s_social_network'] = $this->setSocialNetwork($dr->fields['user_id']);


				//update user statistics
				$this->setStatistic($this->total_login_stat_id);


				//set locale
				if (isset($dr->fields['language_id'])) {
				    $this->setLocale();
				}

				return header("Location: " . $this->aroundme_dir . $dr->fields['user_homepage']."?".SID);
				exit;
			}




		}
		else {
			$state[] = array('error', 19);
			return $state;
		}
	}


	//setup local language for date setting etc // tom 19th April 2004
	function setLocale($language_id = null) {

		if ($language_id == "2") { //Albanian
		    setlocale(LC_ALL,"alb");
		}
		elseif ($language_id == "3") { //Serbian
		    setlocale(LC_ALL,"sr");
		}
		else { //We default to English
		    setlocale(LC_ALL,"eng");
		}
	}


	function logoffUser () {
		if (!isset($_SESSION)) {
		    session_start();
		}

		$_SESSION = array();
		session_destroy();
	}


	function authUser () {
		session_start();

		// Check for a session-variable containing the session-id, if none go to login page
		if(!isset($_SESSION['s_md5'])) {
			header("Location: index.php?" . SID);
			exit;
		}

		// Authenticate user
		$query = "
			SELECT session_md5
			FROM " . $this->db->prefix . "_user_session
			WHERE user_id = " . $_SESSION['s_user_id'] . "
			order by session_id desc limit 1";

		$dr = $this->db->Execute($query);

		// Checks if the session-id in the database and in the session-variables agree
		if($dr->fields['session_md5'] != $_SESSION['s_md5']) {
			$this->logoffUser();
			header("Location: index.php?" . SID);
			exit;
		}


		// Check if user is locked
		$query = "SELECT user_locked FROM " . $this->db->prefix . "_user
			WHERE user_id = " . $_SESSION['s_user_id'];

		$dr = $this->db->Execute($query);

		// If user is locked...
		if($dr->fields['user_locked'] == 1) {
			header("Location: index.php?" . SID);
			exit;
		}


		//session update added by tom - 14th Sept 2004
		// Setting the user to online
		//$timestamp = mktime();
		$timestamp = $this->db->DBTimeStamp(mktime());
		//$this->db->DBTimeStamp(mktime());


		$query1 = "
			UPDATE " . $this->db->prefix . "_user_session SET
			session_lastused=" . $timestamp . "
			WHERE
			session_md5='". $_SESSION['s_md5'] . "'"
		;

		$result = $this->db->Execute($query1);
		//print_r($result);

		$query2 = "
			UPDATE " . $this->db->prefix . "_user
			SET active_time=" . $timestamp . "
			WHERE
			user_id=". $_SESSION['s_user_id']
		;
		$this->db->Execute($query2);



		// Logging out people who have not been active for 12 hours - they wil be directed
		// to the login-page as their session-id will not match the database session-id
		$logout_timestamp = $timestamp-(720*60);

		$query3 = "
			SELECT user_id
			FROM " . $this->db->prefix . "_user
			WHERE " . $logout_timestamp . " > active_time"
		;

		$dr = $this->db->Execute($query3);  // Logout if not active for 720 minutes

		// Going through the list and changing the sessions-ids,
		// which forces "really" inactive users to log on again....
		while (!$dr->EOF) {
			$user_id = $dr->fields['user_id'];

			$query4 = "
				UPDATE " . $this->db->prefix . "_user_session
				SET session_md5 is null
				WHERE
				user_id=" . $user_id
			;
			$this->db->Execute($query4);
			$dr->MoveNext();
	  	}

	}


	// getting the status of the user
	function getStatus($active_time = null){

		$status = 4; //offline

		$time[1] = 0; //online
		$time[2] = 15; //idle
		$time[3] = 20; // sleeping
		$time[4] = 30; //offline

		foreach($time as $key => $t):
			$timedif = $this->db->UserTimeStamp(mktime()-(60*$t), "YmdHis");

			if($active_time <= $timedif) {
				$status = $key;
			}

		endforeach;

		return $status;
	}

	// change the user's status... NOT YET FULLY WORKING!
	function setStatus($status){
		$time[2] = 15;
		$time[4] = 20;
		$time[6] = 30;
		$this->db->Execute("UPDATE " . $this->db->prefix . "_user SET active_time=UNIX_TIMESTAMP()-60*$time[$status]
			WHERE user_id=". $_SESSION["s_user_id"]);
	}

	function createPassword(){

		// creates a password
		$totallength = 8;
		$salt = "abcdefghijklmnpqrstuvwxyzABCDEFGHIJKLMNPQRSTUVWXYZ123456789";
		srand((double)microtime()*1000000);
		$password = "";
		for ($i = 0; $i < $totallength; $i++) {
			$password .= substr ($salt, rand() % strlen($salt), 1);
		}

		return $password;
	}



	function savePassword($password, $email){
		// Saves the changes
		$dr = $this->db->Execute("UPDATE " . $this->db->prefix . "_user SET
			user_password=md5('$password') WHERE user_email='$email'");
	}



	function emailPassword($password, $email){
		// Obsolete
	}

	function newPassword($email){
		// Creates a new password
		$password = $this->createPassword();

		// Saves the password
		$this->savePassword($password, $email);

		// Emails the password
		$this->emailPassword($password, $email);
	}



	function checkRegister($data){

		// Check the email
		if(empty($data['user_email']))
			$state[]  = array('error', 2);
		else
		{
			if(!preg_match('/^[-A-Za-z0-9_.]+[@][A-Za-z0-9_-]+([.][A-Za-z0-9_-]+)*[.][A-Za-z]{2,8}$/', $data['user_email']))
				$state[]  = array('error', 3, $data['user_email']);

			$dr = $this->db->Execute("SELECT user_id FROM " . $this->db->prefix . "_user
				WHERE user_email='" . $data['user_email'] . "'");

			if(!empty($dr->fields["user_id"]))
				$state[]  = array('error', 4, $data['user_email']);
		}

		// Check the firstname
		if(empty($data['user_firstname']))
			$state[]  = array('error', 5);

		// Check the surname
		if(empty($data['user_surname']))
			$state[]  = array('error', 6);

		// Check the nic
		if(empty($data['user_nic']))
			$state[]  = array('error', 7);

		// Check the gender
		if(empty($data['user_gender']))
			$state[]  = array('error', 8);

		// Check the place of birth
		if(empty($data['user_birthtown']))
			$state[]  = array('error', 9);

		// Check the place of residence
		if(empty($data['user_hometown']))
			$state[]  = array('error', 10);
			
		// Check the langua<ges a user can read
		if(empty($data['language_ids']))
			$state[]  = array('error', 28);
			

		if (!isset($state)) {
		    $state[]  = array('success', 1);
		}

		return $state;

	}



	function registerUser($data){

		// Creates a new password
		$password = $this->createPassword();

		$tmp = md5($password);

		$query = "
			INSERT INTO " . $this->db->prefix . "_user SET
			user_email='" . $data['user_email'] . "',
			user_firstname='" . $data['user_firstname'] . "',
			user_password='" . $tmp . "',
			user_surname='" . $data['user_surname'] . "',
			user_nic='" . $data['user_nic'] . "',
			user_gender='" . $data['user_gender'] . "',
			user_birthtown='" . $data['user_birthtown'] . "',
			user_hometown='" . $data['user_hometown'] . "',
			user_dob='" . $data['user_dob'] . "',
			user_create_datetime=NOW(),
			user_locked=1,
			template_id=1,
			user_homepage='welcome.php',
			level_id=1,
			language_id=" . $data['language_id']
		;

		$result = $this->db->Execute($query);

		if (isset($result)) {
			
			$query1 = "
				SELECT user_id
				FROM " . $this->db->prefix . "_user
				WHERE
				user_email='" . $data['user_email'] . "'"
			;
			$result1 = $this->db->Execute($query1);
	
			$user_id = $result1->fields['user_id'];
			
			$this->user_id = $user_id;
	
			//add readable languages to language table
			$this->insertLanguages($data['language_ids']);
			
			
			// creates an entry in br_user_session
			$query2 = "
				INSERT INTO " . $this->db->prefix . "_user_session SET
				user_id=" . $user_id
			;
	
			$result2 = $this->db->Execute($query2);
	
	
			// Email verification email
			$this->emailVerification($password, $data['user_email'], $data['user_firstname'], $data['language_id'], 'registration.txt.php');
		}
	}


	function setSocialNetwork($user_id) {
		$friend_total = 0;
		$acquaintance_total = 0;

		$query = "
			SELECT r.user_id_friend as user_id, r.node_id
			FROM " . $this->db->prefix . "_relation r
			WHERE
			r.user_id =" . $user_id . " and
			r.user_id_friend <>" . $this->user_id . " and
			r.type=" . $this->relation_type
		;
		$result = $this->db->Execute($query);

		if (!isset($result)) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$temp = array();

			while (!$result->EOF) {
				$friend_total++;

				$temp1 = $result->fields;

				//get aquaintances for each friend
				$query1 = "
					SELECT r.user_id_friend as user_id, r.node_id, u.user_create_datetime,
					u.user_nic
					FROM " . $this->db->prefix . "_relation r
					LEFT JOIN " . $this->db->prefix . "_user u ON r.user_id_friend=u.user_id
					WHERE
					r.user_id_friend <>" . $this->user_id . " and
					r.user_id =" . $result->fields['user_id']
				;
				$result1 = $this->db->Execute($query1);

				if (!$result1) {
					$state[]  = array('error', 1, $this->db->ErrorMsg());
				}
				else {


					$temp2 = array();

					while (!$result1->EOF) {
						$acquaintance_total++;

						array_push($temp2, $result1->fields);
						$result1->MoveNext();
					}
					$temp1['acquaintance'] = $temp2;
				}

				array_push($temp, $temp1);

				$temp['friend_total'] = $friend_total;
				$temp['acquaintance_total'] = $acquaintance_total;

				$result->MoveNext();

			}
		}

		//update user statistics
		$this->setStatistic($this->stat_type_id_friends, $friend_total);
		$this->setStatistic($this->stat_type_id_aqaintances, $acquaintance_total);

		if (isset($temp)) {
		    return $temp;
		}
	}

	/*
	* Get social network, used in friends, my friends and profile lists.
	* tom calthrop
	* 10 april 2004
	*/
	function getSocialNetwork($user_id) {

		$query = "
			SELECT r.user_id_friend as user_id, r.node_id, u.user_firstname, u.user_surname,
			u.user_hometown, u.active_time, u.user_create_datetime, u.user_nic, u.user_image_id
			FROM " . $this->db->prefix . "_relation r, " . $this->db->prefix . "_user u
			WHERE
			r.user_id_friend=u.user_id and
			r.user_id =" . $user_id . " and
			r.user_id_friend <>" . $this->user_id . " and
			r.type=2 and
			u.user_locked=2"
		;

		if (isset($this->orderby)) {
		    $query .= " order by " . $this->orderby;
		}
		else {
		    $query .= " order by user_firstname";
		}

		if (isset($this->limit)) {
		    $query .= " limit " . $this->limit;
		}
		//echo $query;
		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$temp = array();

			while (!$result->EOF) {

				$temp1 = $result->fields;

				//format date
				$temp1['user_create_datetime'] = $this->date->formatDate($temp1['user_create_datetime']);

				$temp1['online_status'] = $this->getStatus($temp1['active_time']);

				//get default image
				if ($temp1['user_image_id']) {
					$temp1['image'] = $this->image->getImage($temp1['user_image_id'], 't2', 'user', $temp1['user_id']);
				}
				else {
					$temp1['image']['image'] = "user/no_user_t2.gif";
					$temp1['image']['image_title'] = "";
				}


				//get aquaintances for each friend
				$query1 = "
					SELECT r.user_id_friend as user_id, r.node_id, u.user_create_datetime,
					u.user_firstname, u.user_surname, u.user_hometown, u.user_nic
					FROM " . $this->db->prefix . "_relation r, " . $this->db->prefix . "_user u
					WHERE
					r.user_id_friend=u.user_id and
					r.user_id =" . $result->fields['user_id'] . " and
					r.user_id_friend <>" . $this->user_id . " and
					r.type=2 and
					u.user_locked=2"
				;

				$result1 = $this->db->Execute($query1);

				if (!$result1) {
					$state[]  = array('error', 1, $this->db->ErrorMsg());
				}
				else {

					$temp2 = array();

					while (!$result1->EOF) {
						array_push($temp2, $result1->fields);
						$result1->MoveNext();
					}
					$temp1['acquaintance'] = $temp2;
				}

				array_push($temp, $temp1);

				$result->MoveNext();

			}
		}
		return $temp;

	}

	/*
	* USER  IMAGE
	* tom calthrop
	* 21st Feb 2004
	*/
	function userImage ($image_id = null, $thumb = null) {
		if (!isset($image_id)) {
			$query = "
				SELECT ui.image_id, ui.image_filename, ui.image_mime, ui.image_title
				FROM " . $this->db->prefix . "_user_image ui
				where
				ui.default is not NULL and
				ui.user_id=" . $this->user_id . "
				order by ui.image_id limit 1"
			;
		}
		else {
			$query = "
				SELECT ui.image_id, ui.image_filename, ui.image_mime, ui.image_title
				FROM " . $this->db->prefix . "_user_image ui
				where
				ui.image_id=" . $image_id
			;
		}

		$result = $this->db->Execute($query);

		if (!isset($result)) {
			$state = array('error', 1, $this->db->ErrorMsg());
		}
		else {

			if ($result->fields['image_id']) {
			    $output = $result->fields;

				if (isset($thumb)) {
				  	$output['image'] = "user/" . $this->user_id . "/" . $result->fields['image_filename'] . "_" . $thumb . "." . $result->fields['image_mime'];
				}
				else {
					$output['image'] = "user/" . $this->user_id . "/" . $result->fields['image_filename'] . "." . $result->fields['image_mime'];

				}
			}

			$result->Close();
		}

		return $output;
	}


	/*
	* USER DETAILS
	* tom calthrop
	* 21st Feb 2004
	*/
	function userDetails ($user_id = null) {
		if (!isset($user_id)) {
			$user_id = $this->user_id;
		}

		$query = "
			SELECT u.*
			FROM " . $this->db->prefix . "_user u
			where
			u.user_id=" . $user_id
		;

		$result = $this->db->Execute($query);

		if (!isset($result)) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		elseif (isset($result->fields['user_id'])) {
			$output =  $result->fields;
			$output['user_create_datetime'] = $this->date->formatDate($output['user_create_datetime']);

			//if the user is me we set to "online", else we find the staus
			if ($_SESSION['s_user_id'] == $user_id) {
			    $output['online_status'] = 1;
			}
			else {
				$output['online_status'] = $this->getStatus($output['active_time']);
			}

			$result->Close();

			$this->user_id = $result->fields['user_id'];

			return $output;
		}
		else {
			header("Location: sn_network.php?" . SID);
			exit;
		}
	}

	/*
	* AFTER USER REG WE SEND USER EMAIL WITH PASS
	* tom calthrop
	* 21st Feb 2004
	*/
	function emailVerification($password, $email, $firstname, $language_id, $txt_template){
		//pick up the language file

		$body_file_txt = readTxtFile($this->aroundme_dir . "language/" . $language_id . "/" . $this->language_dir . "/texts/" . $txt_template);

		$body_file_txt = str_replace("\\\"", "\"", $body_file_txt);
		$body_file_txt = str_replace("USERNAME", $firstname, $body_file_txt);
		$body_file_txt = str_replace("EMAIL", $email, $body_file_txt);
		$body_file_txt = str_replace("PASSWORD", $password, $body_file_txt);
		
		//create URL
		$url = "http://" . $_SERVER['HTTP_HOST'];
		
		if (dirname ($_SERVER['PHP_SELF']) != "/") {
		    $url .= dirname ($_SERVER['PHP_SELF']);
		}
		
		$url .= "/setup.php?em=" . $email . "&language_id=" . $language_id;
		
		if (isset($user->invitee_id)) {
		    $url = $url . "invitee=" . $this->user_id;
		}

		$body_file_txt = str_replace("URL", $url, $body_file_txt);

		//set up the email
		$mail = $this->mail;

		//send email to barnraiser
		$mail->Body = $body_file_txt;
		$mail->AddAddress($email, $firstname);

		if(!$mail->Send())
		{
		   $error[1] =  "Mailer Error: " . $mail->ErrorInfo;
		}
		else
		{
		   //Message has been sent
		   $error[0] = "sent";
		}
	}


	/*
	* Get short format of user details
	* erik sundelöf
	* 4 april 2004
	*/
	function getUserShortDetail($user_id=null) {

		if(!$user_id) {
			// Forming query and selecting the messages with the correct owner id:s...
			$query = "
			SELECT DISTINCT user_id, user_firstname, user_surname FROM " . $this->db->prefix . "_user"
			;
		}
		else {
			// Forming query and selecting the messages with the correct owner id:s...
			$query = "
			SELECT user_firstname, user_surname FROM " . $this->db->prefix . "_user WHERE user_id=". $user_id;
			;
		}

		// Getting the message_box list
		$result = $this->db->Execute($query);

		// Listing...
		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
			$temp = "";
		}
		else {

			$temp = array();

			while (!$result->EOF) {
				array_push($temp, $result->fields);
				$result->MoveNext();
			}

			$result->Close();
		}

		// Return the message list or empty if unsuccessful
		return $temp;

	}

	// Useful help function
	function getAllUsers() {
		return $this->getUserShortDetail();
	}

	// Another useful help function
	function getUser($user_id) {
		$temp = $this->getUserShortDetail($user_id);
		return array_pop($temp);
	}



	/*
	* USER DETAILS
	* tom calthrop
	* 21st Feb 2004
	*/
	function userStatistics ($user_id = null) {
		if (!isset($user_id)) {
		    $user_id = $this->user_id;
		}

		$query = "
			SELECT us.statistic_type_id, us.total
			FROM " . $this->db->prefix . "_user_statistic us
			where
			us.user_id=" . $user_id . "
			order by us.statistic_type_id"
		;

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else if ($result) {

			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();

			return $temp;
		}
	}


	/*
	* INSERT USER RELATION
	* tom calthrop
	* 21st April 2004
	*/
	function insertRelation ($relation_id, $type) {

		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		if (!$this->checkRelation($this->user_id, $relation_id)) {
			$query =
				"INSERT INTO " . $this->db->prefix . "_relation
				(user_id, user_id_friend, node_id, relation_create_datetime, type )
				VALUES (
				'" . $this->user_id . "',
				'" . $relation_id . "',
				'" . $this->node_id . "',
				" . $datetime . ",
				'" . $type . "'
				)"
			;
			//echo $query;
			$result = $this->db->Execute($query);

			if ($result) {

				if (!$this->checkRelation($relation_id, $this->user_id)) {
					$query =
						"INSERT INTO " . $this->db->prefix . "_relation
						(user_id, user_id_friend, node_id, relation_create_datetime, type )
						VALUES (
						'" . $relation_id . "',
						'" . $this->user_id . "',
						'" . $this->node_id . "',
						" . $datetime . ",
						'" . $type . "'
						)"
					;
					//echo $query;
					$result = $this->db->Execute($query);

					if ($result) {
						return true;
					}
				}
			}
		}
	}


	/*
	* UPDATE USER RELATION
	* tom calthrop
	* 21st April 2004
	*/
	function updateRelation ($relation_id) {

		if ($this->checkRelation($this->user_id, $relation_id)) {
			$query =
				"UPDATE " . $this->db->prefix . "_relation SET
				type=" . $this->relation_type . "
				WHERE
				user_id=" . $this->user_id .  " and
				user_id_friend=" . $relation_id . "
				limit 1"
			;
			//echo $query;
			$result = $this->db->Execute($query);

			if ($result) {

				if ($this->checkRelation($relation_id, $this->user_id)) {
					$query =
						"UPDATE " . $this->db->prefix . "_relation SET
						type=" . $this->relation_type . "
						WHERE
						user_id=" . $relation_id .  " and
						user_id_friend=" . $this->user_id . "
						limit 1"
					;
					//echo $query;
					$result = $this->db->Execute($query);

					if ($result) {

						//rebuild social network
						$_SESSION['s_social_network'] = $this->setSocialNetwork($this->user_id);

						return true;
					}
				}
			}
		}
	}//EO updateRelation

	/*
	* CHECK RELATION
	* checks if record matches in br_relation
	* tom calthrop
	* 22nd April 2004
	*/
	function checkRelation ($user_id, $relation_id) {

		$query = "
			SELECT user_id
			FROM " . $this->db->prefix . "_relation
			where
			user_id=" . $user_id . " and
			user_id_friend=" . $relation_id
		;

		$result = $this->db->Execute($query);

		if (isset($result->fields['user_id']) && $result->fields['user_id'] > 0) {

			return true;
		}
	}


	/*
	*SET USER STATISTIC
	* tom calthrop
	* 6th May 2004
	*/
	function setStatistic ($statistic_type_id, $total = null) {

		//get total
		$query = "
			SELECT total
			FROM
			" . $this->db->prefix . "_user_statistic
			WHERE
			statistic_type_id=" . $statistic_type_id . " and
			user_id=" . $this->user_id . " limit 1"
		;

		$result = $this->db->Execute($query);


		if (isset($result->fields['total'])) {
			//we update
			if (!isset($total)) {
			    $total = $result->fields['total'] +1;
			}


			$query = "
				UPDATE " . $this->db->prefix . "_user_statistic
				SET total=" . $total . "
				WHERE
				user_id=" . $this->user_id . " and
				statistic_type_id=" . $statistic_type_id
			;

			$result1 = $this->db->Execute($query);

		}
		else {
			//we need to insert
			if (!isset($total)) {
			    $total = 1;
			}

			$query = "
				INSERT INTO " . $this->db->prefix . "_user_statistic
				(user_id, statistic_type_id, total) values
				(
				" . $this->user_id . ",
				" . $statistic_type_id . ",
				" . $total . ")"
			;

			$result1 = $this->db->Execute($query);

		}

		if (!isset($result1)) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else if ($result) {

			return true;
		}
	}

	/*
	* insertLanguages
	* tom calthrop
	* 18th Nov 2004
	*/
	function insertLanguages($in_arr) {
		$rownums = count ($in_arr);

		for ($i=0; $i < $rownums; $i++) {
			$query = "
				INSERT INTO " . $this->db->prefix . "_user_language 
				(user_id, language_id) VALUES (
				" . $this->user_id . ", 
				" . $in_arr[$i] . ")"
			;
			
			$result = $this->db->Execute($query);

			if (empty($result)) {
				$this->log[]  = array('error', 1, $this->db->ErrorMsg());
			}
		}
		
	}
	
	/*
	* deleteLanguages
	* tom calthrop
	* 18th Nov 2004
	*/
	function deleteLanguages() {

		$query = "
			DELETE FROM " . $this->db->prefix . "_user_language 
			WHERE
			user_id=" . $this->user_id
		;

		$result = $this->db->Execute($query);

		if (isset($result)) {
			return true;
		}
		else {
			$this->log[]  = array('error', 1, $this->db->ErrorMsg());
		}
	}
	
	/*
	* getLanguages
	* get the languages that the user can read
	* tom calthrop
	* 18th Nov 2004
	*/
	function getLanguages() {
		$query = "
			SELECT language_id FROM " . $this->db->prefix . "_user_language 
			WHERE
			user_id=" . $this->user_id
		;
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				array_push($temp, $result->fields['language_id']);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$this->log[] = array('error', 1, $this->db->ErrorMsg());
		}
	}
}
