<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

class Bookmark {
	// Instance variables
	var $user_id;                        // User id
	var $db;                             // get db connect
	var $date;                           // get date for date formatting
	var $image;                          // get image for images data retrieval
	var $poll;                           // get poll for date formatting
	
	

	function Bookmark($user_id, $db, $date, $image, $poll) {
		$this->user_id = $user_id;
		$this->db = $db;
		$this->date = $date;
		$this->image = $image;
		$this->poll = $poll;
	}


	/*
	* LIST BOOKMARKED GROUPS
	* tom calthrop
	* 25th Jan 2004
	*/
	function displayGroup($group_status) {
		$query = "
			SELECT g.group_title, g.group_id, g.group_synopsis, 
			g.group_image_id
			FROM " . $this->db->prefix . "_group_bookmark b
			LEFT JOIN " . $this->db->prefix . "_group g on b.group_id=g.group_id
			where
			b.user_id=" . $this->user_id . " and
			b.bookmark_type=" . $this->bookmark_type . " and
			g.group_status=" . $group_status . "
			order by g.group_title"
			;

		$result = $this->db->Execute($query);

		if (isset($result)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;

				if ($temp1['group_image_id']) {
					$temp1['image'] = $this->image->getImage($temp1['group_image_id'], 't2', 'group', $temp1['group_id']);
				}
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}

			
	}



	/*
	* LIST BOOKMARKED SUBJECTS
	* tom calthrop
	* 25th Jan 2004
	*/
	function displaySubjects() {
		$query = "
			SELECT s.subject_id, s.subject_title, s.subject_body, s.poll_id, 
			se.group_id , t.topic_id
			FROM " . $this->db->prefix . "_forum_subject_movement b
			RIGHT JOIN " . $this->db->prefix . "_forum_subject s on b.subject_id=s.subject_id
			LEFT JOIN " . $this->db->prefix . "_forum_topic t ON s.topic_id=t.topic_id
			LEFT JOIN " . $this->db->prefix . "_forum_section se ON t.section_id=se.section_id
			where
			b.user_id=" . $this->user_id . " and
			b.subject_id > 0 and ";
			
			if ($this->bookmark_type == 1) {
			    $query .= "watch=1 ";
			}
			elseif ($this->bookmark_type == 2) {
			    $query .= "recommend=1 ";
			}
			
			$query .= "
			order by s.subject_title"
		;
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {

			$temp = array();

			while (!$result->EOF) {

				$temp1 = $result->fields;
				if (isset($temp1['poll_id'])&& $temp1['poll_id'] > 0) {
					$this->poll->poll_id = $temp1['poll_id'];
		   			$temp1['poll'] = $this->poll->getPoll();
				}
				
				$this->forum->subject_id = $temp1['subject_id'];
				
				//get the bookmarks and last view datetime
				$temp1['movement'] = $this->forum->getSubjectMovement();
				
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$this->log[]  = array('error', 1, $this->db->ErrorMsg());
		}
	}



	/*
	* LIST BOOKMARKED FORUM
	* tom calthrop
	* 25th Jan 2004
	*/
	function displayTopics() {
		$query = "
			SELECT t.topic_id, t.topic_title, t.topic_body, t.topic_image_id, fs.group_id 
			FROM " . $this->db->prefix . "_forum_topic_movement b
			RIGHT JOIN " . $this->db->prefix . "_forum_topic t on b.topic_id=t.topic_id
			LEFT JOIN " . $this->db->prefix . "_forum_section fs ON t.section_id=fs.section_id
			where
			b.user_id=" . $this->user_id . " and
			b.topic_id > 0 and ";
			
			if ($this->bookmark_type == 1) {
			    $query .= "watch=1 ";
			}
			elseif ($this->bookmark_type == 2) {
			    $query .= "recommend=1 ";
			}
			
			$query .= "
			order by t.topic_title"
		;
		//echo $query;
		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {

			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				if ($temp1['topic_image_id']) {
					$temp1['image'] = $this->image->getImage($temp1['topic_image_id'], 't2', 'group', $temp1['group_id']);
				}
				
				$this->forum->topic_id = $temp1['topic_id'];
				
				//get the bookmarks and last view datetime
				$temp1['movement'] = $this->forum->getTopicMovement();
				
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
	}


	/*
	* LIST BOOKMARKED LIBRARY
	* tom calthrop
	* 25th Jan 2004
	*/
	function displayLibrary() {
		$query = "
			SELECT DISTINCT l.library_title, l.library_page_name, l.library_synopsis, 
			l.group_id, l.library_image_id
			FROM " . $this->db->prefix . "_group_library_bookmark b, 
			" . $this->db->prefix . "_group_library l 
			where
			l.library_page_name=b.library_page_name and 
			l.group_id=b.group_id and 
			b.user_id=" . $this->user_id . " and
			b.bookmark_type=" . $this->bookmark_type . "
			order by l.library_title"
		;
		//echo $query . "<br><br>";
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {

			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				if ($temp1['library_image_id']) {
					$temp1['image'] = $this->image->getImage($temp1['library_image_id'], 't2', 'group', $temp1['group_id']);
				}
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$this->log[]  = array('error', 1, $this->db->ErrorMsg());
		}
	}



	/*
	* LIST BOOKMARKED BLOG
	* tom calthrop
	* 25th Jan 2004
	*/
	function displayBlog() {
		$query = "
			SELECT b.blog_title, b.blog_id, b.blog_create_datetime, b.blog_synopsis,
			u.user_nic, b.blog_id, bm.user_id
			FROM " . $this->db->prefix . "_blog_bookmark bm, " . $this->db->prefix . "_blog b
			LEFT JOIN " . $this->db->prefix . "_user u on b.user_id=u.user_id
			where
			bm.blog_id=b.blog_id and
			bm.user_id=" . $this->user_id . " and
			bm.bookmark_type=" . $this->bookmark_type
		;
		
		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			//for each blog get the newest item
			$temp = array();

			while (!$result->EOF) {

				$temp1 = $result->fields;

				$temp1['blog_create_datetime'] = $this->date->formatDate($temp1['blog_create_datetime']);

				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
	}



	/*
	* LIST BOOKMARKED EVENT
	* tom calthrop
	* 25th Jan 2004
	*/
	function displayEvent() {
		$query = "

			SELECT e.event_title, e.event_id, e.event_description, e.event_start_datetime,
			e.group_id, e.event_image_id
			FROM " . $this->db->prefix . "_event_bookmark b
			LEFT JOIN " . $this->db->prefix . "_event e on b.event_id=e.event_id
			where
			b.user_id=" . $this->user_id . " and
			b.bookmark_type=" . $this->bookmark_type . "
			order by e.event_title"
			;

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {

			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				if ($temp1['event_image_id']) {
					$temp1['image'] = $this->image->getImage($temp1['event_image_id'], 't2', 'group', $temp1['group_id']);
				}
				$temp1['event_start_datetime'] = $this->date->formatDate($temp1['event_start_datetime']);
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
	}



	/*
	* DELETE BOOKMARKED GROUP ITEMS
	* tom calthrop
	* 25th Jan 2004
	*/
	function deleteGroupItems($del_arr) {
		$rownums = count ($del_arr);

		//echo $rownums;

		for ($i=0; $i < $rownums; $i++) {
			$query = "
				DELETE from " . $this->db->prefix . "_group_bookmark
				WHERE
				group_id = " . $del_arr[$i] . " and
				user_id=" . $this->user_id . " and
				bookmark_type=" . $this->bookmark_type
				;

			$result = $this->db->Execute($query);

			if (isset($result->fields)) {
				$result->Close();
			}
		}
	}


	/*
	* DELETE BOOKMARKED FORUM ITEMS - TOPIC
	* tom calthrop
	* 25th Jan 2004
	*/
	function deleteTopicItems($del_arr) {
		$rownums = count ($del_arr);

		//echo $rownums;

		for ($i=0; $i < $rownums; $i++) {
			$query = "
				UPDATE " . $this->db->prefix . "_forum_topic_movement SET ";
			
			if ($this->bookmark_type == 1) {
			    $query .= "watch=null ";
			}
			elseif ($this->bookmark_type == 2) {
			    $query .= "recommend=null ";
			}
			
			$query .= "
				WHERE 
				topic_id=" . $del_arr[$i] . " and 
				user_id=" . $this->user_id
			;
			
			$result = $this->db->Execute($query);

			if (isset($result->fields)) {
				$result->Close();
			}
		}
	}



	/*
	* DELETE BOOKMARKED FORUM ITEMS - SUBJECT
	* tom calthrop
	* 25th Jan 2004
	*/
	function deleteSubjectItems($del_arr) {
		$rownums = count ($del_arr);

		//echo $rownums;

		for ($i=0; $i < $rownums; $i++) {
			$query = "
				UPDATE " . $this->db->prefix . "_forum_subject_movement SET ";
			
			if ($this->bookmark_type == 1) {
			    $query .= "watch=null ";
			}
			elseif ($this->bookmark_type == 2) {
			    $query .= "recommend=null ";
			}
			
			$query .= "
				WHERE 
				subject_id=" . $del_arr[$i] . " and 
				user_id=" . $this->user_id
			;
		
			$result = $this->db->Execute($query);

			if (isset($result->fields)) {
				$result->Close();
			}
		}
	}



	/*
	* DELETE BOOKMARKED LIBRARY ITEMS
	* tom calthrop
	* 25th Jan 2004
	*/
	function deleteLibraryItems($del_arr) {
		$rownums = count ($del_arr);

		//echo $rownums;

		for ($i=0; $i < $rownums; $i++) {
			$query = "
				DELETE from " . $this->db->prefix . "_group_library_bookmark
				WHERE
				library_page_name='" . $del_arr[$i] . "' and
				user_id=" . $this->user_id . " and
				bookmark_type=" . $this->bookmark_type
				;
			//echo $query;
			$result = $this->db->Execute($query);

			if (isset($result->fields)) {
				$result->Close();
			}
		}
	}



	/*
	* DELETE BOOKMARKED EVENT ITEMS
	* tom calthrop
	* 25th Jan 2004
	*/
	function deleteEventItems($del_arr) {
		$rownums = count ($del_arr);

		//echo $rownums;

		for ($i=0; $i < $rownums; $i++) {
			$query = "
				DELETE from " . $this->db->prefix . "_event_bookmark
				WHERE
				event_id = " . $del_arr[$i] . " and
				user_id=" . $this->user_id . " and
				bookmark_type=" . $this->bookmark_type
				;

			$result = $this->db->Execute($query);

			if (isset($result->fields)) {
				$result->Close();
			}
		}
	}



	/*
	* DELETE BOOKMARKED BLOG ITEMS
	* tom calthrop
	* 25th Jan 2004
	*/
	function deleteBlogItems($del_arr) {
		$rownums = count ($del_arr);

		//echo $rownums;

		for ($i=0; $i < $rownums; $i++) {
			$query = "
				DELETE from " . $this->db->prefix . "_blog_bookmark
				WHERE
				blog_id = " . $del_arr[$i] . " and
				user_id=" . $this->user_id . " and
				bookmark_type=" . $this->bookmark_type
			;
			//echo $query . "<br>";
			$result = $this->db->Execute($query);

			if (isset($result->fields)) {
				$result->Close();
			}
		}
	}
}
?>
