<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------



class Forum {

	var $group_id, $forum_id, $db, $query, $result, $temp, $poll, $image, $date;

	function Forum($group_id = null) {
		$this->group_id = $group_id;

	}

	/*
	* SECTION DETAILS
	* tom calthrop
	* 21st Feb 2004
	*/
	function sectionDetails () {
		$query = "
			SELECT s.*
			FROM " . $this->db->prefix . "_forum_section s
			where
			s.section_id=" . $this->section_id
		;

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else if ($result) {

			$temp = $result->fields;
			$result->Close();

			return $temp;
		}
	}


	/*
	* SECTION LIST
	* tom calthrop
	* 21st Feb 2004
	*/
	function sectionList () {
		$query = "
			SELECT s.*
			FROM " . $this->db->prefix . "_forum_section s
			where
			s.group_id=" . $this->group_id . "
			order by s.section_title"
		;

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else if ($result) {

			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;

				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
	}


	/*
	* SECTION LIST
	* tom calthrop
	* 21st Feb 2004
	*/
	function sectionTopicList () {
		$query = "
			SELECT s.*
			FROM " . $this->db->prefix . "_forum_section s
			where
			s.group_id=" . $this->group_id . "
			order by s.section_title"
		;

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else if ($result) {

			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;

				$temp1['topics'] = $this->topicList ($result->fields['section_id']);

				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
	}



	/*
	* TOPIC LIST
	* tom calthrop
	* 21st Feb 2004
	*/
	function topicList ($section_id = null) {

		if (empty($section_id)) {
		   $section_id = $this->section_id;
		}

		$query = "
			SELECT t.*
			FROM " . $this->db->prefix . "_forum_topic t
			where
			t.section_id=" . $section_id
		;

		if (isset($this->level_id)) {
		   $query .= " and t.level_id=" . $this->level_id;
		}

		$query .= " order by t.topic_sticky desc, t.topic_title";

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else if ($result) {

			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;

				if ($temp1['topic_image_id']) {
				    $temp1['image'] = $this->image->getImage($result->fields['topic_image_id']);
				}

				$this->topic_id = $result->fields['topic_id'];
				
				//get the bookmarks and last view datetime
				$temp1['movement'] = $this->getTopicMovement();
				
				if ($temp1['subject_total'] < 1) {
				    $temp1['subject_total'] = 0;
				}

				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
	}

	/*
	* TOPIC COUNT (you cannot delete a section with topics)
	* tom calthrop
	* 21st Feb 2004
	*/
	function topicCount () {
		$query = "
			SELECT count(t.topic_id) as total
			FROM " . $this->db->prefix . "_forum_topic t
			where
			t.section_id=" . $this->section_id
		;

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else if ($result) {

			$temp = $result->fields['total'];

			$result->Close();
			return $temp;
		}
	}


	/*
	* GROUP REPLY COUNT (for group stats)
	* tom calthrop
	* 6th May 2004
	*/
	function groupReplyCount () {
		$query = "
			SELECT count(r.reply_id) as total
			FROM " . $this->db->prefix . "_forum_reply r, " . $this->db->prefix . "_forum_subject s, " . $this->db->prefix . "_forum_topic t, " . $this->db->prefix . "_forum_section se
			where
			r.subject_id = s.subject_id and
			s.topic_id = t.topic_id and
			se.section_id = t.section_id and
			se.group_id=" . $this->group_id
		;

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else if ($result) {

			$temp = $result->fields['total'];

			$result->Close();
			return $temp;
		}
	}


	/*
	* GROUP SUBJECT COUNT (for group stats)
	* tom calthrop
	* 6th May 2004
	*/
	function groupSubjectCount () {
		$query = "
			SELECT count(s.subject_id) as total
			FROM " . $this->db->prefix . "_forum_subject s, " . $this->db->prefix . "_forum_topic t, " . $this->db->prefix . "_forum_section se
			where
			s.topic_id = t.topic_id and
			se.section_id = t.section_id and
			se.group_id=" . $this->group_id
		;

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else if ($result) {

			$temp = $result->fields['total'];

			$result->Close();
			return $temp;
		}
	}


	/*
	* GROUP TOPIC COUNT (for group stats)
	* tom calthrop
	* 6th May 2004
	*/
	function groupTopicCount () {
		$query = "
			SELECT count(t.topic_id) as total
			FROM " . $this->db->prefix . "_forum_topic t, " . $this->db->prefix . "_forum_section s
			where
			s.section_id = t.section_id and
			s.group_id=" . $this->group_id
		;

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else if ($result) {

			$temp = $result->fields['total'];

			$result->Close();
			return $temp;
		}
	}


	/*
	* SUBJECT COUNT (you cannot delete a topic with subjects)
	* tom calthrop
	* 21st Feb 2004
	*/
	function subjectCount () {
		$query = "
			SELECT count(s.subject_id) as total
			FROM " . $this->db->prefix . "_forum_subject s
			where
			s.topic_id=" . $this->topic_id
		;

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else if ($result) {

			$temp = $result->fields['total'];

			$result->Close();
			return $temp;
		}
	}


	/*
	* TOPIC DETAILS
	* tom calthrop
	* 21st Feb 2004
	*/
	function topicDetails () {
		$query = "
			SELECT t.*, fs.group_id
			FROM " . $this->db->prefix . "_forum_topic t
			LEFT JOIN " . $this->db->prefix . "_forum_section fs ON t.section_id=fs.section_id
			where
			t.topic_id=" . $this->topic_id
		;

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else if ($result) {

			$temp = $result->fields;

			//$temp['bookmark'] = $this->forumBookmark($result->fields['topic_id'], $this->user_id, $this->bookmark_watching_id);

			if ($temp['topic_image_id']) {
				$temp['image'] = $this->image->getImage($result->fields['topic_image_id']);
			}

			//$temp['new_subjects'] = $temp['subject_total'] - $temp['bookmark']['movement'];

			$temp['display_topic_body'] = nl2br($temp['topic_body']);

			$result->Close();

			return $temp;
		}
	}


	/*
	* SUBJECT LIST
	* tom calthrop
	* 21st Feb 2004
	*/
	function subjectList () {
		$query = "
			SELECT s.*
			FROM " . $this->db->prefix . "_forum_subject s
			where
			s.topic_id=" . $this->topic_id . "
			order by s.subject_sticky desc, s.subject_title"
		;
		
		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else if ($result) {

			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;

				if ($temp1['poll_id']) {
					$this->poll->poll_id = $temp1['poll_id'];
					$temp2 = $this->poll->getPoll();

					//if the poll has not started yet we remove it
					$datetime = date("Y-m-d H:i:s");
					if ($datetime > $temp2['poll_start_datetime']) {
					   $temp1['poll'] = $temp2;
					   $temp1['poll']['current_answer'] = $this->poll->pollUserCurrentVote($this->user_id);
					}
				}

				if ($temp1['subject_image_id']) {
					$temp1['image'] = $this->image->getImage($result->fields['subject_image_id']);
				}

				$temp1['subject_create_datetime'] = $this->date->formatDate($temp1['subject_create_datetime']);

				$temp1['subject_body'] = nl2br($temp1['subject_body']);

				if ($temp1['reply_total'] < 1) {
				    $temp1['reply_total'] = 0;
				}

				$this->subject_id = $temp1['subject_id'];
				
				//get the bookmarks and last view datetime
				$temp1['movement'] = $this->getSubjectMovement();
				
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
	}


	/*
	* SUBJECT DETAILS
	* tom calthrop
	* 21st Feb 2004
	*/
	function subjectDetails () {
		$query = "
			SELECT s.*
			FROM " . $this->db->prefix . "_forum_subject s
			where
			s.subject_id=" . $this->subject_id
		;

		$result = $this->db->Execute($query);

		if (isset($result)) {

			$temp = $result->fields;
			$temp['subject_create_datetime'] = $this->date->formatDate($temp['subject_create_datetime']);

			if (isset($temp['poll_id']) && $temp['poll_id'] > 0) {
				$this->poll->poll_id = $temp['poll_id'];
				$temp1 = $this->poll->getPoll();

				//if the poll has not started yet we remove it
				$datetime = date("Y-m-d H:i:s");
				if ($datetime > $temp1['poll_start_datetime']) {
					
					$temp['poll'] = $temp1;
					$temp['poll']['current_answer'] = $this->poll->pollUserCurrentVote($this->user_id);
				}
			}

			if ($temp['subject_image_id']) {
				$temp['image'] = $this->image->getImage($result->fields['subject_image_id']);
			}

			$temp['display_subject_body'] = nl2br($temp['subject_body']);

			$result->Close();

			return $temp;
		}
		else {
			$this->log[] = array('error', 1, $this->db->ErrorMsg());
		}
	}





	/*
	* SUBJECT LIST
	* tom calthrop
	* 21st Feb 2004
	*/
	function replyList () {
		$query = "
			SELECT r.*
			FROM " . $this->db->prefix . "_forum_reply r
			where
			r.subject_id=" . $this->subject_id . "
			order by r.reply_create_datetime"
		;
		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else if ($result) {

			$output = array();

			while (!$result->EOF) {
				$temp = $result->fields;
				$temp['reply_body'] = nl2br($temp['reply_body']);
				$temp['reply_create_datetime'] = $this->date->formatDate($temp['reply_create_datetime']);
				array_push($output, $temp);
				$result->MoveNext();
			}

			$result->Close();
			return $output;
		}
	}


	/*
	* INSERT FORUM SECTION
	* * tom calthrop
	* 8th Jan 2004
	*/
	function insertSection($section_title) {

		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		$query = "
			INSERT INTO " . $this->db->prefix . "_forum_section
			(group_id, section_title, section_create_datetime, user_id)
			values (
			'" . $this->group_id . "',
			'" . $section_title . "',
			" . $datetime . ",
			'" . $this->user_id . "')"
		;

		//echo $query;
		$result = $this->db->Execute($query);

		if (!$result) {
			$state[] =  array('error', 1, $this->db->ErrorMsg());
		}

		if (!isset($state)) {
		    $state[]  = array('success', 2);
		}

		return $state;
	}



	/*
	* UPDATE FORUM SECTION
	* * tom calthrop
	* 8th Jan 2004
	*/
	function updateSection($section_id, $section_title) {

		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		$query = "
			UPDATE " . $this->db->prefix . "_forum_section set
			section_title = '" . $section_title . "',
			section_edit_datetime = " . $datetime . ",
			user_id_edit = " . $this->user_id . "
			WHERE
			section_id =" . $section_id;
			;

		//echo $query;
		$result = $this->db->Execute($query);

		if (!$result) {
			$state[] =  array('error', 1, $this->db->ErrorMsg());
		}

		if (!isset($state)) {
		    $state[]  = array('success', 3);
		}

		return $state;
	}



	/*
	* DELETE FORUM SECTION
	* * tom calthrop
	* 8th Jan 2004
	*/
	function deleteSection($section_id) {

		$query = "
			DELETE FROM " . $this->db->prefix . "_forum_section
			WHERE
			section_id =" . $section_id;
			;

		//echo $query;
		$result = $this->db->Execute($query);

		if (!$result) {
			$state[] =  array('error', 1, $this->db->ErrorMsg());
		}

		if (!isset($state)) {
		    $state[]  = array('success', 4);
		}

		return $state;
	}


	/*
	* INSERT FORUM TOPIC
	* * tom calthrop
	* 8th Jan 2004
	*/
	function insertTopic($section_id, $topic_title, $topic_body, $topic_image_id, $level_id) {

		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		if (!isset($level_id)) {
		    $level_id = "NULL";
		}

		if (!isset($topic_image_id)) {
		    $topic_image_id = "NULL";
		}

		if (!isset($topic_sticky)) {
		    $topic_sticky = "NULL";
		}

		if (!isset($topic_locked)) {
		    $topic_locked = "NULL";
		}

		//echo "hh" . $topic_image_id;

		$query = "
			INSERT INTO " . $this->db->prefix . "_forum_topic
			(section_id, topic_title, topic_body, topic_create_datetime, user_id, topic_image_id, topic_sticky, topic_locked, level_id)
			values (
			'" . $section_id . "',
			'" . $topic_title . "',
			'" . $topic_body . "',
			" . $datetime . ",
			'" . $this->user_id . "',
			" . $topic_image_id . ",
			" . $topic_sticky . ",
			" . $topic_locked . ",
			" . $level_id . ")"
		;

		//echo $query . "<br>";
		$result = $this->db->Execute($query);

		if (!$result) {
			$state[] =  array('error', 1, $this->db->ErrorMsg());
		}

		if (!isset($state)) {
		    $state[]  = array('success', 2);
		}

		return $state;
	}

	/*
	* UPDATE FORUM TOPIC
	* * tom calthrop
	* 8th Jan 2004
	*/
	function updateTopic($topic_id, $section_id, $topic_title, $topic_body, $topic_sticky, $topic_locked, $topic_image_id, $level_id) {

		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		if (!isset($level_id)) {
		    $level_id = "NULL";
		}


		if (empty($level_id)) {
			$level_id = "null";
		}

		$query = "
			UPDATE " . $this->db->prefix . "_forum_topic SET
			section_id = '" . $section_id . "',
			topic_title = '" . $topic_title . "',
			topic_body = '" . $topic_body . "',
			topic_edit_datetime = " . $datetime . ",
			user_id_edit = '" . $this->user_id . "',
			topic_sticky = " . $topic_sticky . ",
			topic_locked = " . $topic_locked . ",
			level_id = " . $level_id . ",
			topic_image_id = " . $topic_image_id . "
			WHERE
			topic_id =" . $topic_id;
		;

		//echo $query . "<br>";
		$result = $this->db->Execute($query);

		if (!$result) {
			$state[] =  array('error', 1, $this->db->ErrorMsg());
		}

		if (!isset($state)) {
		    $state[]  = array('success', 3);
		}

		return $state;
	}





	/*
	* DELETE FORUM TOPIC
	* * tom calthrop
	* 8th Jan 2004
	*/
	function deleteTopic($topic_id) {

		$query = "
			DELETE FROM " . $this->db->prefix . "_forum_topic
			WHERE
			topic_id =" . $topic_id;
			;

		//echo $query;
		$result = $this->db->Execute($query);

		if (!$result) {
			$state[] =  array('error', 1, $this->db->ErrorMsg());
		}

		if (!isset($state)) {
		    $state[]  = array('success', 4);
		}

		return $state;
	}



	/*
	* INSERT FORUM REPLY
	* * tom calthrop
	* 8th Jan 2004
	*/
	function insertReply($subject_id, $reply_body) {

		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		$query = "
			INSERT INTO " . $this->db->prefix . "_forum_reply
			(subject_id, reply_body, reply_create_datetime, user_id)
			values (
			'" . $subject_id . "',
			'" . $reply_body . "',
			" . $datetime . ",
			'" . $this->user_id . "')"
		;

		$result = $this->db->Execute($query);
		
		if (isset($result)) {
			$this->updateTotalReplies($subject_id);
			$this->log[] = array('success', 2);
			return true;
		}
		else {
			$this->log[] = array('error', 1, $this->db->ErrorMsg());
			return false;
		}
	}


	/*
	* UPDATE TOTAL REPLIES FOR SUBJECT
	* * tom calthrop
	* 8th Jan 2004
	*/
	function updateTotalReplies($subject_id) {

		$query = "
			SELECT count(reply_id) as totalreplies FROM " . $this->db->prefix . "_forum_reply WHERE subject_id=" . $subject_id;
		;

		$result = $this->db->Execute($query);

		$query = "
			UPDATE " . $this->db->prefix . "_forum_subject SET
			reply_total  = '" . $result->fields['totalreplies'] . "'
			WHERE
			subject_id =" . $subject_id;
		;
		//echo $query;
		
		$result = $this->db->Execute($query);
	}


	/*
	* UPDATE TOTAL SUBJECTS FOR A TOPIC
	* tom calthrop
	* 6th April 2004
	*/
	function updateTotalSubjects($topic_id) {

		$query = "
			SELECT count(subject_id) as totalsubjects FROM " . $this->db->prefix . "_forum_subject WHERE topic_id=" . $topic_id;
		;

		$result = $this->db->Execute($query);

		$query = "
			UPDATE " . $this->db->prefix . "_forum_topic SET
			subject_total  = '" . $result->fields['totalsubjects'] . "'
			WHERE
			topic_id =" . $topic_id;
		;

		$result = $this->db->Execute($query);
	}


	/*
	* INSERT FORUM SUBJECT
	* * tom calthrop
	* 8th Jan 2004
	*/
	function insertSubject($topic_id, $subject_title, $subject_body, $subject_image_id, $poll_id, $subject_sticky, $subject_locked, $level_id) {
		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		if (!isset($level_id)) {
		    $level_id = "NULL";
		}

		if (!isset($subject_image_id)) {
		    $subject_image_id = "NULL";
		}

		if (!isset($poll_id)) {
		    $poll_id = "NULL";
		}

		if (!isset($subject_sticky)) {
		    $subject_sticky = "NULL";
		}

		if (!isset($subject_locked)) {
		    $subject_locked = "NULL";
		}
		//echo "hh" . $topic_image_id;

		$query = "
			INSERT INTO " . $this->db->prefix . "_forum_subject
			(topic_id, subject_title, subject_body, subject_create_datetime, user_id, subject_image_id, poll_id, subject_sticky, subject_locked, level_id)
			values (
			'" . $topic_id . "',
			'" . $subject_title . "',
			'" . $subject_body . "',
			" . $datetime . ",
			'" . $this->user_id . "',
			" . $subject_image_id . ",
			" . $poll_id . ",
			" . $subject_sticky . ",
			" . $subject_locked . ",
			" . $level_id . ")"
		;

		//echo $query . "<br>";
		$result = $this->db->Execute($query);

		if (!$result) {
			$state[] =  array('error', 1, $this->db->ErrorMsg());
		}

		if (!isset($state)) {
			//update topic with new subject count
			$this->updateTotalSubjects ($topic_id);

		    $state[]  = array('success', 2);
		}

		return $state;
	}


	/*
	* UPDATE FORUM SUBJECT
	* * tom calthrop
	* 8th Jan 2004
	*/
	function updateSubject($data) {
		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		if (empty($data['level_id'])) {
		    $data['level_id'] = "null";
		}

		if (empty($data['subject_sticky'])) {
	    	$data['subject_sticky'] = "null";
		}

		if (empty($data['subject_locked'])) {
		    $data['subject_locked'] = "null";
		}

		if (empty($data['subject_image_id'])) {
		    $data['subject_image_id'] = "null";
		}

		if (empty($data['poll_id'])) {
		    $data['poll_id'] = "null";
		}

		$query = "
			UPDATE " . $this->db->prefix . "_forum_subject SET
			topic_id = '" . $data['topic_id'] . "',
			subject_title = '" . $data['subject_title'] . "',
			subject_body = '" . $data['subject_body'] . "',
			subject_edit_datetime = " . $datetime . ",
			user_id_edit = '" . $this->user_id . "',
			subject_sticky = " . $data['subject_sticky'] . ",
			subject_locked = " . $data['subject_locked'] . ",
			poll_id = " . $data['poll_id'] . ",
			level_id = " . $data['level_id'] . ",
			subject_image_id = " . $data['subject_image_id'] . "
			WHERE
			subject_id =" . $data['subject_id'];
		;

		//echo $query . "<br>";
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$this->log[] = array('success', 3);
			return true;
		}
		else {
			$this->log[] = array('error', 1, $this->db->ErrorMsg());
			return false;
		}
	}

	/*
	* DELETE FORUM SUBJECT
	* tom calthrop
	* 5th April 2004
	*/
	function deleteSubject($subject_id) {

		$query = "
			DELETE FROM " . $this->db->prefix . "_forum_subject
			WHERE
			subject_id =" . $subject_id;
			;

		//echo $query;
		$result = $this->db->Execute($query);

		if (isset($result)) {
			//delete replies (posts)
			$this->deleteReplies($subject_id);

			//update topic with new subject count
			$this->updateTotalSubjects ($subject_id);
			$this->log[] = array('success', 4);
			return true;
		}
		else {
			$this->log[] = array('error', 1, $this->db->ErrorMsg());
			return false;
		}
	}

	/*
	* DELETE FORUM REPLIES
	* tom calthrop
	* 21st April 2004
	*/
	function deleteReplies($subject_id) {

		$query = "
			DELETE FROM " . $this->db->prefix . "_forum_reply
			WHERE
			subject_id =" . $subject_id;
			;

		//echo $query;
		$result = $this->db->Execute($query);

		if (isset($result)) {
			$this->log[] = array('success', 4);
			return true;
		}
		else {
			$this->log[] = array('error', 1, $this->db->ErrorMsg());
			return false;
		}
	}
	
	
	/*
	* GET TOPIC BOOKMARK
	* tom calthrop
	* 23rd November 2004
	*/
	function getTopicBookmark () {
		
		$query = "
			SELECT bm.recommend, bm.watch 
			FROM " . $this->db->prefix . "_forum_bookmark bm
			where
			bm.topic_id=" . $this->topic_id . " and
			bm.user_id=" . $this->user_id
		;
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			$temp = $result->fields;
			$result->Close();
		}
	}
	
	
	/*
	* GET SUPJECT MOVEMENT
	* tom calthrop
	* We get the movement of the subject from when we last looked to now.
	* 23rd November 2004
	*/
	function getSubjectMovement ($update = null) {
		
		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);
		
		$query = "
			SELECT sm.lastview_datetime, sm.recommend, sm.watch 
			FROM " . $this->db->prefix . "_forum_subject_movement sm
			where
			sm.subject_id=" . $this->subject_id . " and
			sm.user_id=" . $this->user_id
		;
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			$temp = $result->fields;
			$temp['lastview_datetime'] = $this->date->formatDate($temp['lastview_datetime']);
			$result->Close();
		}
	
		//we now have the option of updating the movement (subject details page)
		
		
		if (isset($temp['lastview_datetime'])) {
			
			//select the movement
			$query1 = "
				SELECT count(r.reply_id) as movement 
				FROM " . $this->db->prefix . "_forum_reply r
				where
				r.subject_id=" . $this->subject_id . " and 
				r.reply_create_datetime > " . $datetime
			;
			$result1 = $this->db->Execute($query1);
			
			if (isset($result1->fields)) {
				$temp1 = $result1->fields;
				$result1->Close();
			}
			
			if (isset($temp1['movement'])) {
				$temp['movement'] = $temp1['movement'];
			}
			else {
				$temp['movement'] = "0";
			}
		}
		
		if (isset($update)) {
			if (isset($temp['lastview_datetime'])) {
				//we update the datetime
				$query2 = "
					UPDATE " . $this->db->prefix . "_forum_subject_movement SET 
					lastview_datetime=" . $datetime . "
					WHERE 
					subject_id=" . $this->subject_id . " and
					user_id=" . $this->user_id
				;
				$result2 = $this->db->Execute($query2);
				
				if (isset($result2->fields)) {
				    $result1->Close();
				}
				
			}
			else {
				//we insert a record
				$query3 = "
					INSERT INTO " . $this->db->prefix . "_forum_subject_movement 
					(user_id, subject_id, node_id, lastview_datetime) VALUES (
					" . $this->user_id . ", 
					" . $this->subject_id . ", 
					" . $this->node_id . ", 
					" . $datetime . ")"
				;
				
				$result3 = $this->db->Execute($query3);
				
				if (isset($result3->fields)) {
				    $result3->Close();
				}
			}
		}
		
		if (isset($temp)) {
			return $temp;
		}
	
	}
	
	
	/*
	* UPDATE SUBJECT BOOKMARK
	* tom calthrop
	* We update either the watched or recommended item
	* 23rd November 2004
	*/
	function updateSubjectBookmark($bookmark_type = null) {
		
		$query = "UPDATE " . $this->db->prefix . "_forum_subject_movement SET ";
		
		if (isset($bookmark_type) && $bookmark_type == "recommend") {
			$query .= "recommend=1 ";
		}
		elseif (isset($bookmark_type) && $bookmark_type == "watch") {
			$query .= "watch=1 ";
		}
		elseif (isset($bookmark_type) && $bookmark_type == "unrecommend") {
			$query .= "recommend=null ";
		}
		elseif (isset($bookmark_type) && $bookmark_type == "unwatch") {
			$query .= "watch=null ";
		}
		
		$query .= "
			WHERE 
			subject_id=" . $this->subject_id . " and
			user_id=" . $this->user_id
		;
		
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
		    $result->Close();
		}
	}
	
	
	/*
	* GET TOPIC MOVEMENT
	* tom calthrop
	* We get the movement of the topic from when we last looked to now.
	* 23rd November 2004
	*/
	function getTopicMovement ($update = null) {
		
		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);
		
		$query = "
			SELECT sm.lastview_datetime, sm.recommend, sm.watch 
			FROM " . $this->db->prefix . "_forum_topic_movement sm
			where
			sm.topic_id=" . $this->topic_id . " and
			sm.user_id=" . $this->user_id
		;
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			$temp = $result->fields;
			$temp['lastview_datetime'] = $this->date->formatDate($temp['lastview_datetime']);
			$result->Close();
		}
	
		//we now have the option of updating the movement (topic details page)
		
		//select the movement
		if (isset($temp['lastview_datetime'])) {
			$query1 = "
				SELECT count(s.subject_id) as movement 
				FROM " . $this->db->prefix . "_forum_subject s
				where
				s.topic_id=" . $this->topic_id . " and 
				s.subject_create_datetime > " . $datetime
			;
			$result1 = $this->db->Execute($query1);
			
			if (isset($result1->fields)) {
				$temp1 = $result1->fields;
				$result1->Close();
			}
			
			if (isset($temp1['movement'])) {
				$temp['movement'] = $temp1['movement'];
			}
			else {
				$temp['movement'] = "0";
			}
		}
			
		if (isset($update)) {
		
			if (isset($temp['lastview_datetime'])) {
				//we update the datetime
				$query2 = "
					UPDATE " . $this->db->prefix . "_forum_topic_movement SET 
					lastview_datetime=" . $datetime . "
					WHERE 
					topic_id=" . $this->topic_id . " and
					user_id=" . $this->user_id
				;
				$result2 = $this->db->Execute($query2);
				
				if (isset($result2->fields)) {
				    $result1->Close();
				}
				
			}
			else {
				//we insert a record
				$query3 = "
					INSERT INTO " . $this->db->prefix . "_forum_topic_movement 
					(user_id, topic_id, node_id, lastview_datetime) VALUES (
					" . $this->user_id . ", 
					" . $this->topic_id . ", 
					" . $this->node_id . ", 
					" . $datetime . ")"
				;
				
				$result3 = $this->db->Execute($query3);
				
				if (isset($result3->fields)) {
				    $result3->Close();
				}
			}
		}
		
		if (isset($temp)) {
			return $temp;
		}
	}
	
	
	/*
	* UPDATE TOPIC BOOKMARK
	* tom calthrop
	* We update either the watched or recommended item
	* 23rd November 2004
	*/
	function updateTopicBookmark($bookmark_type = null) {
		
		$query = "UPDATE " . $this->db->prefix . "_forum_topic_movement SET ";
		
		if (isset($bookmark_type) && $bookmark_type == "recommend") {
			$query .= "recommend=1 ";
		}
		elseif (isset($bookmark_type) && $bookmark_type == "watch") {
			$query .= "watch=1 ";
		}
		elseif (isset($bookmark_type) && $bookmark_type == "unrecommend") {
			$query .= "recommend=null ";
		}
		elseif (isset($bookmark_type) && $bookmark_type == "unwatch") {
			$query .= "watch=null ";
		}
		
		$query .= "
			WHERE 
			topic_id=" . $this->topic_id . " and
			user_id=" . $this->user_id
		;
		
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
		    $result->Close();
		}
	}
	
}
?>
