<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


include "inc/header.inc.php";
include $c_node['aroundme_dir'] . "inc/functions.inc.php";
include $c_node['aroundme_dir'] . "config/config_aroundme.inc.php";

//include error handling files from aroundme
$languagePath = $c_node['aroundme_dir'] . "language/" . $language_id . "/" . $c_node['template_default_name'];
$languageArrayPath = $languagePath . "/arrays/";
require_once($languageArrayPath . 'arr_language_name.lang.php');
require_once($languageArrayPath . 'arr_error_success.lang.php');


//database setup and connect
require_once($c_node['aroundme_dir'] . $c_node['class_dir'] . 'Adodb/adodb.inc.php');
$ADODB_CACHE_DIR = 'cache/Adodb';
$db = NewADOConnection('mysql');
$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
$db->Connect($c_node['db']['host'], $c_node['db']['user'] , $c_node['db']['pass'] , $c_node['db']['db']);
$db->prefix = $c_node['db']['prefix'];


//Date
require_once($c_node['aroundme_dir'] . $c_node['class_dir'] . 'Date.class.php');
$date = new Date();


//set up user
require_once($c_node['aroundme_dir'] . $c_node['class_dir'] . 'User/User.class.php');
$user = new User();
$user->date = $date;
$user->db= $db;


//if the session is timed out we destroy it
if(isset($_SESSION['s_user_id'])) {
	session_unset();
	session_destroy();

	session_start();
	$_SESSION['s_language_id'] = $language_id;
}


//form actions
if (isset($_POST['login'])) {

	if (isset($_POST['email']) && $_POST['email'] && isset($_POST['password']) && $_POST['password']) {
		$user->relation_type = $c_node['relation_type']['approved'];
		$user->total_login_stat_id = $c_node['user_statistic_type_id']['total_logins'];
		$user->stat_type_id_friends = $c_node['user_statistic_type_id']['total_friends'];
		$user->stat_type_id_aqaintances = $c_node['user_statistic_type_id']['total_aqaintances'];
		$user->aroundme_dir = $c_node['aroundme_dir'];

		$login_check = $user->checkLogin($_REQUEST['email'],$_REQUEST['password']);

		if (empty($login_check)) {
			$login = $user->loginUser($_REQUEST['email'],$_REQUEST['password'], $c_node['node_id']);

			if (isset($login)) {
			    $error = $login;
			}
		}
		else {
			$error = $login_check;
		}


	}
	else {
		$error[] = array('error', 20);
	}

}
elseif (isset($_REQUEST['registration_complete'])) {
	$display = "registration_complete";
}


//TEMPLATE
$body->set('language_available', $c_node['www_language_available']);

if (isset($error)) {
 	$tpl->set('error', $error);
}

if (isset($display)) {
	$body->set('display', $display);
}

$pagename = "index";
include "inc/footer.inc.php";
?>
