<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "user";

include "inc/header.inc.php";
require_once($c_node['class_dir'] . 'User/Bookmark.class.php');
require_once($c_node['class_dir'] . 'Poll.class.php');


//append language setup
require_once($languageArrayPath . 'arr_user_online_status.lang.php');
require_once($languageArrayPath . 'arr_user_relation.lang.php');


//setup polls
$poll = new Poll();
$poll->db = $db;
$poll->date = $date;



//get bookmark items
$bookmark = new Bookmark($user_id);
$bookmark->date = $date;
$bookmark->db = $db;
$bookmark->poll = $poll;
$bookmark->bookmark_type = $c_node['bookmark_type_recommended'];
$bookmark->image = $image;

$output_groups = $bookmark->displayGroup($c_node['group_status']['active']);
$output_topics = $bookmark->displayTopics();
$output_subjects = $bookmark->displaySubjects();
$output_library = $bookmark->displayLibrary();
$output_blogs = $bookmark->displayBlog();
$output_events = $bookmark->displayEvent();


//move to template
if (isset($output_topics)) {
    $body->set('topics', $output_topics);
}

if (isset($output_subjects)) {
    $body->set('subjects', $output_subjects);
}

if (isset($output_library)) {
    $body->set('library', $output_library);
}

if (isset($output_groups)) {
    $body->set('groups', $output_groups);
}

if (isset($output_blogs)) {
    $body->set('blogs', $output_blogs);
}

if (isset($output_events)) {
    $body->set('events', $output_events);
}

if (isset($output_user)) {
    $body->set('user', $output_user);
}

if (isset($output_relationship)) {
    $body->set('relationship', $output_relationship);
}

$template_pageLink =  $lang['txt_recommended'];
$template_pageLinkNote = $lang['txt_recommended'] . ": " . $output_user['user_nic'];

include "inc/footer.inc.php";

?>
