<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

if (isset($_REQUEST['page'])) {
	$page = $_REQUEST['page'];
}

if (isset($_REQUEST['page_id'])) {
	$page_id = $_REQUEST['page_id'];
}

if (isset($_REQUEST['history_library_id'])) {
	$history_library_id = $_REQUEST['history_library_id'];
}

$core = "my";
include "inc/header.inc.php";
require_once($c_node['class_dir'] . 'Library/Library.class.php');
require_once($c_node['class_dir'] . 'Wiki/Wiki.php');


//append language setup
require_once($languageArrayPath . 'arr_user_online_status.lang.php');
require_once($languageArrayPath . 'arr_user_relation.lang.php');
require_once($languageArrayPath . 'arr_user_publish.lang.php');


//library setup
$library = new Library();
$library->type = "user";
$library->db = $db;
$library->user_id = $user_id;
$library->date = $date;
$library->image = $image;
$library->library_publish = $c_node['user_publish']['all'];


//wiki setup
$wiki =& new Text_Wiki();
$wiki->rulePath = $c_node['class_dir'] . "Wiki/Rule/";
$wiki->setRuleConf('wikilink', 'view_url', 'my_library.php?user_id=' . $user_id . '&page=');
$wiki->setRuleConf('wikilink', 'new_url', 'my_library_edit.php?user_id=' . $user_id . '&page=');
$wiki->setRuleConf('image', 'base', $c_node['base_path'] . "user/" . $user_id . "/");


// set an array of pages that exist in the library
$pages = $library->getPages();
$wiki->setRuleConf('wikilink', 'pages', $pages);


//setup image
$image->thumb = "t2";



if (isset($_REQUEST['contents'])) {
	$output_contents = $library->getContents();

	$display = "contents";

}
elseif (isset($history_library_id)) {
	$output_history = $library->getHistory($history_library_id);

	$display = "history";
}
elseif (isset($page_id)) {
	$output_library = $library->getPageID($page_id);

	//find out if this is the newest article
	$newest_doc = $library->getPageName($output_library['library_page_name']);

	if ($output_library['library_id'] == $newest_doc['library_id']) {
	    $newest = true;
	}

}
elseif (isset($page)) {
	$output_library = $library->getPageName($page);
	$newest = true;
}
else {
	$output_library = $library->getPageDefault();
	$newest = true;
}




if (isset($output_library['library_id'])) {

	$library_id = $output_library['library_id'];

	//Parser library
	$output_library['library_body'] = $wiki->transform($output_library['library_body'], 'Xhtml');

	if (isset($output_library['library_image_id'])) {
		$output_library['image'] = $image->getImage($output_library['library_image_id'], 't1');
	}
}


//move to template
if (isset($output_contents)) {
	$body->set('contents', $output_contents);
}

if (isset($output_history)) {
	$body->set('history', $output_history);
}

if (isset($newest)) {
	$body->set('newest', $newest);
}

if (isset($output_library)) {
	$body->set('library', $output_library);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (isset($output_user)) {
    $body->set('user', $output_user);
}

if (isset($output_relationship)) {
    $body->set('relationship', $output_relationship);
}


$template_pageLink = $lang['txt_library'];
$template_pageLinkNote = $output_user['user_firstname'] . " " . $output_user['user_surname'];

include "inc/footer.inc.php";

?>
