<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

class Guestbook {
	// Instance variables
	var $user_id;                        // User id
	var $db;                             // get db connect
	var $date;                           // get date for date formatting
	var $image;                          // get image for images data retrieval
	
	function Guestbook($user_id, $db, $date, $image) {
		$this->user_id = $user_id;
		$this->db = $db;
		$this->date = $date;
		$this->image = $image;

	}

	/*
	* getGuestbook
	* tom calthrop
	* 21st May 2004
	*/
	function getGuestbook () {
		$query = "
			SELECT g.*, u.user_nic, u.user_create_datetime, u.user_image_id
			FROM " . $this->db->prefix . "_guestbook g
			RIGHT JOIN " . $this->db->prefix . "_user u on g.user_id=u.user_id
			WHERE g.guestbook_id=" . $this->guestbook_id
			;

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = $result->fields;

			$temp['guestbook_create_datetime'] = $this->date->formatDate($temp['guestbook_create_datetime']);

			if (isset($temp1['user_image_id'])) {
				$temp1['image'] = $this->image->getImage($temp1['user_image_id'], 't2', 'user');
			}
			else {
				$temp1['image']['image'] = "user/no_user_t2.gif";
			}

			$result->Close();
			return $temp;
		}
		else {
			$this->log[]  = array('error', 1, $query . "-" . $this->db->ErrorMsg(), null);
		}
	}


	/*
	* updateComment
	* tom calthrop
	* 21st May 2004
	*/
	function updateComment ($text) {

		$textconv = $this->db->qstr($text);
		$query = "
			UPDATE " . $this->db->prefix . "_guestbook
			SET guestbook_comment_body=" . $textconv . "
			WHERE guestbook_id=" . $this->guestbook_id
		;
		//echo $query;

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[] =  array('error', 1, $this->db->ErrorMsg());
		}

		if (!isset($state)) {
		    $state[]  = array('success', 3);
		}

		return $state;

    }//EO updateComment();



	/*
	* getGuestbooks
	* tom calthrop
	* 21st May 2004
	*/
    function getGuestbooks () {

		$query = "
			SELECT g.*, u.user_nic, u.user_create_datetime, u.user_image_id
			FROM " . $this->db->prefix . "_guestbook g
			RIGHT JOIN " . $this->db->prefix . "_user u on g.user_id=u.user_id
			WHERE g.user_id_guestbook=" . $this->user_id . "
			order by g.guestbook_create_datetime desc"
		;

		if (isset($this->limit)) {
		    $result = $this->db->SelectLimit($query, $this->limit); //returns last X rows
		}
		else {
			$result = $this->db->Execute($query);
		}

		if (isset($result->fields)) {

			$temp = array();

		 	while (!$result->EOF) {
				$temp1 = $result->fields;

				$temp1['guestbook_body'] = nl2br($temp1['guestbook_body']);

				if (isset($temp1['user_image_id'])) {
					$temp1['image'] = $this->image->getImage($temp1['user_image_id'], 't2', 'user');
				}
				else {
					$temp1['image']['image'] = "user/no_user_t2.gif";
					$temp1['image']['image_title'] = "";
				}

				$temp1['guestbook_create_datetime'] = $this->date->formatDate($temp1['guestbook_create_datetime']);

				array_push($temp, $temp1);
	           	$result->MoveNext();
			}

			return $temp;
		}
		else {
			$this->log[]  = array('error', 1, $query . "-" . $this->db->ErrorMsg(), null);
		}
    }//EO getGuestbooks


	/*
	* deleteGuestbooks
	* tom calthrop
	* 21st May 2004
	*/
    function deleteGuestbooks($del_arr) {
		$rownums = count ($del_arr);

		//echo $rownums;

		for ($i=0; $i < $rownums; $i++) {
			$query = "
				DELETE from " . $this->db->prefix . "_guestbook
				WHERE
				guestbook_id = " . $del_arr[$i]
			;

			$result = $this->db->Execute($query);

			if (!$result) {
				$state[]  = array('error', 1, $this->db->ErrorMsg());
			}
		}
    }//EO deleteGuestbooks;


	/*
	* insertGuestbook
	* tom calthrop
	* 21st May 2004
	*/
    function insertGuestbook($user_id, $guestbook_text) {
		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		$query = "
			INSERT INTO " . $this->db->prefix . "_guestbook (
			user_id, user_id_guestbook, guestbook_body, guestbook_create_datetime
			)values (
			" . $user_id . ",
			" . $this->user_id . ",
			'" . $guestbook_text . "',
			" . $datetime . ")"
		;
		//echo $query;
		$result = $this->db->Execute($query);

		if (!$result) {
			$state[] =  array('error', 1, $this->db->ErrorMsg());
		}

		if (!isset($state)) {
		    $state[]  = array('success', 2);
		}

		return $state;
    }

}
?>
