<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


include "inc/header.inc.php";


//set up user
require_once($c_node['dir']['aroundme'] . $c_node['dir']['class_path'] . 'User.class.php');
$user = new User($db, $date);
$user->status_ids = $c_node['user']['status'];

//if the session is timed out we destroy it
if(isset($_SESSION['s_user_id'])) {
	session_unset();
	session_destroy();

	session_start();
	$_SESSION['s_language_id'] = $language_id;
}


//form actions
if (isset($_POST['login'])) {

	if (isset($_POST['email']) && $_POST['email'] && isset($_POST['password']) && $_POST['password']) {
		$user->relation_type = $c_node['user']['relation_type']['approved'];
		$user->aroundme_dir = $c_node['dir']['aroundme'];
		
		
		require_once($c_node['dir']['aroundme'] . $c_node['dir']['class_path'] . 'Statistic.class.php');
		$statistic = new Statistic($db, 1, null);
		$user->statistic = $statistic;
		$user->total_login_stat_id = $c_node['statistic']['user']['total_logins'];
		
		$user->checkLogin($_REQUEST['email'],$_REQUEST['password']);

		if (empty($GLOBALS['am_error_log'])) {
			//setup social network
			require_once($c_node['dir']['aroundme'] . $c_node['dir']['class_path'] . 'SocialNetwork.class.php');
			$sn = new SocialNetwork(null, $db, $c_node['node']['node_id'], $c_node['sn']['max_degree']);
			$sn->relation_type_ids = $c_node['user']['relation_type'];
			$sn->status_ids = $c_node['user']['status'];
			$user->sn = $sn;
			
			$user->loginUser($_REQUEST['email'],$_REQUEST['password'], $c_node['node']['node_id']);
		}
	}
	else {
		$GLOBALS['am_error_log'][] = array(20, null, null);
	}

}
elseif (isset($_REQUEST['registration_complete'])) {
	$display = "registration_complete";
}


//TEMPLATE
$body->set('language_available', $c_node['node']['language_available']);

if (isset($error)) {
 	$tpl->set('error', $error);
}

if (isset($display)) {
	$body->set('display', $display);
}

$pagename = "index";
include "inc/footer.inc.php";
?>
