<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_my.inc.php";
require_once($c_node['dir']['class_path'] . 'Activity.class.php');
require_once($c_node['dir']['class_path'] . 'Statistic.class.php');
require_once($c_node['dir']['class_path'] . 'SocialNetwork.class.php');
require_once($c_node['dir']['class_path'] . 'Comment.class.php');


//append language setup
require_once($languageArrayPath . 'arr_task_user_status.lang.php');
require_once($languageArrayPath . 'arr_user.lang.php');
require_once($languageArrayPath . 'arr_cms.lang.php');


//setup file
$file->thumb = $c_node['file']['image']['thumb'][2]['name'];
$file->noimage = $c_node['file']['image']['thumb'][2]['noimage'];


//get my actvities
$activity = new Activity($db, $c_acs['arr_section']['user'], $date, $file);
$activity->user_id = $me['user_id'];
$activity->task_user_status_ids = $c_node['activity']['task_user_status'];
$output_task_ids = $activity->getUserTasks();
if (!empty($output_task_ids)) {
	foreach($output_task_ids as $key => $i):
		$task_ids[] = $i['task_id'];
	endforeach;
}
//get tasks
if (!empty($task_ids)) {
	$activity->task_ids = $task_ids;
	$output_tasks = $activity->getTasks();
}


//setup statistics
$statistic = new Statistic($db, $c_acs['arr_section']['user'], $date);
$statistic->section_item_id = $user_id;
$output_statistic = $statistic->getStatistics();
$statistic->user_status = $c_node['user']['status'];
$output_node_statistics = $statistic->getNodeStatistics();


//setup file
$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];


//setup comment
$comment = new Comment($db, null, $date);
$comment->section_item_id = $user_id;
$comment->no_user_id = $user_id;
$comment->limit = 10;
$output_comments = $comment->getComments();


//get my profile
$output_profile = $user->getProfile();
//get my profile image
if (isset($output_profile['file_id'])) {
	$file->file_id = $output_profile['file_id'];
	$output_profile['image'] = $file->getFileRecord();
}
elseif (isset($output_profile)) {
	$output_profile['image']['file_title'] = "";
	$output_profile['image']['file'] = $file->noimage;
}


//setup file
$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];

/*
//friends
$sn = new SocialNetwork($user_id, $db, $c_node['node']['node_id']);
$sn->status_ids = $c_node['user']['status'];
$sn->date = $date;
$sn->user = $user;
$sn->file = $file;
$sn->limit = 2;
$sn->orderby = "user_create_datetime desc";
$output_friends = $sn->getSocialNetwork();
*/

//move to template
if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_tasks)) {
	$body->set('tasks', $output_tasks);
}

if (!empty($output_node_statistics)) {
	$body->set('node_statistics', $output_node_statistics);
}

if (!empty($output_user)) {
	$body->set('user', $output_user);
}

if (!empty($output_profile)) {
	$body->set('profile', $output_profile);
}

if (!empty($output_statistic)) {
	$body->set('user_statistic', $output_statistic);
}

if (!empty($output_friends)) {
	$body->set('friends', $output_friends);
}

$body->set('cms_item_type_ids', $c_node['cms']['item_type']);


$template_pageLink = $lang['txt_my_overview'];
include "inc/footer.inc.php";

?>
