<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_my.inc.php";


if (isset($_REQUEST['library_id'])) {
	$library_id = $_REQUEST['library_id'];
}
elseif (isset($_REQUEST['page'])) {
	$page = $_REQUEST['page'];
}


require_once($c_node['dir']['class_path'] . 'Library.class.php');
require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');


//append language setup
require_once($languageArrayPath . 'arr_user.lang.php');
require_once($languageArrayPath . 'arr_language_name.lang.php');



//setup Library
$library = new Library($db, $c_acs['arr_section']['user'], $date, $file);
$library->section_item_id = $me['user_id'];
$library->user_id = $me['user_id'];


//wiki setup
$wiki =& new Text_Wiki();
$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', 'sn_library.php?user_id=' . $me['user_id'] . '&page=');
$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', 'sn_library_edit.php?user_id=' . $me['user_id'] . '&page=');
$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'user/');



// set an array of pages that exist in the library
$pages = $library->getPages();
$wiki->setRenderConf('xhtml', 'wikilink', 'pages', $pages);


//setup file
$file->noimage = $c_node['file']['image']['thumb'][2]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][2]['name'];
$file->type_ids[] = $c_node['file']['mime'][1]['suffix']; //jpg
$file->type_ids[] = $c_node['file']['mime'][2]['suffix']; //png
$file->type_ids[] = $c_node['file']['mime'][3]['suffix']; //gif

$output_images = $file->getFiles();



if (isset($_POST['data'])) {//post data received
    $data = $_POST['data'];

	$data['library_body'] = stripslashes($data['library_body']);
	$data['library_body_display'] = $wiki->transform($data['library_body'], 'Xhtml');

	$data['library_synopsis'] = stripslashes(htmlspecialchars($data['library_synopsis']));

	$data['library_title'] = stripslashes(htmlspecialchars($data['library_title']));

	$data['library_page_name'] = $page;

	if (isset($_POST['preview_library'])) {
		$data['library_body'] = htmlspecialchars($data['library_body']);

		$output_library = $data;

		$display = "preview_library";
	}
	elseif (isset($_POST['edit_library_again'])) {
		$output_library = $data;

		$display = "add_library";

	}
	elseif (isset($_POST['insert_library'])) {
		$library->section_item_id = $me['user_id'];
		
		if (isset($data['degree_id']) && $data['degree_id'] == "node") {
		    $data['degree_id'] = "null";
			$data['level_id'] = $c_node['cms']['cms_level']['node'];
		}
		
		$library->insertLibrary($data);
		
		if (empty($GLOBALS['am_error_log'])) {
			if (!empty($data['level_id'])) {
				//setup cms
				require_once($c_node['dir']['class_path'] . 'Cms.class.php');
				$cms = new Cms($db, $c_acs['arr_section']['user']);
				$cms->section_item_id = $me['user_id'];
				$cms->cms_item_type_id = $c_node['cms']['item_type']['user_library'];
				$cms->user_id = $me['user_id'];
				$temp['language_id'] = $me['language_id'];
				$temp['item_id'] = $library->library_id;
				$temp['genre_id'] = $data['genre_id'];
				
				//insert node cms entry
				$temp['level_id'] = $c_node['cms']['cms_level']['node'];
			
			   	if($c_node['cms']['node']['auto_publish'] == 1) {
					$temp['status_id'] = $c_node['cms']['status']['live'];
				}
				else {
					$temp['status_id'] = $c_node['cms']['status']['pending'];
				}
				
				$cms->insertCmsItem($temp);
			}
			
			header("Location: my_library.php?page=" . $data['library_page_name'] . "&amp;" . SID);
			exit;
		}
		else {
		
			$output_library = $data;

			$display = "add_library";
		}
	}

}
elseif (isset($library_id)) {//if we have a library id we retrieve it
    $output_library = $library->getPageID($library_id);


	$display = "add_library";
}
elseif (isset($page)) {//else we assign the new page name
	$output_library = $library->getPageName($page);

	if (empty($output_library)) {
	    $output_library['library_page_name'] = $page;
		$output_library['library_default'] = null;
	}


	$display = "add_library";
}
else {
	$output_library = $library->getPageDefault();
	$output_library['library_body'] = $wiki->transform($output_library['library_body'], 'Xhtml');
	$display = "view_library";
}


//handle new libraries - we've deleted all library items and now adding new one
if (isset($output_library['library_page_name']) && !isset($output_library['library_id']) && ($output_library['library_page_name'] == $lang['txt_wiki_default'])) {
	$output_library['library_default'] = 1;
}


$output_user['language_ids'] = $me['language_ids'];

//move to template
if (!empty($output_library)) {
	$body->set('library', $output_library);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (!empty($output_images)) {
	$body->set('images', $output_images);
	$body->set('image_thumbs', $c_node['file']['image']['thumb']);
}

if (!empty($pages)) {
	$body->set('pages', $pages);
}

if (!empty($output_user)) {
    $body->set('user', $output_user);
}

if (!empty($output_relationship)) {
    $body->set('relationship', $output_relationship);
}

include "inc/footer.inc.php";

?>
