<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


include "config/config_aroundme.inc.php";
include "config/config_acs.inc.php";
include "inc/functions.inc.php";


// SETUP ERROR HANDLING -----------------------------------------------------------------------
// this is accessed and updated with all errors thoughtout this build
// processing regularly checks if empty before continuing
$GLOBALS['am_error_log'] = array();


// SETUP DATABASE -----------------------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Adodb/adodb.inc.php');
$ADODB_CACHE_DIR = 'cache/Adodb';
$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
$db = NewADOConnection('mysql');
$db->Connect($c_node['db']['host'], $c_node['db']['user'] , $c_node['db']['pass'] , $c_node['db']['db']);
$db->prefix = $c_node['db']['prefix'];


//SETUP DATE -----------------------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Date.class.php');
$date = new Date();


// SETUP USER -----------------------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'User.class.php');
$user = new User($db, $date);
$user->relation_type = $c_node['user']['relation_type']['approved']; //not sure we need this - tom 7th dec 2004
$user->status_ids = $c_node['user']['status'];
$user->authUser();

$me = array(
		'user_id'=> 		$_SESSION['s_user_id'],
		'role_id'=> 		$_SESSION['s_role_id'],
		'firstname'=> 		$_SESSION['s_firstname'],
		'surname'=> 		$_SESSION['s_surname'],
		'language_id'=> 	$_SESSION['s_language_id'],
		'language_ids'=> 	$_SESSION['s_language_ids'],
		'template_id'=> 	$_SESSION['s_user_template'],
		'homepage'=> 		$_SESSION['s_homepage']
);

// SETUP UP USER ACS
require_once($c_node['dir']['class_path'] . 'Acs.class.php');
$user_acs = new Acs($me['role_id'], $db, $c_acs['arr_section']['user']); //1 = section=1 = user

//SETUP USER MESSAGES
require_once($c_node['dir']['class_path'] . 'IM.class.php');
$im = new IM($me['user_id'], $db, $c_node['messaging']['message_box_max_size']);
// Setting the message status coding
$im->setStatus($c_node['messaging']['message_status_unread'], $c_node['messaging']['message_status_read']);
$im->setBoxes($c_node['messaging']['message_in_box'], $c_node['messaging']['message_save_box'], $c_node['messaging']['message_out_box']);
//get inbox unread message count
$me['mail'] = $im->messageCount();


//SETUP SHOUT -----------------------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Shout.class.php');
$shout = new Shout($db, $date);
$shoutbox = $shout->getShout();
print_r($shoutbox);

//SETUP FILE -----------------------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'File.class.php');
$file = new File($db, $c_acs['arr_section']['user'], $c_node['file'], $c_node['dir']);
$file->path = "user";


// SETUP TEMPLATE -------------------------------------------------------------------
$template_path = $c_node['dir']['template_path'];

if (isset($me['template_id'])) {
    $template_name = $me['template_id'];
}
else {
	$template_name = $c_node['node']['template_default_name'];
}

$template_path = $template_path . $template_name . "/";

require_once($c_node['dir']['class_path'] . 'Template.class.php');
$tpl = & new Template($template_path); // This is the outter template
$body = & new Template($template_path); // This is the inner template
$page_name_full = basename($_SERVER['REQUEST_URI']);
$page_name = explode(".",$page_name_full);


// SETUP LANGUAGE -----------------------------------------------------------------------
$languagePath = "language/" . $me['language_id'] . "/" . $template_name . "/";
$languageArrayPath = $languagePath . "arrays/";
$languageTextPath = $languagePath . "texts/";
require_once($languagePath . 'outer.lang.php');
require_once($languageArrayPath . 'arr_links.lang.php');
require_once($languageArrayPath . 'arr_error.lang.php');
require_once($languagePath . $page_name[0] .'.lang.php');


// ACS CHECKS -----------------------------------------------------------------------
if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['administration'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	$tpl->set('show_node_admin_link', 1);
}


// RETREIVE FOR VARS -----------------------------------------------------------------------
if (isset($_POST['data'])) {
    $data = $_POST['data'];
}


?>
