<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_group.inc.php";

//ACS check
if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_poll'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	header("Location: g_group.php?group_id=" . $output_group['group_id']."&".SID);
	exit;
}

if (isset($_REQUEST['poll_id'])) {
	$poll_id = $_REQUEST['poll_id'];
}

require_once($c_node['dir']['class_path'] . 'Poll.class.php');
require_once($c_node['dir']['class_path'] . 'Comment.class.php');
require_once($c_node['dir']['class_path'] . 'Bookmark.class.php');


//append language setup
require_once($languageArrayPath . 'arr_language_name.lang.php');


$poll = new Poll($db, $c_acs['arr_section']['group'], $date);
$poll->section_item_id = $group_id;


//setup comment
$comment = new Comment($db, $c_node['cms']['item_type']['group_poll'], $date);
$comment->section_item_id = $group_id;
$comment->user_id = $user_id;


//process requests
if (isset($_POST['preview'])) {
	$output_comment = $data;
	$output_comment['display_comment_body'] = htmlspecialchars(nl2br($output_comment["comment_body"]));
	
	$display = "preview_comment";

}
elseif (isset($_POST['insert'])) {
	
	$comment->item_id = $poll_id;
	$comment->insertComment($data);
		
	if (empty($GLOBALS['am_error_log'])) {
		//update user stats
		//setup statistics
		require_once($c_node['dir']['class_path'] . 'Statistic.class.php');
		$statistic = new Statistic($db, $c_acs['arr_section']['group'], $date);
		$statistic->section_item_id = $group_id;
		//update stats
		$statistic->statistic_type_id = $c_node['statistic']['group']['total_comments'];
		$statistic->setStatistic($comment->getCommentCount());
		
		$statistic->statistic_type_id = $c_node['statistic']['user']['total_comments'];
		$statistic->section_id = $c_acs['arr_section']['user'];
		$group->user_id = $user_id;
		$statistic->setStatistic($comment->getCommentCount());
		
		//goto the subject
		return header("Location: g_poll.php?group_id=". $group_id . "&poll_id=". $poll_id . "&" . SID);
		exit;
	}
}
elseif (isset($_POST['edit_again'])) {
	$output_comment = $data;
}



if (isset($poll_id)) {
	$poll->poll_id = $poll_id;
	$output_poll = $poll->getPoll();
	$output_poll['current_answer']= $poll->pollUserCurrentVote($me['user_id']);
	
	if (isset($output_poll)) {
		$output_poll_history = $poll->pollUserVoteHistory($me['user_id']);
	}
	
	//setup bookmarks
	$bookmark = new Bookmark($db, $c_node['cms']['item_type']['group_poll'], $date, $user_id);
	$bookmark->item_id = $poll_id;
	
	
	//watching
	$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
	//set or unset bookmarks
	if (isset($_REQUEST['watch'])) {
		$bookmark->insertBookmark();
	}
	elseif (isset($_REQUEST['unwatch'])) {
		$bookmark->deleteBookmark();
	}
	//get and update bookmark
	if ($bookmark->getBookmark()) {
		$bookmark->updateBookmark();
		$output_poll['bookmark']['watch'] = 1;
	}

	//recommended
	$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
	//set or unset bookmarks
	if (isset($_REQUEST['recommend'])) {
		$bookmark->insertBookmark();
	}
	elseif (isset($_REQUEST['unrecommend'])) {
		$bookmark->deleteBookmark();
	}
	//get and update bookmark
	if ($bookmark->getBookmark()) {
		$bookmark->updateBookmark();
		$output_poll['bookmark']['recommend'] = 1;
	}

	if (isset($output_library['user_id'])) {
	    $output_author = $user->getUser($output_library['user_id']);
		$output_author['user_create_datetime'] = $date->formatDate($output_author['user_create_datetime']);
	}
	
	$comment->item_id = $poll_id;
	$output_comments = $comment->getComments($poll_id, 1);
	
	//get users vote for each comment
	if (isset($output_comments)) {
		foreach($output_comments as $key => $i):
			$output_comments[$key]['vote'] = $poll->pollUserVoteHistory($i['user_id']);
		endforeach;
	}

	
}
else { //list polls
	
	$poll->before_start_timestamp = mktime();
	$poll->after_end_timestamp = mktime();
	$output_polls = $poll->getPolls();
	
	unset($poll->before_start_timestamp, $poll->after_end_timestamp);
	$poll->before_end_timestamp = mktime();
	$output_archive_polls = $poll->getPolls();
	
	//ACS check
	if ($group_acs->checkPermission($c_acs['arr_acs']['resource']['group_poll'], $c_acs['arr_acs']['privilege']['allow_edit'])) { //resourece_id, Priv_id
		unset($poll->before_end_timestamp);
		$poll->after_start_timestamp = mktime();
		$output_forthcoming_polls = $poll->getPolls();
	}
	
	$display = "view_polls";
}

//move to template
if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_comment)) {
	$body->set('comment', $output_comment);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (!empty($output_polls)) {
   $body->set('polls', $output_polls);
}

if (!empty($output_archive_polls)) {
   $body->set('archive_polls', $output_archive_polls);
}

if (!empty($output_forthcoming_polls)) {
   $body->set('forthcoming_polls', $output_forthcoming_polls);
}

if (!empty($output_poll)) {
	$datetime = date("Y-m-d H:i:s");
	if ($output_poll['poll_start_datetime'] > $datetime) {
	    $output_poll['allow_edit'] = 1;
	}
	
	$body->set('poll', $output_poll);
   
   
   
}

if (!empty($output_poll_history)) {
	$body->set('poll_history', $output_poll_history);
}

if (!empty($output_poll_usage)) {
   $body->set('poll_usage', $output_poll_usage);
}

include "inc/footer.inc.php";

?>
