<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_group.inc.php";
require_once($c_node['dir']['class_path'] . 'Forum.class.php');
require_once($c_node['dir']['class_path'] . 'Library.class.php');
require_once($c_node['dir']['class_path'] . 'Blog.class.php');
require_once($c_node['dir']['class_path'] . 'Statistic.class.php');
require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');
require_once($c_node['dir']['class_path'] . 'Comment.class.php');

//append language setup
require_once($languageArrayPath . 'arr_user.lang.php');
require_once($languageArrayPath . 'arr_group.lang.php');


if (isset($_REQUEST['user_id'])) {
	$user_id = $_REQUEST['user_id'];
}
else {
	$user_id = $me['user_id'];
}


//setup group
$group->user_id = $user_id;


//setup file
$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
	

//setup Wiki
$wiki =& new Text_Wiki();
$wiki->disableRule('freelink');
$wiki->disableRule('wikilink');
$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'user/');


//ACS check - can we edit this user?
if ($group_acs->checkPermission($c_acs['arr_acs']['resource']['group_membership'], $c_acs['arr_acs']['privilege']['allow_edit'])) { //resourece_id, Priv_id
	//get group roles
	$group_acs->group_id = $group_id;
	$group_roles = $group_acs->getGroupRoles();
}

	
if (isset($_POST['update_membership'])) {
	$group->updateMembership($data);
	
	if (empty($GLOBALS['am_error_log'])) {
		header("Location: g_member_profile.php?group_id=" . $group_id . "&user_id=" . $user_id . "&" . SID);
		exit;
	}
}


//group member details
$output_member = $group->getGroupMembership();

if (empty($output_member['user_id'])) {
	header("Location: g_group.php?group_id=" . $group_id . "&" . SID);
	exit;
}


if (isset($_POST['delete_membership_confirm'])) {
	$group->deleteMembership();
	header("Location: g_groups.php?my_groups=1&".SID);
	exit;
}
elseif (isset($output_member['user_id'])) {

	if (isset($_POST['delete_membership'])) {
	    $display_confirmation_delete = 1;
	}
	
	//get user and profile from membership
	$user->user_id = $output_member['user_id'];
	$user->profile_id = $output_member['profile_id'];
	$output_user = $user->getUser();
	$output_profile = $user->getProfile();
	
	//setup blog
	$blog = new Blog($db, $c_acs['arr_section']['group'], $date, $file);
	$blog->section_item_id = $group_id;
	$blog->user_id = $output_member['user_id'];
	$blog->limit = 5;
	$output_blogs = $blog->getBlogs();
	
	
	//setup forum
	$forum = new Forum($db, $c_acs['arr_section']['group'], $date, $file);
	$forum->section_item_id = $group_id;
	$forum->limit = 5;
	$forum->user_id = $output_member['user_id'];
	$output_subjects = $forum->getSubjects();
	//$output_replies = $forum->getRepliesByUser();
	
	//setup comment
	$comment = new Comment($db, $c_node['cms']['item_type']['group_forum_subject'], $date);
	$comment->section_item_id = $group_id;
	$comment->user_id = $output_member['user_id'];
	
	$output_comments = $comment->getComments(null, 1);
	
	
	
	//library setup
	$library = new Library($db, $c_acs['arr_section']['group'], $date, $file);
	$library->section_item_id = $group_id;
	$library->user_id = $output_member['user_id'];
	$output_library = $library->getLibraryItems();
	
	
	//setup statistics
	$statistic = new Statistic($db, $c_acs['arr_section']['group'], $date);
	$statistic->section_item_id = $group_id;
	$statistic->user_id = $output_member['user_id'];
	$output_statistics = $statistic->getStatistics();
	
	
	//setup file
	$file->path="user";
	$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
	if (isset($output_profile['file_id'])) {
		$file->file_id = $output_profile['file_id'];
		$output_profile['image'] = $file->getFileRecord();
	}
	elseif (isset($output_profile)) {
		$output_profile['image']['file_title'] = "";
		$output_profile['image']['file'] = $file->noimage;
	}
	
	$output_profile['profile_summary'] = $wiki->transform($output_profile['profile_summary'], 'Xhtml');
	
	//get profiles
	unset($user->file);
	$output_profiles = $user->getProfiles();
	

	//display if this person is blocked
	require_once($c_node['dir']['class_path'] . 'SocialNetwork.class.php');
	$sn = new Socialnetwork($me['user_id'], $db, $c_node['node']['node_id']);

	if ($sn->getBlockStatus($user_id)) {
		$display = "blocked";
	}

}



//move to template
if (!empty($display_confirmation_delete)) {
	$body->set('display_confirmation_delete', $display_confirmation_delete);
}

if (!empty($output_profiles)) {
   $body->set('profiles', $output_profiles);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (!empty($output_profile)) {
	$body->set('profile', $output_profile);
}

if (!empty($output_user)) {
	$body->set('user', $output_user);
}

if (!empty($output_member)) {
	$body->set('member', $output_member);
}

if (!empty($output_library)) {
	$body->set('library', $output_library);
}

if (!empty($output_blogs)) {
	$body->set('blogs', $output_blogs);
}

if (!empty($output_subjects)) {
	$body->set('subjects', $output_subjects);
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_statistics)) {
	$body->set('gm_statistics', $output_statistics);
}

if (isset($output_statistic)) {
	$body->set('group_statistic', $output_statistic);
}

if (!empty($group_roles)) {
	$body->set('group_roles', $group_roles);
}

$body->set('group_member_status_ids', $c_node['group']['member_status']);

if (!empty($display)) {
	$body->set('display', $display);
}


if (!empty($output_member['profile_nic'])) {
	$template_pageLink = $lang['txt_member_profile'];
	$template_pageLinkNote = $output_member['profile_nic'];
}

include "inc/footer.inc.php";

?>
