<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_group.inc.php";
require_once($c_node['dir']['class_path'] . 'Forum.class.php');


//ACS check
if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_forum'], $c_acs['arr_acs']['privilege']['allow_edit'])) { //resourece_id, Priv_id
	header("Location: g_group.php?group_id=" . $group_id."&".SID);
	exit;
}


//setup file
$file->noimage = $c_node['file']['image']['thumb'][2]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][2]['name'];
$file->type_ids[] = $c_node['file']['mime'][1]['suffix']; //jpg
$file->type_ids[] = $c_node['file']['mime'][2]['suffix']; //png
$file->type_ids[] = $c_node['file']['mime'][3]['suffix']; //gif


//setup forum
$forum = new Forum($db, $c_acs['arr_section']['group'], $date, $file);
$forum->section_item_id = $group_id;
$forum->user_id = $user_id;

//ACS check
if ($group_acs->checkPermission($c_acs['arr_acs']['resource']['group_forum'], $c_acs['arr_acs']['privilege']['allow_hidden'])) { //resourece_id, Priv_id
	$forum->include_hidden = 1;
}


//process requests
if (isset($_POST['insert'])) {
	
	$forum->insertSubject($data);

	if (empty($GLOBALS['am_error_log'])) {
		//setup cms
		require_once($c_node['dir']['class_path'] . 'Cms.class.php');
		$cms = new Cms($db, $c_acs['arr_section']['group']);
		$cms->section_item_id = $group_id;
		$cms->cms_item_type_id = $c_node['cms']['item_type']['group_forum_subject'];
		$cms->user_id = $user_id;
		$temp['language_id'] = $output_group['language_id'];
		$temp['genre_id'] = $output_group['genre_id'];
		$temp['item_id'] = $forum->subject_id;
		
		//insert node cms entry
		if (isset($data['cms_node'])) {
		    $temp['level_id'] = $c_node['cms']['cms_level']['node'];
		
		   	if($c_node['cms']['node']['auto_publish'] == 1) {
				$temp['status_id'] = $c_node['cms']['status']['live'];
			}
			else {
				$temp['status_id'] = $c_node['cms']['status']['pending'];
			}
			
			$cms->insertCmsItem($temp);
		}
		
		//insert group cms entry
		if (isset($data['cms_group'])) {
			$temp['level_id'] = $c_node['cms']['cms_level']['group']['home'];
			
			if ($group['group_cms_auto_publish'] == 1) {
		    	$temp['status_id'] = $c_node['cms']['status']['live'];
			}
			else {
				$temp['status_id'] = $c_node['cms']['status']['pending'];
			}
			
			$cms->insertCmsItem($temp);
		}
		
		//setup statistics
		require_once($c_node['dir']['class_path'] . 'Statistic.class.php');
		$statistic = new Statistic($db, $c_acs['arr_section']['user'], $date);
		
		//update stats
		$statistic->section_item_id = $user_id;
		$statistic->statistic_type_id = $c_node['statistic']['user']['total_forum_subjects'];
		$forum->user_id = $user_id;
		$statistic->setStatistic($forum->getSubjectCount());
		
		$statistic->statistic_type_id = $c_node['statistic']['group']['total_forum_subjects'];
		unset($forum->user_id);
		$statistic->section_item_id = $group_id;
		$statistic->section_id = $c_acs['arr_section']['group'];
		$statistic->setStatistic($forum->getSubjectCount());
		
		//goto the subject
		return header("Location: g_forum.php?group_id=". $group_id . "&subject_id=". $forum->subject_id . "&" . SID);
		exit;
	}
	else {
		$output_subject = $data;
	}

}
elseif (isset($_POST['preview'])) {
	$output_subject = $data;
	$output_subject['display_subject_body'] = nl2br($output_subject['subject_body']);
	
	if (isset($output_subject['file_id'])) {
		$file->thumb = $c_node['file']['image']['thumb'][2]['name'];
		$file->file_id = $output_subject['file_id'];
		$output_subject['image'] = $file->getFileRecord();
	}
	
	$display = "preview";
}
elseif (isset($_POST['edit_again'])) {
	$output_subject = $data;
}


//get images
$output_images = $file->getFiles();

$output_topics = $forum->getTopics();


//move to template
if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (!empty($output_topics)) {
	$body->set('topics', $output_topics);
}

if (!empty($output_subject)) {
	$body->set('subject', $output_subject);
}
if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($output_images)) {
	$body->set('images', $output_images);
}

$body->set('cms_node_auto_publish', $c_node['cms']['node']['auto_publish']);

include "inc/footer.inc.php";

?>
