<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<style type="text/css">
<!--
@import url(<?php echo $template_path_core;?>css/aroundme_form.css);
-->
</style>


<form action="index.php?amn=lbr_participation_edit" method="post" name="frm" id="id_frm">
<input type="hidden" name="set_id" value="<?php echo $set['set_id'];?>" />


<div class="col_main">
	<?php
	if (isset($participant)) {
	?>
	
	<input type="hidden" name="identity_id" value="<?php echo $participant['identity_id'];?>" />
	<input type="hidden" name="user_id" value="<?php echo $participant['user_id'];?>" />
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_participant'];?><br />
		</div>
			
		<div class="box_mid">
			<div class="content">
				<?php
				$id_card = $participant['identity'];
				include($template_path_core . "inc/identity.inc.php");
				?>
				
				
				<?php
				if ($participant['user_id'] != $set['user_id']) { // group owner - do not show edit
				?>
				
				<hr />
				
				<p>
					<label for="id_user_status"><?php echo $lang['txt_user_status'];?></label>
					<select id="id_user_status" name="status_id" style="width:160px;">
						<?php
						if (isset($lang['user_status'])) {
						foreach ($lang['user_status'] as $key => $i):
						
						$selected = "";
						if ($participant['status_id'] == $key) {
							$selected = "selected=\"selected\"";
						}
						
						?>
						<option value="<?php echo $key;?>" <?php echo $selected;?>><?php echo $i;?></option>
						<?php
						endforeach;
						}
						?>
					</select>
					<img src="<?php echo $template_path;?>img/help.png" style="cursor:help;"  title="<?php echo $lang['txt_help'];?>" hspace="2" alt="" border="0" onClick="javascript:launchPopupWindow('components/core/help.php?help=grp_group#status');" /><br />
				</p>
				
				<?php
				if ($_SESSION['user_id'] == $set['user_id']) { // owner only sets roles
				?>
				<p>
					<label for="id_user_role"><?php echo $lang['txt_role'];?></label>
					<select id="id_user_role" name="role_id" style="width:160px;">
						<option value="0" selected="selected"><?php echo $lang['txt_none'];?></option>
						<?php
						if (isset($lang['user_role'])) {
						foreach ($lang['user_role'] as $key => $i):
							
						$selected = "";
						if ($participant['role_id'] == $key) {
							$selected = "selected=\"selected\"";
						}
							
						?>
						<option value="<?php echo $key;?>" <?php echo $selected;?>><?php echo $i;?></option>
						<?php
						endforeach;
						}
						?>
					</select>
				</p>
				<?php }?>
				
				<?php
				if (isset($library_config['resource']['user'])) {
				?>
				<p>
					<b><?php echo $lang['hdr_permissions'];?></b><br />
				</p>
		
				<?php
				foreach($library_config['resource']['user'] as $rekey => $re):
				?>
				
				<?php
				$checked = "";
				if ($participant['participation_permission'] & $library_config['resource']['user'][$rekey]) {
					$checked = "checked=\"checked\"";
				}
				?>
				<p>
					<input type="checkbox" name="permission[user][<?php echo $re;?>]" value="<?php echo $re;?>" <?php echo $checked;?> />&nbsp;
					<?php echo $lang['resource']['lbr']['user'][$re];?><br />
				</p>
				<?php
				endforeach;
				?>
						
				<?php }?>
				
				<?php
				if (($participant['user_id'] != $set['user_id'])) { // item owner only
				?>
				<hr />
				
				<p align="right">
					<input type="submit" name="update_user_participation" class="input_submit" value="<?php echo $lang['sub_update'];?>" /><br />
				</p>	
				<?php }?>
				<?php }?>
			</div>
		</div>
	</div>
	<?php
	}
	elseif (isset($_REQUEST['resource']) || isset($_REQUEST['status_id']) || isset($_REQUEST['role_id'])) {
	?>
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_people'];?><br />
		</div>
			
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($participants)) {
				?>
				<table cellspacing="0" cellpadding="2" border="0" width="100%">
					<?php
					foreach($participants as $key => $i):
					?>
					<tr>
						<td valign="top">
							<a href="index.php?amn=lbr_participation_edit&amp;set_id=<?php echo $set['set_id'];?>&amp;identity_id=<?php echo $i['identity_id'];?>"><?php echo $i['identity']['identity_nic'];?></a><br />
						</td>
						<td valign="top">
							<?php echo $this->date->formatDate($i['participation_create_datetime']);?><br />
						</td>
						<td valign="top">
							<?php
							if (isset($lang['user_status'][$i['status_id']])) {
								echo $lang['user_status'][$i['status_id']];
							}
							?>
							<br />
						</td>
						<td valign="top">
							<?php
							if ($i['user_id'] == $set['user_id']) {
								echo $lang['txt_owner'];
							}
							elseif (isset($lang['user_role'][$i['role_id']])) {
								echo $lang['user_role'][$i['role_id']];
							}
							?>
							<br />
						</td>
						<td align="right" valign="top">
							<?php
							if (isset($_REQUEST['status_id'])) {
							if ($i['user_id'] != $set['user_id']) {
							?>
							<input type="checkbox" name="identity_ids[]" value="<?php echo $i['identity_id'];?>" /><br />
							<?php }}?>						
						</td>
					</tr>
					<tr>
						<td valign="top">
							<br />
						</td>
						<td valign="top" colspan="4">
							<?php
							$prnt = "";
							if (isset($library_config['resource']['user'])) {
								foreach($library_config['resource']['user'] as $rekey => $re):
									if ($i['participation_permission'] & $library_config['resource']['user'][$rekey]) {
										$prnt .= $lang['resource']['lbr']['user'][$re] . ", ";
									}
								endforeach;
								$prnt = substr($prnt, 0, -2);
							}
							?>
							<i><?php echo $prnt;?></i><br />
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>
				
				<hr />
				
				<p align="right">
					<?php
					if (isset($_REQUEST['status_id']) && $_REQUEST['status_id'] != $library_config['user']['status']['hold']) {
					?>
					<input type="submit" name="sub_set_hold" id="id_sub_insert" class="input_submit" value="<?php echo $lang['sub_set_hold'];?>" />
					<?php }?>
					
					<?php
					if (isset($_REQUEST['status_id']) && $_REQUEST['status_id'] != $library_config['user']['status']['barred']) {
					?>
					<input type="submit" name="sub_set_barred" id="id_sub_insert" class="input_submit" value="<?php echo $lang['sub_set_barr'];?>" />
					<?php }?>
					
					<?php
					if (isset($_REQUEST['status_id']) && $_REQUEST['status_id'] != $library_config['user']['status']['active']) {
					?>
					<input type="submit" name="sub_set_active" id="id_sub_insert" class="input_submit" value="<?php echo $lang['sub_set_active'];?>" />
					<?php }?>
					<br />
				</p>
				<?php
				}
				else {
				?>
					<?php echo $lang['template_error']['err_no_items'];?><br />
				<?php }?>
			</div>
		</div>
	</div>
	
	<?php
	}
	else {
	?>
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_permissions'];?><br />
		</div>
			
		<div class="box_mid">
			<div class="content">
				<p>
					<?php echo $lang['txt_user_permission_intro'];?><br />
				</p>
				
				<?php
				if (isset($library_config['resource']['user'])) {
				foreach($library_config['resource']['user'] as $rekey => $re):
				?>
				
				<?php
				$checked = "";
				if ($set['default_user_permission'] & $library_config['resource']['user'][$rekey]) {
					$checked = "checked=\"checked\"";
				}
				?>
				<p>
					<input type="checkbox" name="permission[user][<?php echo $re;?>]" value="<?php echo $re;?>" <?php echo $checked;?> />&nbsp;
					<?php echo $lang['resource']['lbr']['user'][$re];?><br />
				</p>
				<?php
				endforeach;
				}
				?>
				
				<hr />
				
				<p align="right">
					<input type="submit" name="set_default_user_permission" class="input_submit" value="<?php echo $lang['sub_set_default_user_permission'];?>" /><br />
				</p>
			</div>
		</div>
	</div>
	<?php }?>
</div>

<div class="col_side">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_options'];?><br />
		</div>
			
		<div class="box_mid">
			<div class="content">
				<p>
					<b><?php echo $set['set_title'];?><br /></b><br />
					<?php echo $set['set_synopsis'];?><br />
				</p>
				
				<hr />
				
				<?php
				if (isset($library_config['role'])) {
				?>
				<p>
					<b><?php echo $lang['href_role'];?></b><br />
				
					<?php
					foreach($library_config['role'] as $key => $i):
					?>
					<a href="index.php?amn=lbr_participation_edit&amp;role_id=<?php echo $i;?>&amp;set_id=<?php echo $set['set_id'];?>"><?php echo $lang['user_role'][$i];?></a><br />
					
					<?php
					endforeach;
					?>
				</p>
				<?php }?>
				
				<?php
				if (isset($library_config['user']['status'])) {
				?>
				<p>
					<b><?php echo $lang['href_status'];?></b><br />
				
					<?php
					foreach($library_config['user']['status'] as $key => $i):
					?>
					<a href="index.php?amn=lbr_participation_edit&amp;status_id=<?php echo $i;?>&amp;set_id=<?php echo $set['set_id'];?>"><?php echo $lang['user_status'][$i];?></a><br />
					
					<?php
					endforeach;
					?>
				</p>
				<?php }?>
				
				<?php
				if (isset($library_config['resource']['user'])) {
				?>
				<p>
					<b><?php echo $lang['href_permissions'];?></b><br />
				
					<?php
					foreach($library_config['resource']['user'] as $key => $i):
					?>
					<a href="index.php?amn=lbr_participation_edit&amp;resource=<?php echo $i;?>&amp;set_id=<?php echo $set['set_id'];?>"><?php echo $lang['resource']['lbr']['user'][$i];?></a><br />
					
					<?php
					endforeach;
					?>
				</p>
				<?php }?>
				
				<p>
					<a href="index.php?amn=lbr_participation_edit&amp;set_id=<?php echo $set['set_id'];?>"><?php echo $lang['href_default_permissions'];?></a><br />
				</p>
				
			</div>
		</div>
	</div>
</div>
</form>