<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "group";

include_once ("config/grp.config.php");
include_once ("inc/grp_initiate.inc.php");


require_once ("components/core/class/File.class.php");
$file = new File($db, $core_config['file']);
$file->module_id = $core_config['module_id']['group'];
$file->core_config_module = $core_config['module'];
$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
$file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];
$group->file = $file;


// SETUP COMMENTS --------------------------------------------------------
require_once('components/core/class/Comment.class.php');
$comment = new Comment($db, $core_config['module_id']['group']);
//$comment->wiki = $wiki;


// GET LATEST SUBJECTS ----------------------------------------------------
$group->limit = 16;

$output_subjects = $group->selSubjects();

if (!empty($output_subjects)) {
	$comment->limit = 1;
	$comment->order_by = "c.comment_create_datetime desc";
	
	foreach ($output_subjects as $key => $i):
		$comment->inner_item_id = $i['subject_id'];
		
		// get comment count
		$output_subjects[$key]['total_comments'] = $comment->countComments();
		
		// get latest comment for each subject
		$output_subjects[$key]['latest_comment'] = $comment->selComments($i['subject_id']);
		
		// get user
		$output_subjects[$key]['identity'] = $user->selUserIdentity($i['user_id']);
	endforeach;
	
	$body->set('subjects', $output_subjects);
}


// GET LATEST GROUPS
$group->limit = 4;
$group->order_by = "group_create_datetime desc";
$output_groups = $group->selGroups();

if (!empty($output_groups)) {
	$body->set('groups', $output_groups);
}

unset ($group->order_by, $group->limit);


// participation in groups
if (isset($_SESSION['user_id'])) {
	require_once('components/core/class/Participation.class.php');
	$participation = new Participation($db, $core_config);
	$participation->module_id = $core_config['module_id']['group'];
	$participation->status_id = $core_config['participation']['status']['active'];
	
	$output_participation = $participation->selParticipants(null, null, $_SESSION['user_id']);
	
	if (!empty($output_participation)) {
		// we get item_id's and we get the sets from that
		foreach ($output_participation as $key => $i):
			$group->group_ids[] = $i['item_id'];
		endforeach;
		
		
		if (!empty($group->group_ids)) {
			$output_my_groups = $group->selGroups();
			
			$body->set('my_groups', $output_my_groups);
		}
	}

	// FAVOURITES -----------------------------------------
	require_once('components/core/class/Bookmark.class.php');
	$bookmark = new Bookmark($db, $core_config['module_id']['group']);
	
	// get my bookmarked favourites
	$bookmark->bookmark_type = $core_config['bookmark']['type']['watch'];
	$output_bookmarks = $bookmark->selBookmarks(1);
	
	if (!empty($output_bookmarks)) {
		// we get item_id's and we get the sets from that
		foreach ($output_bookmarks as $key => $i):
			$group->page_ids[] = $i['inner_item_id'];
		endforeach;
		
		unset ($group->file);
		
		if (!empty($group->page_ids)) {
			$output_my_bookmarks = $group->selSubjects(null, 1);
			
			if (!empty($output_my_bookmarks)) {
				$body->set('my_bookmarks', $output_my_bookmarks);
			}
		}
		
	}
	
// REVISIONS FROM RESPECTED NETWORK
	require_once ("components/core/class/File.class.php");
	$file = new File($db, $core_config['file']);
	$file->user_id = $_SESSION['user_id'];
	$file->module_id = 0; // core
	$file->directory = "core";
	$user->file = $file;
	$user->file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
	$user->file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];

	// get latest subjects from our respected network
	$query = "
		SELECT i.identity_id, i.identity_nic, i.file_id, s.subject_id, s.subject_create_datetime,
		s.subject_title, s.group_id 
		FROM " . $db->prefix . "_user_identity i, " . $db->prefix . "_relation r, " . $db->prefix . "_group_subject s 
		WHERE 
		r.user_id=" . $_SESSION['user_id'] . " AND
		r.identity_id_relation=i.identity_id AND
		s.user_id=i.user_id 
		order by s.subject_create_datetime desc"
	;

	$result = $db->SelectLimit($query, 6);

	if (isset($result->fields)) {
		$output_respected_published_subjects = array();

		while (!$result->EOF) {
			$temp = $result->fields;

			if (isset($temp['file_id'])) {
				if (isset($file->thumb)) {
					$temp['image'] = $file->selFile($temp['file_id'], $file->thumb);
				}
				else {
					$temp['image'] = $file->selFile($temp['file_id'], "t2");
				}
			
			}
			else {
				$temp['image']['file_title'] = "";
				$temp['image']['file_md5_name_view'] = '0-' . $file->no_image;
				$temp['image']['type'] = "image/png";
				$temp['image']['directory'] = "";
			}

			array_push($output_respected_published_subjects, $temp);

			$result->MoveNext();
		}
		
		if (!empty($output_respected_published_subjects)) {
			$body->set('respected_published_subjects', $output_respected_published_subjects);
		}
	}

	// COMMENTS FROM RESPECTED NETWORK
	$query = "
		SELECT i.identity_id, i.identity_nic, i.file_id, c.comment_id, c.comment_create_datetime,
		c.comment_body, c.item_id, c.module_id, c.inner_item_id 
		FROM " . $db->prefix . "_user_identity i, " . $db->prefix . "_relation r, " . $db->prefix . "_comment c
		WHERE
		r.user_id=" . $_SESSION['user_id'] . " AND
		r.identity_id_relation=i.identity_id AND
		c.user_id=i.user_id AND
		c.module_id=" . $core_config['module_id']['group'] . "
		ORDER BY c.comment_create_datetime desc"
	;

	$result = $db->SelectLimit($query, 6);

	if (isset($result->fields)) {
		$output_respected_published_comments = array();

		while (!$result->EOF) {
			$temp = $result->fields;

			if (isset($temp['file_id'])) {
				if (isset($file->thumb)) {
					$temp['image'] = $file->selFile($temp['file_id'], $file->thumb);
				}
				else {
					$temp['image'] = $file->selFile($temp['file_id'], "t2");
				}
			
			}
			else {
				$temp['image']['file_title'] = "";
				$temp['image']['file_md5_name_view'] = '0-' . $file->no_image;
				$temp['image']['type'] = "image/png";
				$temp['image']['directory'] = "";
			}

			array_push($output_respected_published_comments, $temp);

			$result->MoveNext();
		}
		
		if (!empty($output_respected_published_comments)) {
			$body->set('respected_published_comments', $output_respected_published_comments);
		}
	}
}

?>
