<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


include_once ("config/grp.config.php");
include_once ("inc/grp_initiate.inc.php");

if (empty($output_group)) {
	header("Location: index.php?amn=grp_list&" . strip_tags(SID));
	exit;
}


if (!empty($_SESSION['fullscreen'])) { // module full screen mode is selected
	$template_file = "item_fs.tpl.php";
}



// SELECT TOPICS ----------------------------------------------------
$output_topics = $group->selTopics(1);

if (!empty($output_topics)) {
	$body->set('topics', $output_topics);
}


// SETUP FILE -------------------------------------------------
require_once ("components/core/class/File.class.php");
$file = new File($db, $core_config['file']);
$file->module_id = $core_config['module_id']['group'];
$file->core_config_module = $core_config['module'];
$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
$file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];
$group->file = $file;


// SETUP COMMENTS --------------------------------------------------------
require_once('components/core/class/Comment.class.php');
$comment = new Comment($db, $core_config['module_id']['group'], $output_group['group_id']);
$comment->item_id = $output_group['group_id'];
	
	
// GET LATEST SUBJECTS -------------------------------------------------	
$group->limit = 6;
$output_subjects = $group->selSubjects();

if (!empty($output_subjects)) {
	$comment->limit = 1;
	$comment->order_by = "c.comment_create_datetime desc";
	
	foreach ($output_subjects as $key => $i):
		$comment->inner_item_id = $i['subject_id'];
		
		// get comment count
		$output_subjects[$key]['total_comments'] = $comment->countComments();
		
		// get latest comment for each subject
		$output_subjects[$key]['latest_comment'] = $comment->selComments($i['subject_id']);
		
		// get user
		$output_subjects[$key]['identity'] = $user->selUserIdentity($i['user_id']);
	endforeach;
	
	$body->set('subjects', $output_subjects);
}


// get statistics
$output_statistics = array();
$output_statistics['topics'] = $group->countTopics();
$output_statistics['subjects'] = $group->countSubjects();
$output_statistics['pending_participants'] = $participation->countParticipants($group_config['user']['status']['pending']);
$output_statistics['active_participants'] = $participation->countParticipants($group_config['user']['status']['active']);
$body->set('statistics', $output_statistics);



// GET RECOMMENDATIONS TO THE GROUP -----------------------------------------------------
$group->limit = 6;
$output_recommendations = $group->selRecommendations();

if (!empty($output_recommendations)) {
	// we include all module files which have a function to obtain a single item
	// module_id 1 will include a function called -selItemModule1
	if (!empty($core_config['module'])) {
		foreach($core_config['module'] as $key => $i):
			$suffix = $core_config['module'][$key]['prefix'];
			
		    if(is_file("components/" . $suffix . "/inc/" . $suffix . "_item_select.function.php")) {
		    	include_once("components/" . $suffix . "/inc/" . $suffix . "_item_select.function.php");
		    }
		endforeach;
	}
	
	if (isset($core_config['module'])) {
		foreach($output_recommendations as $key => $i) {
			$suffix = $core_config['module'][$i['module_id']]['prefix'];
			$function_name = "selItemModule_" . $suffix;
			
			if (function_exists($function_name)) {
				$output_recommendations[$key]['item'] = $function_name($i['item_id'], $i['inner_item_id']);
			}
			
		}
	}

	$body->set('recommendations', $output_recommendations);

}



// get bookmarked subjects
if (isset($_SESSION['user_id'])) {
	require_once('components/core/class/Bookmark.class.php');
	$bookmark = new Bookmark($db, $core_config['module_id']['group'], $output_group['group_id']);
	$bookmark->bookmark_type = $core_config['bookmark']['type']['watch'];
	$bookmark->user_id = $_SESSION['user_id'];
	
	$output_bookmarks = $bookmark->selBookmarks(1);
	
	if (!empty($output_bookmarks)) {
		foreach ($output_bookmarks as $key => $i):
			$group->subject_ids[] = $i['inner_item_id'];
		endforeach;
		
		if (!empty($group->subject_ids)) {
			$output_bookmarks = $group->selSubjects();
		}
		
		if (!empty($output_bookmarks)) {
			$body->set('bookmarks', $output_bookmarks);
		}
	}
}


// get latest comments
$comment->limit = 6;
$comment->order_by = "c.comment_create_datetime desc";
$output_comments = $comment->selComments();

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($_SESSION['fullscreen']) && !empty($output_group['file_id'])) {
	// get group image
	
	$output_group['image'] = $file->selFile($output_group['file_id'], $core_config['file']['image']['thumb'][1]['suffix']);
}

// move group to templates
$tpl->set('group', $output_group);
$body->set('group', $output_group);
$body->set('participation', $output_participation);

?>
