<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


include_once('inc/evt_initiate.inc.php');

if ($output_participation['participation_permission'] & $event_config['resource']['user']['manage_participants'] == 0) {
	header('location: index.php?amn=evt_participate&event_id=' . $output_event['event_id']);
	exit;
}


if (isset($_REQUEST['role_id']) && is_numeric($_REQUEST['role_id'])) {
	$output_participants = $participation->selParticipants(null, $_REQUEST['role_id']);
	foreach($output_participants as $key => $p) {
		$output_participants[$key]['identity'] = $user->selUserIdentity(null, $p['identity_id'], null);
	}
}

if (isset($_REQUEST['resource']) && is_numeric($_REQUEST['resource'])) {
	$query = "
		SELECT p.user_id, p.status_id, p.identity_id, p.participation_permission, 
		p.participation_create_datetime, p.role_id, p.item_id 
		FROM " . $db->prefix . "_participation p
		WHERE p.module_id=" . $core_config['module_id']['event'] . " AND 
		p.item_id=" . $output_event['event_id'] . " AND 
		p.participation_permission & " . $_REQUEST['resource'] . " != 0"
	;
	
	$result = $db->Execute($query);
	$output_participants = array();
	
	if (isset($result->fields)) {
		while(!$result->EOF) {
			array_push($output_participants, $result->fields);
			$result->moveNext();
		}
		$result->Close();
	}
	else {
		// error-code here
	}
	
	foreach($output_participants as $key => $p) {
		$output_participants[$key]['identity'] = $user->selUserIdentity(null, $p['identity_id'], null);
	}
}

if (isset($_REQUEST['status_id']) && is_numeric($_REQUEST['status_id'])) {
	$output_participants = $participation->selParticipants($_REQUEST['status_id']);
	foreach($output_participants as $key => $p) {
		$output_participants[$key]['identity'] = $user->selUserIdentity(null, $p['identity_id'], null);
	}
}

if (isset($_REQUEST['identity_id'])) {
	$output_participant = $participation->selParticipation(null, $_REQUEST['identity_id']);
	$output_participant['identity'] = $user->selUserIdentity(null, $_REQUEST['identity_id'], null);
}

if (isset($_POST['update_user_participation'])) {

	$permission_count = 0;
	if (isset($_POST['permission']['user']) && !empty($_POST['permission']['user'])) {
		foreach($_POST['permission']['user'] as $i) {
			$permission_count += $i;
		}
	}

	$participation->user_id = $output_participant['user_id'];
	$data = array();
	$data['status_id'] = $_POST['status_id'];
	$data['participation_permission'] = $permission_count;
	if (isset($_POST['role_id'])) {
		$data['role_id'] = $_POST['role_id'];
	}
	
	$participation->updateParticipant($data);
 	$output_participant = $participation->selParticipation(null, $_REQUEST['identity_id']);
 	$output_participant['identity'] = $user->selUserIdentity(null, $_REQUEST['identity_id'], null);
}

if (isset($_POST['set_default_user_permission'])) {
	$query = "
		SELECT * 
		FROM " . $db->prefix . "_event 
		WHERE 
		event_id=" . $_REQUEST['event_id']
	;

	$result = $db->Execute($query);
	
	if (isset($result->fields)) {
		$rec = array();
		$permission_count = 0;
		if (isset($_POST['permission']['user'])) {
				
			foreach ($_POST['permission']['user'] as $key => $i):
				$permission_count += $i;
			endforeach;
				
			
		}
		$rec['default_user_permission'] = $permission_count;
		$output_event['default_user_permission'] = $permission_count;
		$body->set('event', $output_event);
		
		$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $db->Execute($query);
	}
}

if (isset($_POST['sub_set_barred'])) {
	if (!empty($_POST['identity_ids'])) {
		$participation->setUserStatus($_POST['identity_ids'], $event_config['user']['status']['barred']);
	}
}

if (isset($_POST['sub_set_pending'])) {
	if (!empty($_POST['identity_ids'])) {
		$participation->setUserStatus($_POST['identity_ids'], $event_config['user']['status']['pending']);
	}
}

if (isset($_POST['sub_set_active'])) {
	if (!empty($_POST['identity_ids'])) {
		$participation->setUserStatus($_POST['identity_ids'], $event_config['user']['status']['active']);
	}
}


if (!empty($output_event)) {
	$body->set('event', $output_event);
}

if (!empty($output_participants)) {
	$body->set('participants', $output_participants);
}

if (!empty($output_participant)) {
	$body->set('participant', $output_participant);
}

$body->set('event_config', $event_config);

?>