/*  ADCD - A Diminutive CD player for GNU/Linux
    Copyright (C) 2004, 2005 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "msf_time.h"


Msf_time::Msf_time( const int m, const int s, const int f ) throw()
  : _minute( m ), _second( s ), _frame( f )
  {
  if( _frame >= fps ) { _second += _frame / fps; _frame %= fps; }
  else if( _frame < 0 )
    { int i = (fps - 1 - _frame) / fps; _second -= i; _frame += fps * i; }

  if( _second >= 60 ) { _minute += _second / 60; _second %= 60; }
  else if( _second < 0 )
    { int i = (59 - _second) / 60; _minute -= i; _second += 60 * i; }

  if( _minute < 0 ) _minute = _second = _frame = 0;
  }


Msf_time & Msf_time::operator+=( const Msf_time & a ) throw()
  {
  _frame += a._frame; if( _frame >= fps ) { _frame -= fps; ++_second; }
  _second += a._second; if( _second >= 60 ) { _second -= 60; ++_minute; }
  _minute += a._minute;
  return *this;
  }


Msf_time & Msf_time::operator-=( const Msf_time & a ) throw()
  {
  _frame -= a._frame; if( _frame < 0 ) { _frame += fps; --_second; }
  _second -= a._second; if( _second < 0 ) { _second += 60; --_minute; }
  _minute -= a._minute;
  if( _minute < 0 ) _minute = _second = _frame = 0;
  return *this;
  }


bool Msf_time::operator<( const Msf_time & a ) const throw()
  {
  return _minute < a._minute ||
      ( _minute == a._minute && _second < a._second ) ||
      ( _minute == a._minute && _second == a._second && _frame < a._frame );
  }


bool Msf_time::operator>( const Msf_time & a ) const throw()
  {
  return _minute > a._minute ||
      ( _minute == a._minute && _second > a._second ) ||
      ( _minute == a._minute && _second == a._second && _frame > a._frame );
  }
