/*
 * Decompiled with CFR 0.152.
 */
package hughai.test;

import com.springrts.ai.oo.AIFloat3;
import com.springrts.ai.oo.clb.Map;
import com.springrts.ai.oo.clb.OOAICallback;
import com.springrts.ai.oo.clb.Unit;
import com.springrts.ai.oo.clb.UnitDef;
import hughai.CSAI;
import hughai.PlayerObjects;
import hughai.VoiceCommandHandler;
import hughai.basictypes.Float3;
import hughai.basictypes.TerrainPos;
import hughai.ui.MainUI;
import hughai.unitdata.UnitDefHelp;
import hughai.utils.Config;
import hughai.utils.DrawingUtils;
import hughai.utils.LogFile;
import java.util.List;

public class Tester {
    Config config;
    PlayerObjects playerObjects;
    OOAICallback aicallback;
    LogFile logfile;
    CSAI csai;

    public Tester(PlayerObjects playerObjects) {
        this.playerObjects = playerObjects;
        this.csai = playerObjects.getCSAI();
        this.config = playerObjects.getConfig();
        this.aicallback = playerObjects.getAicallback();
        this.logfile = playerObjects.getLogFile();
        playerObjects.getMainUI().registerButton("Run tests", new ButtonRunTests());
        playerObjects.getMainUI().registerButton("Run drawline tests", new ButtonRunDrawlineTests());
    }

    void drawlineTests() {
        this.drawlineTests3();
    }

    void drawlineTests2() {
        this.aicallback.getMap().getDrawer().getFigure().drawLine(new AIFloat3(0.0f, 100.0f, 0.0f), new AIFloat3(100.0f, 100.0f, 0.0f), 1.0f, false, 200, 0);
    }

    void drawmapTests1() {
        Map map = this.aicallback.getMap();
        int n = map.getWidth();
        int n2 = map.getHeight();
        boolean[][] blArray = new boolean[n][n2];
        DrawingUtils drawingUtils = this.playerObjects.getDrawingUtils();
        for (int i = 100; i < 320; ++i) {
            for (int j = 100; j < 320; ++j) {
                blArray[i][j] = true;
            }
        }
        drawingUtils.DrawMap(blArray);
    }

    void drawmapTests2() {
        int n;
        Map map = this.aicallback.getMap();
        int n2 = map.getWidth();
        int n3 = map.getHeight();
        boolean[][] blArray = new boolean[n2][n3];
        DrawingUtils drawingUtils = this.playerObjects.getDrawingUtils();
        int n4 = n2;
        int n5 = n3;
        for (int i = 100; i < 320; ++i) {
            for (n = 100; n < 320; ++n) {
                blArray[i][n] = true;
            }
        }
        for (n = 0; n < n5; ++n) {
            for (int i = 0; i < n4; ++i) {
                float f = 100.0f;
                if (i < n4 - 1 && blArray[i][n] != blArray[i + 1][n]) {
                    drawingUtils.AddLine(new TerrainPos((i + 1) * 8, f, n * 8), new TerrainPos((i + 1) * 8, f, (n + 1) * 8));
                }
                if (n >= n5 - 1 || blArray[i][n] == blArray[i][n + 1]) continue;
                drawingUtils.AddLine(new TerrainPos(i * 8, f, (n + 1) * 8), new TerrainPos((i + 1) * 8, f, (n + 1) * 8));
            }
        }
    }

    void drawlineTests3() {
        Map map = this.aicallback.getMap();
        int n = map.getWidth();
        int n2 = map.getHeight();
        DrawingUtils drawingUtils = this.playerObjects.getDrawingUtils();
        for (int i = 0; i < 8193; ++i) {
            drawingUtils.AddLine(new TerrainPos(100.0f, 100.0f, 100.0f), new TerrainPos(200.0f, 100.0f, 100.0f));
        }
    }

    void drawlineTests1() {
        int n;
        Map map = this.aicallback.getMap();
        int n2 = map.getWidth();
        int n3 = map.getHeight();
        DrawingUtils drawingUtils = this.playerObjects.getDrawingUtils();
        drawingUtils.AddLine(new TerrainPos(-100.0f, 100.0f, -100.0f), new TerrainPos(5000.0f, 100.0f, 5000.0f));
        for (n = 0; n < n3; ++n) {
            drawingUtils.AddLine(new TerrainPos(0.0f, 100.0f, n * 8), new TerrainPos(100.0f, 100.0f, n * 8));
            drawingUtils.AddLine(new TerrainPos((n2 - 10) * 8, 100.0f, n * 8), new TerrainPos(n2 * 8, 100.0f, n * 8));
            drawingUtils.AddLine(new TerrainPos(0.0f, 100.0f, n * 8), new TerrainPos(n2 * 8, 100.0f, n * 8));
        }
        for (n = 0; n < n3; ++n) {
            drawingUtils.AddLine(new TerrainPos(n * 8, 100.0f, 0.0f), new TerrainPos(n * 8, 100.0f, 1000.0f));
            drawingUtils.AddLine(new TerrainPos(n * 8, 100.0f, (n3 - 10) * 8), new TerrainPos(n * 8, 100.0f, (n3 - 0) * 8));
            drawingUtils.AddLine(new TerrainPos(n * 8, 100.0f, 0.0f), new TerrainPos(n * 8, 100.0f, (n3 - 0) * 8));
        }
    }

    void runTests() {
        this.testgetmilliseconds();
        this.testgetunitdefs();
        this.testgetfriendlyunits();
        this.testgetpos();
        this.testgetunitdef();
        this.testgetsquareddistance();
        this.testismobile();
        this.testunithash();
        this.testgethumanname();
        this.testgetspeed();
        this.testCheats();
    }

    void debug(Object object) {
        this.logfile.WriteLine("" + object);
    }

    void dumpEnemyUnits() {
        this.debug("num units: " + this.aicallback.getEnemyUnits().size());
        for (Unit unit : this.aicallback.getEnemyUnits()) {
            this.debug(unit.getUnitId() + " " + unit.getDef().getHumanName() + " " + unit.getPos());
        }
    }

    void testCheats() {
        boolean bl = this.aicallback.getCheats().isEnabled();
        this.logfile.WriteLine("Enemy units with cheating off:");
        this.aicallback.getCheats().setEnabled(false);
        this.dumpEnemyUnits();
        this.logfile.WriteLine("Enemy units with cheating ON:");
        this.aicallback.getCheats().setEnabled(true);
        this.dumpEnemyUnits();
        this.aicallback.getCheats().setEnabled(bl);
    }

    void testgetmilliseconds() {
        int n = 0;
        long l = System.currentTimeMillis();
        long l2 = l + 1000L;
        while ((byte)n != 0 || System.currentTimeMillis() < l2) {
            ++n;
        }
        this.logfile.WriteLine("testgetmilliseconds count: " + n);
    }

    void testgetunitdefs() {
        int n = 0;
        long l = System.currentTimeMillis();
        long l2 = l + 1000L;
        while ((byte)n != 0 || System.currentTimeMillis() < l2) {
            this.aicallback.getUnitDefs();
            ++n;
        }
        this.logfile.WriteLine("testgetunitdefs count: " + n);
    }

    void testgetfriendlyunits() {
        int n = 0;
        long l = System.currentTimeMillis();
        long l2 = l + 1000L;
        while ((byte)n != 0 || System.currentTimeMillis() < l2) {
            this.aicallback.getFriendlyUnits();
            ++n;
        }
        this.logfile.WriteLine("testgetfriendlyunits count: " + n);
    }

    void testgetpos() {
        Unit unit = (Unit)this.aicallback.getFriendlyUnits().get(0);
        int n = 0;
        long l = System.currentTimeMillis();
        long l2 = l + 1000L;
        while ((byte)n != 0 || System.currentTimeMillis() < l2) {
            AIFloat3 aIFloat3 = unit.getPos();
            ++n;
        }
        this.logfile.WriteLine("testgetpos count: " + n);
    }

    void testgetunitdef() {
        Unit unit = (Unit)this.aicallback.getFriendlyUnits().get(0);
        int n = 0;
        long l = System.currentTimeMillis();
        long l2 = l + 1000L;
        while ((byte)n != 0 || System.currentTimeMillis() < l2) {
            UnitDef unitDef = unit.getDef();
            ++n;
        }
        this.logfile.WriteLine("testgetunitdef count: " + n);
    }

    void testgethumanname() {
        UnitDef unitDef = ((Unit)this.aicallback.getFriendlyUnits().get(0)).getDef();
        int n = 0;
        long l = System.currentTimeMillis();
        long l2 = l + 1000L;
        while ((byte)n != 0 || System.currentTimeMillis() < l2) {
            String string = unitDef.getHumanName();
            if (string.equals("foo")) {
                this.logfile.WriteLine("blah");
            }
            ++n;
        }
        this.logfile.WriteLine("testgethumanname count: " + n);
    }

    void testgetspeed() {
        UnitDef unitDef = ((Unit)this.aicallback.getFriendlyUnits().get(0)).getDef();
        int n = 0;
        long l = System.currentTimeMillis();
        long l2 = l + 1000L;
        while ((byte)n != 0 || System.currentTimeMillis() < l2) {
            float f = unitDef.getSpeed();
            ++n;
        }
        this.logfile.WriteLine("testgetspeed count: " + n);
    }

    void testgetsquareddistance() {
        int n = 0;
        long l = System.currentTimeMillis();
        long l2 = l + 1000L;
        Float3 float3 = new Float3(1000.3353f, 125.25f, 2353.35f);
        Float3 float32 = new Float3(3550.3352f, 130.25f, 3235.35f);
        long l3 = 0L;
        while ((byte)n != 0 || System.currentTimeMillis() < l2) {
            float f = float3.GetSquaredDistance(float32);
            l3 = (long)((float)l3 + f);
            float32.x += 1.0f;
            ++n;
        }
        this.logfile.WriteLine("testgetsquareddistance count: " + n);
    }

    void testismobile() {
        int n = 0;
        long l = System.currentTimeMillis();
        long l2 = l + 1000L;
        Float3 float3 = new Float3(1000.3353f, 125.25f, 2353.35f);
        Float3 float32 = new Float3(3550.3352f, 130.25f, 3235.35f);
        long l3 = 0L;
        UnitDefHelp unitDefHelp = this.playerObjects.getUnitDefHelp();
        List list = this.aicallback.getUnitDefs();
        while ((byte)n != 0 || System.currentTimeMillis() < l2) {
            float f = float3.GetSquaredDistance(float32);
            l3 = (long)((float)l3 + f);
            float32.x += 1.0f;
            UnitDef unitDef = (UnitDef)list.get(n % 100);
            unitDefHelp.IsMobile(unitDef);
            ++n;
        }
        this.logfile.WriteLine("testismobile count: " + n);
    }

    void testunithash() {
        int n = 0;
        long l = System.currentTimeMillis();
        long l2 = l + 1000L;
        Unit unit = (Unit)this.aicallback.getFriendlyUnits().get(0);
        Unit unit2 = (Unit)this.aicallback.getFriendlyUnits().get(1);
        while ((byte)n != 0 || System.currentTimeMillis() < l2) {
            int n2 = unit.hashCode();
            ++n;
        }
        this.logfile.WriteLine("testunithash count: " + n);
    }

    class VoiceGo
    implements VoiceCommandHandler {
        VoiceGo() {
        }

        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            Tester.this.runTests();
        }
    }

    class ButtonRunDrawlineTests
    implements MainUI.ButtonHandler {
        ButtonRunDrawlineTests() {
        }

        @Override
        public void go() {
            Tester.this.csai.sendTextMessage("Running drawline tests.");
            Tester.this.drawlineTests();
        }
    }

    class ButtonRunTests
    implements MainUI.ButtonHandler {
        ButtonRunTests() {
        }

        @Override
        public void go() {
            Tester.this.csai.sendTextMessage("Running tests.   please check console");
            Tester.this.runTests();
        }
    }
}

