/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.sf.juife.wizard.UserInputPage;
import org.jsampler.HF;
import org.jsampler.view.classic.ClassicI18n;
import org.jsampler.view.classic.NewChannelWizardModel;
import org.linuxsampler.lscp.Parser;

class InstrumentWizardPage
extends UserInputPage {
    private final JLabel lFilename = new JLabel(ClassicI18n.i18n.getLabel("InstrumentChooser.lFilename"));
    private final JLabel lIndex = new JLabel(ClassicI18n.i18n.getLabel("InstrumentChooser.lIndex"));
    private final JTextField tfFilename = new JTextField();
    private final JSpinner spinnerIndex = new JSpinner(new SpinnerNumberModel(0, 0, 500, 1));
    private final JButton btnBrowse = new JButton(ClassicI18n.i18n.getLabel("InstrumentChooser.btnBrowse"));

    InstrumentWizardPage() {
        super(ClassicI18n.i18n.getLabel("InstrumentWizardPage.subtitle"));
        this.setMainInstructions(ClassicI18n.i18n.getLabel("InstrumentWizardPage.mainInstructions"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.lFilename);
        jPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        this.tfFilename.setPreferredSize(new Dimension(200, this.tfFilename.getPreferredSize().height));
        this.tfFilename.setMaximumSize(this.tfFilename.getPreferredSize());
        jPanel.add(this.tfFilename);
        jPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        this.spinnerIndex.setMaximumSize(this.spinnerIndex.getPreferredSize());
        jPanel.add(this.spinnerIndex);
        jPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        jPanel.add(this.btnBrowse);
        jPanel.setMaximumSize(jPanel.getPreferredSize());
        this.setMainPane(jPanel);
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InstrumentWizardPage.this.onBrowse();
            }
        });
        this.btnBrowse.requestFocusInWindow();
    }

    @Override
    public void preinitPage() {
        NewChannelWizardModel newChannelWizardModel = (NewChannelWizardModel)this.getWizardModel();
        if (newChannelWizardModel.getSelectedAudioDevice() == null) {
            String string = ClassicI18n.i18n.getLabel("InstrumentWizardPage.additionalInstructions");
            this.setAdditionalInstructions(string);
        } else {
            this.setAdditionalInstructions("");
        }
    }

    @Override
    public boolean mayGoToNext() {
        NewChannelWizardModel newChannelWizardModel = (NewChannelWizardModel)this.getWizardModel();
        if (newChannelWizardModel.getSelectedAudioDevice() == null && this.getSelectedFile().length() > 0) {
            String string = ClassicI18n.i18n.getError("InstrumentWizardPage.selectAODevice!");
            HF.showErrorMessage(string, (Component)this.getWizardDialog());
            return false;
        }
        return true;
    }

    public String getSelectedFile() {
        return this.tfFilename.getText();
    }

    public int getInstrumentIndex() {
        return Integer.parseInt(this.spinnerIndex.getValue().toString());
    }

    private void onBrowse() {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            String string = jFileChooser.getSelectedFile().getPath();
            if (File.separatorChar == '\\') {
                string = string.replace('\\', '/');
            }
            this.tfFilename.setText(Parser.toEscapedString(string));
        }
    }
}

