/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.osmand.IProgress;
import net.osmand.PlatformUtil;
import net.osmand.plus.download.DownloadActivityType;
import net.osmand.plus.download.DownloadFileHelper;
import net.osmand.plus.download.DownloadOsmandIndexesHelper;
import net.osmand.plus.download.DownloadResources;
import net.osmand.plus.download.IndexItem;
import net.osmand.plus.resources.ResourceManager;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.actions.OffRoadAction;
import org.apache.commons.logging.Log;

public class DownloadAction
extends OffRoadAction {
    public static final int MAX_NUMBER_OF_FILES = 10;
    public static final MessageFormat formatGb = new MessageFormat("{0, number,#.##} GB", Locale.US);
    public static final MessageFormat formatMb = new MessageFormat("{0, number,##.#} MB", Locale.US);
    private JTextField mTextField;
    private DownloadTableModel mSourceModel;
    private JTable mTable;
    private KeyAdapter mKeyListener;
    private MouseAdapter mMouseListener;
    private TableRowSorter<DownloadTableModel> mSorter;
    private JLabel mProgressStatus;
    private JProgressBar mProgressBar;
    private String mInitialFilter;
    private static final Log log = PlatformUtil.getLog(DownloadAction.class);
    private DownloadResources mDownloadResources;
    private Thread mDownloadThread;
    private boolean mIsDownloadInterrupted;
    private JButton mInterruptDownload;
    private JButton mDownloadButton;

    public DownloadAction(OsmWindow pContext) {
        this(pContext, null);
    }

    public DownloadAction(OsmWindow pContext, String pInitialFilter) {
        super(pContext);
        this.mInitialFilter = pInitialFilter;
    }

    public DownloadStatus getDownloadStatus(IndexItem pItem) {
        String fileName = pItem.getTargetFileName();
        ResourceManager rm = this.mContext.getResourceManager();
        Map<String, String> indexFileNames = rm.getIndexFileNames();
        if (indexFileNames.containsKey(fileName)) {
            String localDate = indexFileNames.get(fileName);
            String remoteDate = pItem.getDate(DateFormat.getDateInstance());
            if (localDate != null && localDate.equals(remoteDate)) {
                return DownloadStatus.DOWNLOADED;
            }
            return DownloadStatus.UPDATEABLE;
        }
        return DownloadStatus.NOTPRESENT;
    }

    @Override
    public void actionPerformed(ActionEvent pE) {
        this.createDialog();
        this.setWaitingCursor();
        this.mDialog.setTitle(this.getResourceString("offroad.download"));
        Container contentPane = this.mDialog.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        gbl.columnWeights = new double[]{1.0};
        gbl.rowWeights = new double[]{1.0};
        contentPane.setLayout(gbl);
        int y = 0;
        contentPane.add((Component)new JLabel(this.getResourceString("filter")), new GridBagConstraints(0, y, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.mTextField = new JTextField();
        contentPane.add((Component)this.mTextField, new GridBagConstraints(1, y++, 1, 1, 4.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mTable = new JTable();
        this.mTable.setRowHeight(UIManager.getFont("Table.font").getSize());
        this.mSourceModel = new DownloadTableModel();
        this.mTable.setModel(this.mSourceModel);
        this.mTable.setSelectionMode(2);
        this.mSorter = new TableRowSorter<DownloadTableModel>(this.mSourceModel);
        this.mTable.setRowSorter(this.mSorter);
        this.mTextField.getDocument().addDocumentListener(new FilterTextDocumentListener());
        this.mTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent pE) {
                if (pE.getKeyCode() == 40) {
                    pE.consume();
                    DownloadAction.this.mTable.requestFocus();
                    DownloadAction.this.selectFirstElementIfNecessary();
                }
            }
        });
        this.mKeyListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent pE) {
                if (pE.getKeyCode() == 10) {
                    pE.consume();
                    DownloadAction.this.doDownload();
                }
                if (pE.getKeyCode() == 38 && DownloadAction.this.mTable.getSelectedRowCount() == 0) {
                    pE.consume();
                    DownloadAction.this.requestFocusToTextField();
                }
                super.keyTyped(pE);
            }
        };
        this.mTable.addKeyListener(this.mKeyListener);
        this.mMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() >= 2) {
                    evt.consume();
                    DownloadAction.this.doDownload();
                }
            }
        };
        this.mTable.addMouseListener(this.mMouseListener);
        contentPane.add((Component)new JScrollPane(this.mTable), new GridBagConstraints(0, y++, 2, 1, 1.0, 4.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mProgressStatus = new JLabel("!");
        contentPane.add((Component)this.mProgressStatus, new GridBagConstraints(0, y, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mProgressBar = new JProgressBar();
        this.mProgressBar.setStringPainted(true);
        contentPane.add((Component)this.mProgressBar, new GridBagConstraints(1, y++, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mDownloadButton = new JButton(this.getResourceString("offroad.downloadButton"));
        this.mDownloadButton.addActionListener(e -> this.doDownload());
        this.mDownloadButton.setEnabled(false);
        this.mTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent pE) {
                DownloadAction.this.mDownloadButton.setEnabled(DownloadAction.this.mTable.getSelectedRowCount() > 0 && DownloadAction.this.mTable.getSelectedRowCount() <= 10);
            }
        });
        contentPane.add((Component)this.mDownloadButton, new GridBagConstraints(0, y, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.mInterruptDownload = new JButton(this.getResourceString("offroad.interruptDownload"));
        this.mInterruptDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                DownloadAction.this.mIsDownloadInterrupted = true;
            }
        });
        this.mInterruptDownload.setEnabled(false);
        contentPane.add((Component)this.mInterruptDownload, new GridBagConstraints(1, y++, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        DownloadOsmandIndexesHelper.IndexFileList indexesList = DownloadOsmandIndexesHelper.getIndexesList(this.mContext);
        this.mDownloadResources = new DownloadResources(this.mContext);
        this.mDownloadResources.updateLoadedFiles();
        for (IndexItem item : indexesList.getIndexFiles()) {
            if (item.getType() != DownloadActivityType.NORMAL_FILE && item.getType() != DownloadActivityType.ROADS_FILE && item.getType() != DownloadActivityType.WIKIPEDIA_FILE && item.getType() != DownloadActivityType.SRTM_COUNTRY_FILE) continue;
            this.mSourceModel.addRow(item);
        }
        if (this.mInitialFilter != null) {
            this.mTextField.setText(this.mInitialFilter);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    if (DownloadAction.this.mTable.getRowCount() > 0) {
                        DownloadAction.this.mTable.setRowSelectionInterval(0, 0);
                    }
                }
            }, 1000L);
        }
        this.mDialog.pack();
        this.decorateDialog();
        this.removeWaitingCursor();
        this.mDialog.setVisible(true);
    }

    public void download(final List<IndexItem> pList) {
        if (this.mDownloadThread != null && this.mDownloadThread.isAlive()) {
            JOptionPane.showMessageDialog(this.mDialog, this.getResourceString("offroad.downloadAlreadyStarted"), this.getResourceString("offroad.downloadAlreadyStartedTitle"), 0);
            return;
        }
        if (pList.size() > 10) {
            JOptionPane.showMessageDialog(this.mDialog, this.getResourceString("offroad.downloadTooManyFiles"), this.getResourceString("offroad.downloadTooManyFilesTitle"), 0);
            return;
        }
        this.mIsDownloadInterrupted = false;
        this.mInterruptDownload.setEnabled(true);
        final DownloadFileHelper helper = new DownloadFileHelper(this.mContext);
        final Vector toReIndex = new Vector();
        this.mDownloadThread = new Thread(new Runnable(){

            @Override
            public void run() {
                for (IndexItem item : pList) {
                    System.out.println("Starting download for " + item);
                    IProgress progress = new IProgress(){

                        @Override
                        public void startTask(final String pTaskName, final int pWork) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    DownloadAction.this.mProgressStatus.setText(pTaskName);
                                    DownloadAction.this.mProgressBar.setMaximum(pWork);
                                }
                            });
                        }

                        @Override
                        public void startWork(int pWork) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    DownloadAction.this.mProgressBar.setValue(0);
                                }
                            });
                        }

                        @Override
                        public void progress(int pDeltaWork) {
                        }

                        @Override
                        public void remaining(final int pRemainingWork) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    DownloadAction.this.mProgressBar.setValue(DownloadAction.this.mProgressBar.getMaximum() - pRemainingWork);
                                }
                            });
                        }

                        @Override
                        public void finishTask() {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    DownloadAction.this.mProgressBar.setValue(DownloadAction.this.mProgressBar.getMaximum());
                                    if (DownloadAction.this.mIsDownloadInterrupted) {
                                        DownloadAction.this.mProgressStatus.setText(DownloadAction.this.getResourceString("offroad.downloadInterrupted"));
                                    } else {
                                        DownloadAction.this.mProgressStatus.setText(DownloadAction.this.getResourceString("offroad.downloadDone"));
                                    }
                                }
                            });
                        }

                        @Override
                        public boolean isIndeterminate() {
                            return false;
                        }

                        @Override
                        public boolean isInterrupted() {
                            return DownloadAction.this.mIsDownloadInterrupted;
                        }
                    };
                    try {
                        helper.downloadFile(item.createDownloadEntry(DownloadAction.this.mContext), progress, toReIndex, new DownloadFileHelper.DownloadFileShowWarning(){

                            @Override
                            public void showWarning(String pWarning) {
                                System.err.println("DOWNLOAD WARNING: " + pWarning);
                            }
                        }, false);
                        final String result = DownloadAction.this.reindexFiles(toReIndex);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DownloadAction.this.mProgressStatus.setText(result);
                            }
                        });
                        DownloadAction.this.mDownloadResources.updateLoadedFiles();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DownloadAction.this.mInterruptDownload.setEnabled(false);
                    }
                });
            }
        });
        this.mDownloadThread.start();
    }

    private String reindexFiles(List<File> filesToReindex) {
        List<String> wns;
        boolean vectorMapsToReindex = false;
        ResourceManager manager = this.mContext.getResourceManager();
        for (File f : filesToReindex) {
            if (!f.getName().endsWith(".obf")) continue;
            vectorMapsToReindex = true;
        }
        List<Object> warnings = new ArrayList();
        manager.indexVoiceFiles(IProgress.EMPTY_PROGRESS);
        if (vectorMapsToReindex) {
            warnings = manager.indexingMaps(IProgress.EMPTY_PROGRESS);
        }
        if ((wns = manager.indexAdditionalMaps(IProgress.EMPTY_PROGRESS)) != null) {
            warnings.addAll(wns);
        }
        if (!warnings.isEmpty()) {
            return (String)warnings.get(0);
        }
        return null;
    }

    public void selectFirstElementIfNecessary() {
        if (this.mTable.getSelectedRowCount() == 0 && this.mTable.getRowCount() > 0) {
            this.mTable.setRowSelectionInterval(0, 0);
        }
    }

    public void requestFocusToTextField() {
        this.mTextField.selectAll();
        this.mTextField.requestFocus();
    }

    public void doDownload() {
        this.download(this.mSourceModel.getSelectedRows());
    }

    private final class FilterTextDocumentListener
    implements DocumentListener {
        private static final int TYPE_DELAY_TIME = 500;
        private Timer mTypeDelayTimer = null;

        private synchronized void change(DocumentEvent event) {
            if (this.mTypeDelayTimer != null) {
                this.mTypeDelayTimer.cancel();
                this.mTypeDelayTimer = null;
            }
            this.mTypeDelayTimer = new Timer();
            this.mTypeDelayTimer.schedule((TimerTask)new DelayedTextEntry(event), 500L);
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            this.change(event);
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            this.change(event);
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            this.change(event);
        }

        protected class DelayedTextEntry
        extends TimerTask {
            private final DocumentEvent event;

            DelayedTextEntry(DocumentEvent event) {
                this.event = event;
            }

            private String getText(Document document) throws BadLocationException {
                String text = document.getText(0, document.getLength());
                return text;
            }

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            List<IndexItem> selectedValuesList = DownloadAction.this.mSourceModel.getSelectedRows();
                            Document document = DelayedTextEntry.this.event.getDocument();
                            String text = DelayedTextEntry.this.getText(document);
                            RowFilter rf = null;
                            try {
                                rf = RowFilter.regexFilter("(?i)" + text, 1);
                            }
                            catch (PatternSyntaxException e) {
                                return;
                            }
                            DownloadAction.this.mSorter.setRowFilter(rf);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
            }
        }
    }

    public class DownloadTableModel
    extends AbstractTableModel {
        private Vector<DownloadTableColumn> mColumns = new Vector();
        private Vector<IndexItem> mRows = new Vector();

        public DownloadTableModel() {
            this.mColumns.addElement(new DownloadTableColumn("offroad.download_present", DownloadStatus.class, item -> DownloadAction.this.getDownloadStatus(item), new DownloadedTableCellRenderer()));
            this.mColumns.addElement(new DownloadTableColumn("offroad.download_name", String.class, item -> item.getBasename(), new DefaultTableCellRenderer()));
            this.mColumns.addElement(new DownloadTableColumn("offroad.download_type", DownloadActivityType.class, item -> item.getType(), new TypeTableCellRenderer()));
            this.mColumns.addElement(new DownloadTableColumn("offroad.download_size", Double.class, item -> item.getArchiveSizeMB(), new ArchiveSizeTableCellRenderer()));
            this.mColumns.addElement(new DownloadTableColumn("offroad.download_remotedate", Long.class, item -> item.getTimestamp(), new RemoteDateTableCellRenderer()));
            for (DownloadTableColumn column : this.mColumns) {
                DownloadAction.this.mTable.setDefaultRenderer(column.mClass, column.mRenderer);
            }
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.mColumns.get((int)columnIndex).mClass;
        }

        @Override
        public String getColumnName(int pColumn) {
            return DownloadAction.this.getResourceString(this.mColumns.get((int)pColumn).mName);
        }

        public void addRow(IndexItem pItem) {
            this.mRows.add(pItem);
        }

        public IndexItem getItemAt(int pJ) {
            return this.mRows.get(pJ);
        }

        @Override
        public int getRowCount() {
            return this.mRows.size();
        }

        @Override
        public int getColumnCount() {
            return this.mColumns.size();
        }

        @Override
        public Object getValueAt(int pRowIndex, int pColumnIndex) {
            DownloadTableColumn column = this.mColumns.get(pColumnIndex);
            return column.mMapping.get(this.getItemAt(pRowIndex));
        }

        public List<IndexItem> getSelectedRows() {
            int[] selectedRows = DownloadAction.this.mTable.getSelectedRows();
            Vector<IndexItem> res = new Vector<IndexItem>();
            for (int i = 0; i < selectedRows.length; ++i) {
                int j = DownloadAction.this.mTable.convertRowIndexToModel(selectedRows[i]);
                res.add(this.getItemAt(j));
            }
            return res;
        }
    }

    public static class DownloadTableColumn {
        private IndexItemToColumn mMapping;
        String mName;
        Class mClass;
        private TableCellRenderer mRenderer;

        public DownloadTableColumn(String pName, Class pClass, IndexItemToColumn pMapping, TableCellRenderer pRenderer) {
            this.mName = pName;
            this.mClass = pClass;
            this.mMapping = pMapping;
            this.mRenderer = pRenderer;
        }
    }

    static interface IndexItemToColumn {
        public Object get(IndexItem var1);
    }

    public class DownloadedTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof DownloadStatus) {
                DownloadStatus d = (DownloadStatus)((Object)value);
                this.setText(d == DownloadStatus.NOTPRESENT ? "" : DownloadAction.this.getResourceString("offroad.download_" + d.name()));
            }
            return this;
        }
    }

    static enum DownloadStatus {
        DOWNLOADED,
        UPDATEABLE,
        NOTPRESENT;

    }

    public class RemoteDateTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Long) {
                Long d = (Long)value;
                this.setText(DateFormat.getDateTimeInstance().format(new Date(d)));
            }
            return this;
        }
    }

    public class ArchiveSizeTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Double) {
                Double d = (Double)value;
                this.setText(formatMb.format(new Object[]{(double)d}));
            }
            return this;
        }
    }

    public class TypeTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof DownloadActivityType) {
                DownloadActivityType dat = (DownloadActivityType)value;
                this.setText(dat.getString(DownloadAction.this.mContext));
            }
            return this;
        }
    }
}

