/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.helpers;

import java.lang.reflect.Field;
import net.osmand.PlatformUtil;
import net.osmand.map.OsmandRegions;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.R;
import org.apache.commons.logging.Log;

public class FileNameTranslationHelper {
    private static final Log LOG = PlatformUtil.getLog(FileNameTranslationHelper.class);
    public static final String WIKI_NAME = "_wiki";
    public static final String HILL_SHADE = "Hillshade_";

    public static String getFileName(OsmWindow ctx, OsmandRegions regions, String fileName) {
        String lc;
        String std;
        String basename = FileNameTranslationHelper.getBasename(fileName);
        if (basename.endsWith(WIKI_NAME)) {
            return FileNameTranslationHelper.getWikiName(ctx, basename);
        }
        if (fileName.endsWith("tts")) {
            return FileNameTranslationHelper.getVoiceName(ctx, fileName);
        }
        if (fileName.startsWith(HILL_SHADE)) {
            return FileNameTranslationHelper.getHillShadeName(ctx, regions, basename);
        }
        if (fileName.length() == 2) {
            try {
                Field f = R.string.class.getField("lang_" + fileName);
                if (f != null) {
                    Integer in = (Integer)f.get(null);
                    return ctx.getString(in);
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        if ((std = FileNameTranslationHelper.getStandardMapName(ctx, lc = basename.toLowerCase())) != null) {
            return std;
        }
        if (regions != null) {
            return regions.getLocaleName(basename, true);
        }
        return null;
    }

    public static String getHillShadeName(OsmWindow ctx, OsmandRegions regions, String basename) {
        String hillsh = ctx.getString(128) + " ";
        String locName = regions.getLocaleName(basename.trim(), true);
        return hillsh + locName;
    }

    public static String getWikiName(OsmWindow ctx, String basename) {
        String wikiWord;
        int index;
        String cutted = basename.substring(0, basename.indexOf(WIKI_NAME));
        String wikiName = FileNameTranslationHelper.getStandardLangName(ctx, cutted);
        if (wikiName == null) {
            wikiName = cutted;
        }
        if ((index = (wikiWord = ctx.getString(329)).indexOf("(")) >= 0) {
            return wikiName + " " + wikiWord.substring(0, index).trim();
        }
        return wikiName + " " + ctx.getString(329);
    }

    public static String getVoiceName(OsmWindow ctx, String basename) {
        try {
            Field f;
            String nm = basename.replace('-', '_').replace(' ', '_');
            if (nm.endsWith("_tts") || nm.endsWith("-tts")) {
                nm = nm.substring(0, nm.length() - 4);
            }
            if ((f = R.string.class.getField("lang_" + nm)) != null) {
                Integer in = (Integer)f.get(null);
                return ctx.getString(in);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return basename;
    }

    private static String getBasename(String fileName) {
        if (fileName.endsWith(".extra.zip")) {
            return fileName.substring(0, fileName.length() - ".extra.zip".length());
        }
        if (fileName.endsWith(".sqlitedb")) {
            return fileName.substring(0, fileName.length() - ".sqlitedb".length()).replace('_', ' ');
        }
        int ls = fileName.lastIndexOf("-roads");
        if (ls >= 0) {
            return fileName.substring(0, ls);
        }
        ls = fileName.indexOf(".");
        if (ls >= 0) {
            return fileName.substring(0, ls);
        }
        return fileName;
    }

    private static String getStandardLangName(OsmWindow ctx, String filename) {
        if (filename.equalsIgnoreCase("Croatian")) {
            return ctx.getString(1369);
        }
        if (filename.equalsIgnoreCase("Chinese")) {
            return ctx.getString(1397);
        }
        if (filename.equalsIgnoreCase("Portuguese")) {
            return ctx.getString(1385);
        }
        if (filename.equalsIgnoreCase("English")) {
            return ctx.getString(1361);
        }
        if (filename.equalsIgnoreCase("Afrikaans") || filename.equalsIgnoreCase("Africaans")) {
            return ctx.getString(1349);
        }
        if (filename.equalsIgnoreCase("Armenian")) {
            return ctx.getString(1371);
        }
        if (filename.equalsIgnoreCase("Basque")) {
            return ctx.getString(1363);
        }
        if (filename.equalsIgnoreCase("Belarusian")) {
            return ctx.getString(1352);
        }
        if (filename.equalsIgnoreCase("Bosnian")) {
            return ctx.getString(1354);
        }
        if (filename.equalsIgnoreCase("Bulgarian")) {
            return ctx.getString(1353);
        }
        if (filename.equalsIgnoreCase("Catalan")) {
            return ctx.getString(1355);
        }
        if (filename.equalsIgnoreCase("Czech")) {
            return ctx.getString(1356);
        }
        if (filename.equalsIgnoreCase("Danish")) {
            return ctx.getString(1358);
        }
        if (filename.equalsIgnoreCase("Dutch")) {
            return ctx.getString(1381);
        }
        if (filename.equalsIgnoreCase("Finnish")) {
            return ctx.getString(1365);
        }
        if (filename.equalsIgnoreCase("French")) {
            return ctx.getString(1366);
        }
        if (filename.equalsIgnoreCase("Georgian")) {
            return ctx.getString(1376);
        }
        if (filename.equalsIgnoreCase("German")) {
            return ctx.getString(1359);
        }
        if (filename.equalsIgnoreCase("Greek")) {
            return ctx.getString(1360);
        }
        if (filename.equalsIgnoreCase("Hebrew")) {
            return ctx.getString(1374);
        }
        if (filename.equalsIgnoreCase("Hindi")) {
            return ctx.getString(1368);
        }
        if (filename.equalsIgnoreCase("Hungarian")) {
            return ctx.getString(1370);
        }
        if (filename.equalsIgnoreCase("Indonesian")) {
            return ctx.getString(1372);
        }
        if (filename.equalsIgnoreCase("Italian")) {
            return ctx.getString(1373);
        }
        if (filename.equalsIgnoreCase("Japanese")) {
            return ctx.getString(1375);
        }
        if (filename.equalsIgnoreCase("Korean")) {
            return ctx.getString(1377);
        }
        if (filename.equalsIgnoreCase("Latvian")) {
            return ctx.getString(1379);
        }
        if (filename.equalsIgnoreCase("Lithuanian")) {
            return ctx.getString(1378);
        }
        if (filename.equalsIgnoreCase("Marathi")) {
            return ctx.getString(1380);
        }
        if (filename.equalsIgnoreCase("Norwegian")) {
            return ctx.getString(1382);
        }
        if (filename.equalsIgnoreCase("Polish")) {
            return ctx.getString(1383);
        }
        if (filename.equalsIgnoreCase("Portuguese")) {
            return ctx.getString(1384);
        }
        if (filename.equalsIgnoreCase("Romanian")) {
            return ctx.getString(1386);
        }
        if (filename.equalsIgnoreCase("Russian")) {
            return ctx.getString(1387);
        }
        if (filename.equalsIgnoreCase("Slovak")) {
            return ctx.getString(1389);
        }
        if (filename.equalsIgnoreCase("Slovenian")) {
            return ctx.getString(1390);
        }
        if (filename.equalsIgnoreCase("Spanish")) {
            return ctx.getString(1362);
        }
        if (filename.equalsIgnoreCase("Swedish")) {
            return ctx.getString(1392);
        }
        if (filename.equalsIgnoreCase("Turkish")) {
            return ctx.getString(1394);
        }
        if (filename.equalsIgnoreCase("Ukrainian")) {
            return ctx.getString(1395);
        }
        if (filename.equalsIgnoreCase("Vietnamese")) {
            return ctx.getString(1396);
        }
        if (filename.equalsIgnoreCase("Welsh")) {
            return ctx.getString(1357);
        }
        return null;
    }

    public static String getStandardMapName(OsmWindow ctx, String basename) {
        if (basename.equals("world-ski")) {
            return ctx.getString(325);
        }
        if (basename.equals("world_altitude_correction_ww15mgh")) {
            return ctx.getString(321);
        }
        if (basename.equals("world_basemap")) {
            return ctx.getString(324);
        }
        if (basename.equals("world_bitcoin_payments")) {
            return ctx.getString(323);
        }
        if (basename.equals("world_seamarks_basemap")) {
            return ctx.getString(322);
        }
        return null;
    }
}

