/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.marshal;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Error;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.encoding.MarshalEncoding;
import org.jruby.runtime.marshal.CoreObjectType;
import org.jruby.runtime.marshal.DataType;
import org.jruby.runtime.marshal.MarshalCache;
import org.jruby.util.ByteList;
import org.jruby.util.RubyStringBuilder;

@Deprecated(since="10.0.0.0", forRemoval=true)
public class MarshalStream
extends FilterOutputStream {
    private final Ruby runtime;
    private final MarshalCache cache;
    private final int depthLimit;
    private int depth = 0;

    public MarshalStream(Ruby runtime2, OutputStream out, int depthLimit) throws IOException {
        super(out);
        this.runtime = runtime2;
        this.depthLimit = depthLimit >= 0 ? depthLimit : Integer.MAX_VALUE;
        this.cache = new MarshalCache();
        out.write(4);
        out.write(8);
    }

    public void dumpObject(IRubyObject value2) throws IOException {
        ++this.depth;
        if (this.depth > this.depthLimit) {
            throw this.runtime.newArgumentError("exceed depth limit");
        }
        this.writeAndRegister(value2);
        --this.depth;
        if (this.depth == 0) {
            this.out.flush();
        }
    }

    @Deprecated(since="10.0.0.0")
    public void registerLinkTarget(IRubyObject newObject2) {
        this.registerLinkTarget(((RubyBasicObject)newObject2).getCurrentContext(), newObject2);
    }

    public void registerLinkTarget(ThreadContext context, IRubyObject newObject2) {
        if (MarshalStream.shouldBeRegistered(context, newObject2)) {
            this.cache.register(newObject2);
        }
    }

    public void registerSymbol(ByteList sym) {
        this.cache.registerSymbol(sym);
    }

    static boolean shouldBeRegistered(ThreadContext context, IRubyObject value2) {
        if (value2.isNil()) {
            return false;
        }
        if (value2 instanceof RubyBoolean) {
            return false;
        }
        if (value2 instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)value2;
            return !MarshalStream.isMarshalFixnum(context, fixnum);
        }
        return true;
    }

    private static boolean isMarshalFixnum(ThreadContext context, RubyFixnum fixnum) {
        long value2 = fixnum.getValue();
        return value2 <= 0x3FFFFFFFL && value2 >= -1073741824L;
    }

    private void writeAndRegisterSymbol(ByteList sym) throws IOException {
        if (this.cache.isSymbolRegistered(sym)) {
            this.cache.writeSymbolLink(this, sym);
        } else {
            this.registerSymbol(sym);
            this.dumpSymbol(sym);
        }
    }

    private void writeAndRegister(IRubyObject value2) throws IOException {
        if (!(value2 instanceof RubySymbol) && this.cache.isRegistered(value2)) {
            this.cache.writeLink(this, value2);
        } else {
            value2.getMetaClass().smartDump(this, value2);
        }
    }

    private List<Variable<Object>> getVariables(IRubyObject value2) throws IOException {
        ClassIndex nativeClassIndex;
        List<Variable<Object>> variables = null;
        if (value2 instanceof CoreObjectType && (nativeClassIndex = ((CoreObjectType)((Object)value2)).getNativeClassIndex()) != ClassIndex.OBJECT && nativeClassIndex != ClassIndex.BASICOBJECT) {
            RubyClass type2;
            if (MarshalStream.shouldMarshalEncoding(value2) || !value2.isImmediate() && value2.hasVariables() && nativeClassIndex != ClassIndex.CLASS && nativeClassIndex != ClassIndex.MODULE) {
                variables = value2.getMarshalVariableList();
                if (!variables.isEmpty() || MarshalStream.shouldMarshalEncoding(value2)) {
                    this.write(73);
                } else {
                    variables = null;
                }
            }
            RubyClass meta = RubyBasicObject.getMetaClass(value2);
            switch (nativeClassIndex) {
                case STRING: 
                case REGEXP: 
                case ARRAY: 
                case HASH: {
                    RubyClass rubyClass = this.dumpExtended(meta);
                    break;
                }
                default: {
                    RubyClass rubyClass = type2 = meta;
                }
            }
            if (nativeClassIndex != meta.getClassIndex() && nativeClassIndex != ClassIndex.STRUCT && nativeClassIndex != ClassIndex.FIXNUM && nativeClassIndex != ClassIndex.BIGNUM) {
                this.writeUserClass(value2, type2);
            }
        }
        return variables;
    }

    private static boolean shouldMarshalEncoding(IRubyObject value2) {
        if (!(value2 instanceof MarshalEncoding)) {
            return false;
        }
        return ((MarshalEncoding)((Object)value2)).shouldMarshalEncoding();
    }

    @Deprecated(since="10.0.0.0")
    public void writeDirectly(IRubyObject value2) throws IOException {
        this.writeDirectly(value2.getRuntime().getCurrentContext(), value2);
    }

    public void writeDirectly(ThreadContext context, IRubyObject value2) throws IOException {
        List<Variable<Object>> variables = this.getVariables(value2);
        this.writeObjectData(context, value2);
        if (variables != null) {
            this.dumpVariablesWithEncoding(variables, value2);
        }
    }

    public static String getPathFromClass(RubyModule clazz) {
        ThreadContext context = clazz.getRuntime().getCurrentContext();
        RubyString path2 = clazz.rubyName(context);
        if (path2.charAt(0) == '#') {
            String type2 = clazz.isClass() ? "class" : "module";
            throw Error.typeError(context, RubyStringBuilder.str(context.runtime, "can't dump anonymous " + type2 + " ", RubyStringBuilder.types(context.runtime, clazz)));
        }
        RubyModule real2 = clazz.isModule() ? clazz : ((RubyClass)clazz).getRealClass();
        Ruby runtime2 = clazz.getRuntime();
        if (runtime2.getClassFromPath(path2.asJavaString()) != real2) {
            throw Error.typeError(context, RubyStringBuilder.str(context.runtime, RubyStringBuilder.types(context.runtime, clazz), " can't be referred"));
        }
        return path2.asJavaString();
    }

    private void writeObjectData(ThreadContext context, IRubyObject value2) throws IOException {
        if (value2 instanceof CoreObjectType) {
            if (value2 instanceof DataType) {
                throw Error.typeError(context, RubyStringBuilder.str(context.runtime, "no _dump_data is defined for class ", RubyStringBuilder.types(context.runtime, (RubyModule)RubyBasicObject.getMetaClass(value2))));
            }
            ClassIndex nativeClassIndex = ((CoreObjectType)((Object)value2)).getNativeClassIndex();
            switch (nativeClassIndex) {
                case ARRAY: {
                    this.write(91);
                    RubyArray.marshalTo(context, (RubyArray)value2, this);
                    return;
                }
                case FALSE: {
                    this.write(70);
                    return;
                }
                case FIXNUM: {
                    RubyFixnum fixnum = (RubyFixnum)value2;
                    if (MarshalStream.isMarshalFixnum(context, fixnum)) {
                        this.write(105);
                        this.writeInt(fixnum.asInt(context));
                        return;
                    }
                    value2 = RubyBignum.newBignum(context.runtime, fixnum.getValue());
                }
                case BIGNUM: {
                    this.write(108);
                    RubyBignum.marshalTo((RubyBignum)value2, this);
                    return;
                }
                case CLASS: {
                    if (((RubyClass)value2).isSingleton()) {
                        throw Error.typeError(context, "singleton class can't be dumped");
                    }
                    this.write(99);
                    RubyClass.marshalTo((RubyClass)value2, this);
                    return;
                }
                case FLOAT: {
                    this.write(102);
                    RubyFloat.marshalTo((RubyFloat)value2, this);
                    return;
                }
                case HASH: {
                    RubyHash hash2 = (RubyHash)value2;
                    if (hash2.getIfNone() == RubyBasicObject.UNDEF) {
                        this.write(123);
                    } else {
                        if (hash2.hasDefaultProc()) {
                            throw Error.typeError(context, "can't dump hash with default proc");
                        }
                        this.write(125);
                    }
                    RubyHash.marshalTo(hash2, this);
                    return;
                }
                case MODULE: {
                    this.write(109);
                    RubyModule.marshalTo((RubyModule)value2, this);
                    return;
                }
                case NIL: {
                    this.write(48);
                    return;
                }
                case OBJECT: 
                case BASICOBJECT: {
                    RubyClass type2 = RubyBasicObject.getMetaClass(value2);
                    this.dumpDefaultObjectHeader(context, type2);
                    type2.getRealClass().marshal(value2, this);
                    return;
                }
                case REGEXP: {
                    this.write(47);
                    RubyRegexp.marshalTo((RubyRegexp)value2, this);
                    return;
                }
                case STRING: {
                    this.registerLinkTarget(context, value2);
                    this.write(34);
                    this.writeString(value2.convertToString().getByteList());
                    return;
                }
                case STRUCT: {
                    RubyStruct.marshalTo((RubyStruct)value2, this);
                    return;
                }
                case SYMBOL: {
                    this.writeAndRegisterSymbol(((RubySymbol)value2).getBytes());
                    return;
                }
                case TRUE: {
                    this.write(84);
                    return;
                }
            }
            throw Error.typeError(context, RubyStringBuilder.str(context.runtime, "can't dump ", RubyStringBuilder.types(context.runtime, (RubyModule)value2.getMetaClass())));
        }
        RubyClass metaClass = value2.getMetaClass();
        this.dumpDefaultObjectHeader(context, metaClass);
        metaClass.getRealClass().marshal(value2, this);
    }

    @Deprecated(since="10.0.0.0")
    public void userNewMarshal(IRubyObject value2, CacheEntry entry) throws IOException {
        this.userNewMarshal(((RubyBasicObject)value2).getCurrentContext(), value2, entry);
    }

    public void userNewMarshal(ThreadContext context, IRubyObject value2, CacheEntry entry) throws IOException {
        this.userNewCommon(context, value2, entry);
    }

    @Deprecated(since="10.0.0.0")
    public void userNewMarshal(IRubyObject value2) throws IOException {
        this.userNewMarshal(((RubyBasicObject)value2).getCurrentContext(), value2);
    }

    public void userNewMarshal(ThreadContext context, IRubyObject value2) throws IOException {
        this.userNewCommon(context, value2, null);
    }

    private void userNewCommon(ThreadContext context, IRubyObject value2, CacheEntry entry) throws IOException {
        this.registerLinkTarget(context, value2);
        this.write(85);
        RubyClass klass = RubyBasicObject.getMetaClass(value2);
        this.writeAndRegisterSymbol(Convert.asSymbol(context, klass.getRealClass().getName(context)).getBytes());
        IRubyObject marshaled = entry != null ? entry.method.call(this.runtime.getCurrentContext(), value2, entry.sourceModule, "marshal_dump") : value2.callMethod(this.runtime.getCurrentContext(), "marshal_dump");
        if (marshaled.getMetaClass() == klass) {
            throw this.runtime.newRuntimeError("marshal_dump returned same class instance");
        }
        this.dumpObject(marshaled);
    }

    @Deprecated(since="10.0.0.0")
    public void userMarshal(IRubyObject value2, CacheEntry entry) throws IOException {
        this.userMarshal(((RubyBasicObject)value2).getCurrentContext(), value2, entry);
    }

    public void userMarshal(ThreadContext context, IRubyObject value2, CacheEntry entry) throws IOException {
        this.userCommon(context, value2, entry);
    }

    @Deprecated(since="10.0.0.0")
    public void userMarshal(IRubyObject value2) throws IOException {
        this.userMarshal(((RubyBasicObject)value2).getCurrentContext(), value2);
    }

    public void userMarshal(ThreadContext context, IRubyObject value2) throws IOException {
        this.userCommon(context, value2, null);
    }

    private void userCommon(ThreadContext context, IRubyObject value2, CacheEntry entry) throws IOException {
        RubyFixnum depthLimitFixnum = Convert.asFixnum(context, this.depthLimit);
        RubyClass klass = RubyBasicObject.getMetaClass(value2);
        IRubyObject dumpResult = entry != null ? entry.method.call(context, value2, entry.sourceModule, "_dump", depthLimitFixnum) : value2.callMethod(context, "_dump", depthLimitFixnum);
        RubyString marshaled = Convert.castAsString(context, dumpResult);
        List<Variable<Object>> variables = null;
        if (marshaled.hasVariables()) {
            variables = marshaled.getMarshalVariableList();
            if (!variables.isEmpty()) {
                this.write(73);
            } else {
                variables = null;
            }
        }
        this.write(117);
        this.writeAndRegisterSymbol(Convert.asSymbol(context, klass.getRealClass().getName(context)).getBytes());
        this.writeString(marshaled.getByteList());
        if (variables != null) {
            this.dumpVariables(variables);
        }
        this.registerLinkTarget(context, value2);
    }

    public void writeUserClass(IRubyObject obj, RubyClass type2) throws IOException {
        ThreadContext context = obj.getRuntime().getCurrentContext();
        this.write(67);
        String className = type2.getName(context);
        if (className.charAt(0) == '#') {
            throw Error.typeError(context, RubyStringBuilder.str(context.runtime, "can't dump anonymous class ", RubyStringBuilder.types(context.runtime, (RubyModule)type2)));
        }
        this.writeAndRegisterSymbol(Convert.asSymbol(context, className).getBytes());
    }

    public void dumpVariablesWithEncoding(List<Variable<Object>> vars, IRubyObject obj) throws IOException {
        if (MarshalStream.shouldMarshalEncoding(obj)) {
            this.writeInt(vars.size() + 1);
            this.writeEncoding(((MarshalEncoding)((Object)obj)).getMarshalEncoding());
        } else {
            this.writeInt(vars.size());
        }
        this.dumpVariablesShared(vars);
    }

    public void dumpVariables(List<Variable<Object>> vars) throws IOException {
        this.writeInt(vars.size());
        this.dumpVariablesShared(vars);
    }

    private void dumpVariablesShared(List<Variable<Object>> vars) throws IOException {
        for (Variable<Object> var : vars) {
            if (!(var.getValue() instanceof IRubyObject)) continue;
            this.writeAndRegisterSymbol(RubySymbol.newSymbol(this.runtime, var.getName()).getBytes());
            this.dumpObject((IRubyObject)var.getValue());
        }
    }

    public void writeEncoding(Encoding encoding2) throws IOException {
        this.writeEncoding(this.runtime.getCurrentContext(), encoding2);
    }

    public void writeEncoding(ThreadContext context, Encoding encoding2) throws IOException {
        if (encoding2 == null || encoding2 == USASCIIEncoding.INSTANCE) {
            this.writeAndRegisterSymbol(Convert.asSymbol(context, "E").getBytes());
            this.writeObjectData(context, context.fals);
        } else if (encoding2 == UTF8Encoding.INSTANCE) {
            this.writeAndRegisterSymbol(Convert.asSymbol(context, "E").getBytes());
            this.writeObjectData(context, context.tru);
        } else {
            this.writeAndRegisterSymbol(Convert.asSymbol(context, "encoding").getBytes());
            RubyString encodingString = new RubyString(context.runtime, Access.stringClass(context), encoding2.getName());
            this.writeObjectData(context, encodingString);
        }
    }

    private boolean hasSingletonMethods(RubyClass type2) {
        for (DynamicMethod method2 : type2.getMethods().values()) {
            if (!method2.isImplementedBy(type2)) continue;
            return true;
        }
        return false;
    }

    private RubyClass dumpExtended(RubyClass type2) throws IOException {
        ThreadContext context = type2.getRuntime().getCurrentContext();
        if (type2.isSingleton()) {
            if (this.hasSingletonMethods(type2) || type2.hasVariables()) {
                throw Error.typeError(context, "singleton can't be dumped");
            }
            type2 = type2.getSuperClass();
        }
        while (type2.isIncluded()) {
            this.write(101);
            this.writeAndRegisterSymbol(Convert.asSymbol(context, type2.getOrigin().getName(context)).getBytes());
            type2 = type2.getSuperClass();
        }
        return type2;
    }

    @Deprecated(since="10.0.0.0")
    public void dumpDefaultObjectHeader(RubyClass type2) throws IOException {
        this.dumpDefaultObjectHeader(this.runtime.getCurrentContext(), type2);
    }

    public void dumpDefaultObjectHeader(ThreadContext context, RubyClass type2) throws IOException {
        this.dumpDefaultObjectHeader(context, 'o', type2);
    }

    @Deprecated(since="10.0.0.0")
    public void dumpDefaultObjectHeader(char tp, RubyClass type2) throws IOException {
        this.dumpDefaultObjectHeader(type2.getRuntime().getCurrentContext(), tp, type2);
    }

    public void dumpDefaultObjectHeader(ThreadContext context, char tp, RubyClass type2) throws IOException {
        this.dumpExtended(type2);
        this.write(tp);
        this.writeAndRegisterSymbol(Convert.asSymbol(context, MarshalStream.getPathFromClass(type2.getRealClass())).getBytes());
    }

    public void writeString(String value2) throws IOException {
        this.writeInt(value2.length());
        this.out.write(RubyString.stringToBytes(value2));
    }

    public void writeString(ByteList value2) throws IOException {
        int len = value2.length();
        this.writeInt(len);
        this.out.write(value2.getUnsafeBytes(), value2.begin(), len);
    }

    public void dumpSymbol(ByteList value2) throws IOException {
        this.write(58);
        int len = value2.length();
        this.writeInt(len);
        this.out.write(value2.getUnsafeBytes(), value2.begin(), len);
    }

    public void writeInt(int value2) throws IOException {
        if (value2 == 0) {
            this.out.write(0);
        } else if (0 < value2 && value2 < 123) {
            this.out.write(value2 + 5);
        } else if (-124 < value2 && value2 < 0) {
            this.out.write(value2 - 5 & 0xFF);
        } else {
            int i2;
            byte[] buf = new byte[4];
            for (i2 = 0; i2 < buf.length; ++i2) {
                buf[i2] = (byte)(value2 & 0xFF);
                if ((value2 >>= 8) == 0 || value2 == -1) break;
            }
            int len = i2 + 1;
            this.out.write(value2 < 0 ? -len : len);
            this.out.write(buf, 0, i2 + 1);
        }
    }

    public void writeByte(int value2) throws IOException {
        this.out.write(value2);
    }

    @Deprecated(since="9.4.0.0")
    public boolean isTainted() {
        return false;
    }

    @Deprecated(since="9.0.0.0")
    public boolean isUntrusted() {
        return false;
    }
}

