# frozen_string_literal: true

require "json"
require_relative "gitlab_query_language/version"

# Load the appropriate version-specific native extension
begin
  ruby_version = /(\d+\.\d+)/.match(RUBY_VERSION)
  require_relative "gitlab_query_language/#{ruby_version}/gitlab_query_language"
rescue LoadError
  require_relative "gitlab_query_language/gitlab_query_language"
end

module Glql
  Error = Class.new(StandardError)

  class << self
    def compile(query, context)
      result_json = compile_rs(query, context.to_json)
      JSON.parse(result_json)
    end

    def transform(data, context)
      result_json = transform_rs(data.to_json, context.to_json)
      JSON.parse(result_json)
    end
  end
end
