---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token GitLab OAuth application secret'
---

## Description

The response body contains content that matches the pattern of a GitLab OAuth application secret was identified. OAuth secrets are used when allowing users to sign in to your application. Depending on the scopes assigned, a malicious actor could impersonate the service to access their repositories or data.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To regenerate an OAuth secret:

- Sign in to your GitLab account and access the [User settings](../../../../../user/profile/_index.md#access-your-user-settings) left-hand side menu, select "Applications"
- Find the application that uses the identified token and select the name link in the "Name" column - Select "Renew secret" in the application details page
- When prompted, select "Renew secret"

For more information, please see [GitLabs documentation on configuring an OAuth 2.0 provider](../../../../../integration/oauth_provider.md)

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.146 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
