---
stage: Security Risk Management
group: Security Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 脆弱性管理ポリシーのスキーマ
---

脆弱性管理ポリシーを含むYAMLファイルは、`vulnerability_management_policy`キーの下にネストされた脆弱性管理ポリシースキーマに一致するオブジェクトの配列で構成されています。

脆弱性管理ポリシーを保存すると、そのコンテンツは脆弱性管理ポリシースキーマに対して検証されます。[JSONスキーマ](https://json-schema.org/)に精通していない方は、以下のセクションと表を参照してください。

| フィールド                             | 型                                       | 必須 | 説明 |
|-----------------------------------|--------------------------------------------|----------|-------------|
| `vulnerability_management_policy` | `array`脆弱性管理ポリシー | はい     | 脆弱性管理ポリシーのリスト（最大5つ） |

## 脆弱性管理ポリシー {#vulnerability-management-policy}

| フィールド          | 型                                         | 必須 | 説明 |
|----------------|----------------------------------------------|----------|-------------|
| `name`         | `string`                                     | はい     | ポリシーの名前。最大255文字。 |
| `description`  | `string`                                     | いいえ    | ポリシーの説明。 |
| `enabled`      | `boolean`                                    | はい     | ポリシーを有効（`true`）または無効（`false`）にするフラグ。 |
| `rules`        | ルールの`array`                             | はい     | ポリシーの基準を定義するルールの一覧。 |
| `policy_scope` | [`policy_scope`](_index.md#configure-the-policy-scope)の`object` | いいえ    | 指定したプロジェクト、グループ、またはコンプライアンスフレームワークのラベルに基づいて、ポリシーのスコープを設定します。 |
| `actions`      | アクションの`array`                           | はい     | ポリシーに一致する脆弱性に対して実行されるアクション。 |

### `no_longer_detected`ルール {#no_longer_detected-rule}

このルールは、ポリシーの基準を定義します。

| フィールド | 型 | 必須 | 使用可能な値 | 説明 |
|-------|------|----------|-----------------|-------------|
| `type` | `string` | はい | `no_longer_detected` | ルールの種類。 |
| `scanners` | `array` | `true` | `sast`, `secret_detection`, `dependency_scanning`, `container_scanning`, `dast`, `coverage_fuzzing`, `api_fuzzing` | このポリシーが適用されるスキャナーを指定します。 |
| `severity_levels` | `array` | `true` | `critical`、`high`、`medium`、`low`、`info`、`unknown` | このポリシーが適用される重大度レベルを指定します。 |

### `auto_resolve`アクション {#auto_resolve-action}

このアクションは、ポリシーのルールとスコープに一致する脆弱性を解決します。

| フィールド  | 型     | 必須 | 使用可能な値 | 説明 |
|--------|----------|----------|-----------------|-------------|
| `type` | `string` | はい     | `auto_resolve`  | アクションの種類。 |
