---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: '機密のシークレットまたはトークンMailgun Webhook署名キーの公開'
---

## 説明 {#description}

応答本文には、Mailgun Webhook署名キーのパターンに一致するコンテンツが含まれていることが確認されました。このキーは、Mailgunがすべての受信Webhookメッセージペイロードに署名するために使用されます。このキーにアクセスできる悪意のある攻撃者は、偽のWebhookイベントに署名し、検証に合格して処理されるように、サービスに送信する可能性があります。この値を公開すると、攻撃者がこのトークンによって許可されたすべてのリソースにアクセスできるようになる可能性があります。

## 修正 {#remediation}

キーの漏洩に関するセキュリティインシデントの処理に関する一般的なガイダンスについては、[認証情報のインターネットへの公開](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet)に関するGitLabドキュメントを参照してください。

HTTP Webhook署名キーをローテーションするには:

- Mailgunアカウントにサインインし、<https://app.mailgun.com/>のダッシュボードにアクセスします。
- 右上側で、アカウントプロファイルを選択し、「APIセキュリティ」を選択します。
- 「HTTP Webhook署名キー」セクションで、右側のローテーション矢印アイコンを選択します。
- プロンプトが表示されたら、「HTTP Webhook署名キーのリセット」ダイアログで「リセットキー」を選択します。

詳細については、[MailgunのWebhookに関するドキュメント](https://documentation.mailgun.com/docs/mailgun/user-manual/tracking-messages/#securing-webhooks)を参照してください。

## 詳細 {#details}

| ID | 集計 | CWE | 型 | リスク |
|:---|:-----------|:----|:-----|:-----|
| 798.75 | いいえ | 798 | パッシブ | 高 |

## リンク {#links}

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
