---
stage: Analytics
group: Platform Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: 重要なアラートが適切に処理され、オンコールのレスポンダーにルーティングされるように、GitLabでエスカレーションポリシーを作成、編集、削除する方法について説明します。
title: エスカレーションポリシー
---

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

エスカレーションポリシーには、前のステップのレスポンダーが応答しなかった場合、エスカレーションポリシーのステップで自動的に次のレスポンダーを呼び出しする、時間制限付きのステップが含まれています。[オンコールスケジュール](oncall_schedules.md)を管理するGitLabプロジェクトで、エスカレーションポリシーを作成できます。

## エスカレーションポリシーを追加 {#add-an-escalation-policy}

前提要件:

- メンテナーロール以上が必要です。
- 少なくともメンテナーロールが必要です。[オンコールスケジュール](oncall_schedules.md)が必要です。

エスカレーションポリシーを作成するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 左側のサイドバーで、**モニタリング** > **エスカレーションポリシー**を選択します。
1. **エスカレーションポリシーを追加**を選択します。
1. ポリシーの名前と説明、およびプライマリレスポンダーがアラートを見逃した場合に従うエスカレーションポリシールールを入力します。
1. **エスカレーションポリシーを追加**を選択します。

![エスカレーションポリシー](img/escalation_policy_v14_1.png)

### エスカレーションポリシールールのレスポンダーを選択 {#select-the-responder-of-an-escalation-rule}

エスカレーションポリシールールを設定するときに、呼び出し先を指定できます:

- **スケジュールされているオンコールユーザーにメールを送信**：ルールがトリガーされたときにオンコール中のユーザーに通知し、指定された[オンコールスケジュール](oncall_schedules.md)のすべてのローテーションをカバーします。
- **メールユーザー**：指定されたユーザーに直接通知します。

オンコールスケジュールまたは直接メールでユーザーに通知が送信されると、呼び出しされたユーザーを一覧表示するシステムノートがアラートに作成されます。

エスカレーションポリシールールに指定された時間は、0～1440分の間である必要があります。

## エスカレーションポリシーを編集 {#edit-an-escalation-policy}

エスカレーションポリシーを更新するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 左側のサイドバーで、**モニタリング** > **エスカレーションポリシー**を選択します。
1. **エスカレーションポリシーを編集** ({{< icon name="pencil" >}})を選択します。
1. 情報を編集します。
1. **変更を保存**を選択します。

## エスカレーションポリシーを削除 {#delete-an-escalation-policy}

エスカレーションポリシーを削除するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 左側のサイドバーで、**モニタリング** > **エスカレーションポリシー**を選択します。
1. **エスカレーションポリシーを削除** ({{< icon name="remove" >}})を選択します。
1. 確認ダイアログで、**エスカレーションポリシーを削除**を選択します。
