/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceBox;

import com.zeroc.Ice.Communicator;
import com.zeroc.Ice.InitializationData;
import com.zeroc.Ice.Properties;
import com.zeroc.Ice.Util;
import com.zeroc.IceBox.ServiceManagerI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class Server {
    private static void usage() {
        System.err.println("Usage: com.zeroc.IceBox.Server [options] --Ice.Config=<file>\n");
        System.err.println("Options:\n-h, --help           Show this message.\n-v, --version        Display the Ice version.");
    }

    private static int run(Communicator communicator, List<String> argSeq) {
        String prefix = "IceBox.Service.";
        Properties properties = communicator.getProperties();
        Map<String, String> services = properties.getPropertiesForPrefix("IceBox.Service.");
        ArrayList<String> iceBoxArgs = new ArrayList<String>(argSeq);
        for (String key : services.keySet()) {
            String name = key.substring("IceBox.Service.".length());
            iceBoxArgs.removeIf(v -> v.startsWith("--" + name));
        }
        Iterator<String> iterator = iceBoxArgs.iterator();
        if (iterator.hasNext()) {
            String arg = iterator.next();
            if (arg.equals("-h") || arg.equals("--help")) {
                Server.usage();
                return 0;
            }
            if (arg.equals("-v") || arg.equals("--version")) {
                System.out.println(Util.stringVersion());
                return 0;
            }
            System.err.println("IceBox.Server: unknown option `" + arg + "'");
            Server.usage();
            return 1;
        }
        ServiceManagerI serviceManagerImpl = new ServiceManagerI(communicator, argSeq.toArray(new String[0]));
        return serviceManagerImpl.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int status = 0;
        ArrayList<String> argSeq = new ArrayList<String>();
        InitializationData initData = new InitializationData();
        initData.properties = Util.createProperties();
        initData.properties.setProperty("Ice.Admin.DelayCreation", "1");
        ShutdownHook shutdownHook = null;
        try (Communicator communicator = Util.initialize(args, initData, argSeq);){
            shutdownHook = new ShutdownHook(communicator);
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            status = Server.run(communicator, argSeq);
        }
        finally {
            if (shutdownHook != null) {
                shutdownHook.done();
            }
        }
        System.exit(status);
    }

    static class ShutdownHook
    extends Thread {
        private Communicator _communicator;
        private final Object _doneMutex = new Object();
        private boolean _done = false;

        ShutdownHook(Communicator communicator) {
            this._communicator = communicator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this._communicator.shutdown();
            Object object = this._doneMutex;
            synchronized (object) {
                while (!this._done) {
                    try {
                        this._doneMutex.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            Object object = this._doneMutex;
            synchronized (object) {
                this._done = true;
                this._doneMutex.notify();
            }
        }
    }
}

