/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.AprStatus;
import org.apache.tomcat.jni.Library;
import org.apache.tomcat.jni.LibraryNotFoundError;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public class AprLifecycleListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(AprLifecycleListener.class);
    private static final List<String> initInfoLogMessages = new ArrayList<String>(3);
    protected static final StringManager sm = StringManager.getManager(AprLifecycleListener.class);
    private static final int TCN_1_REQUIRED_MINOR = 3;
    private static final int TCN_1_REQUIRED_PATCH = 4;
    private static final int TCN_1_RECOMMENDED_MINOR = 3;
    private static final int TCN_1_RECOMMENDED_PATCH = 4;
    protected static final int TCN_REQUIRED_MAJOR = 2;
    protected static final int TCN_REQUIRED_MINOR = 0;
    protected static final int TCN_REQUIRED_PATCH = 12;
    protected static final int TCN_RECOMMENDED_MAJOR = 2;
    protected static final int TCN_RECOMMENDED_MINOR = 0;
    protected static final int TCN_RECOMMENDED_PV = 12;
    private static int tcnMajor = 0;
    private static int tcnMinor = 0;
    private static int tcnPatch = 0;
    private static int tcnVersion = 0;
    protected static String SSLEngine = "on";
    protected static String FIPSMode = "off";
    protected static String SSLRandomSeed = "builtin";
    protected static boolean sslInitialized = false;
    protected static boolean fipsModeActive = false;
    private static final int FIPS_ON = 1;
    private static final int FIPS_OFF = 0;
    private static int referenceCount = 0;
    private boolean instanceInitialized = false;

    public static boolean isAprAvailable() {
        if (AprStatus.isInstanceCreated()) {
            ReentrantReadWriteLock.WriteLock writeLock = AprStatus.getStatusLock().writeLock();
            writeLock.lock();
            try {
                AprLifecycleListener.init();
            }
            finally {
                writeLock.unlock();
            }
        }
        return AprStatus.isAprAvailable();
    }

    public AprLifecycleListener() {
        AprStatus.setInstanceCreated((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        block23: {
            if ("before_init".equals(lifecycleEvent.getType())) {
                ReentrantReadWriteLock.WriteLock writeLock = AprStatus.getStatusLock().writeLock();
                writeLock.lock();
                try {
                    this.instanceInitialized = true;
                    if (!(lifecycleEvent.getLifecycle() instanceof Server)) {
                        log.warn((Object)sm.getString("listener.notServer", new Object[]{lifecycleEvent.getLifecycle().getClass().getSimpleName()}));
                    }
                    if (referenceCount++ != 0) {
                        return;
                    }
                    AprLifecycleListener.init();
                    for (String object : initInfoLogMessages) {
                        log.info((Object)object);
                    }
                    initInfoLogMessages.clear();
                    if (AprStatus.isAprAvailable()) {
                        try {
                            AprLifecycleListener.initializeSSL();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
                            ExceptionUtils.handleThrowable((Throwable)throwable2);
                            log.error((Object)sm.getString("aprListener.sslInit"), throwable2);
                        }
                    }
                    if (null != FIPSMode && !"off".equalsIgnoreCase(FIPSMode) && !this.isFIPSModeActive()) {
                        Error error = new Error(sm.getString("aprListener.initializeFIPSFailed"));
                        log.fatal((Object)error.getMessage(), (Throwable)error);
                        throw error;
                    }
                    break block23;
                }
                finally {
                    writeLock.unlock();
                }
            }
            if ("after_destroy".equals(lifecycleEvent.getType())) {
                ReentrantReadWriteLock.WriteLock writeLock = AprStatus.getStatusLock().writeLock();
                writeLock.lock();
                try {
                    if (this.instanceInitialized) {
                        --referenceCount;
                    }
                    if (referenceCount != 0) {
                        return;
                    }
                    if (!AprStatus.isAprAvailable()) {
                        return;
                    }
                    try {
                        AprLifecycleListener.terminateAPR();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
                        ExceptionUtils.handleThrowable((Throwable)throwable2);
                        log.warn((Object)sm.getString("aprListener.aprDestroy"), throwable2);
                    }
                }
                finally {
                    writeLock.unlock();
                }
            }
        }
    }

    private static void terminateAPR() {
        AprStatus.setAprInitialized((boolean)false);
        AprStatus.setAprAvailable((boolean)false);
        fipsModeActive = false;
        sslInitialized = false;
        System.gc();
        Library.terminate();
    }

    private static void init() {
        int n;
        int n2;
        if (AprStatus.isAprInitialized()) {
            return;
        }
        AprStatus.setAprInitialized((boolean)true);
        try {
            Library.initialize(null);
            tcnMajor = Library.TCN_MAJOR_VERSION;
            tcnMinor = Library.TCN_MINOR_VERSION;
            tcnPatch = Library.TCN_PATCH_VERSION;
            tcnVersion = tcnMajor * 1000 + tcnMinor * 100 + tcnPatch;
        }
        catch (LibraryNotFoundError libraryNotFoundError) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("aprListener.aprInitDebug", new Object[]{libraryNotFoundError.getLibraryNames(), System.getProperty("java.library.path"), libraryNotFoundError.getMessage()}), (Throwable)libraryNotFoundError);
            }
            initInfoLogMessages.add(sm.getString("aprListener.aprInit", new Object[]{System.getProperty("java.library.path")}));
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
            ExceptionUtils.handleThrowable((Throwable)throwable2);
            log.warn((Object)sm.getString("aprListener.aprInitError", new Object[]{throwable2.getMessage()}), throwable2);
            return;
        }
        if (tcnMajor > 1 && "off".equalsIgnoreCase(SSLEngine)) {
            log.error((Object)sm.getString("aprListener.sslRequired", new Object[]{SSLEngine, Library.versionString()}));
            try {
                AprLifecycleListener.terminateAPR();
            }
            catch (Throwable throwable) {
                Throwable throwable3 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
                ExceptionUtils.handleThrowable((Throwable)throwable3);
            }
            return;
        }
        if (tcnMajor == 1) {
            n2 = 1304;
            n = 1304;
        } else {
            n2 = 2012;
            n = 2012;
        }
        if (tcnVersion < n2) {
            if (tcnMajor == 1) {
                log.error((Object)sm.getString("aprListener.tcnInvalid.1", new Object[]{Library.versionString(), "1.3.4"}));
            } else {
                log.error((Object)sm.getString("aprListener.tcnInvalid", new Object[]{Library.versionString(), "2.0.12"}));
            }
            try {
                AprLifecycleListener.terminateAPR();
            }
            catch (Throwable throwable) {
                Throwable throwable4 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
                ExceptionUtils.handleThrowable((Throwable)throwable4);
            }
            return;
        }
        if (tcnVersion < n) {
            if (tcnMajor == 1) {
                initInfoLogMessages.add(sm.getString("aprListener.tcnVersion.1", new Object[]{Library.versionString(), "1.3.4"}));
            } else {
                initInfoLogMessages.add(sm.getString("aprListener.tcnVersion", new Object[]{Library.versionString(), "2.0.12"}));
            }
        }
        initInfoLogMessages.add(sm.getString("aprListener.tcnValid", new Object[]{Library.versionString(), Library.aprVersionString()}));
        AprStatus.setAprAvailable((boolean)true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void initializeSSL() throws Exception {
        boolean bl;
        if ("off".equalsIgnoreCase(SSLEngine)) {
            return;
        }
        if (sslInitialized) {
            return;
        }
        sslInitialized = true;
        String string = "randSet";
        Class[] classArray = new Class[]{String.class};
        Object[] objectArray = new Object[]{SSLRandomSeed};
        Class<?> clazz = Class.forName("org.apache.tomcat.jni.SSL");
        Method method = clazz.getMethod(string, classArray);
        method.invoke(null, objectArray);
        string = "initialize";
        objectArray[0] = "on".equalsIgnoreCase(SSLEngine) ? null : SSLEngine;
        method = clazz.getMethod(string, classArray);
        method.invoke(null, objectArray);
        AprStatus.setOpenSSLVersion((int)SSL.version());
        boolean bl2 = bl = tcnMajor > 1 || tcnVersion > 1233 && ((long)SSL.version() & 0xF0000000L) > 0x20000000L;
        if (bl || null != FIPSMode && !"off".equalsIgnoreCase(FIPSMode)) {
            boolean bl3;
            int n;
            block25: {
                fipsModeActive = false;
                n = SSL.fipsModeGet();
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("aprListener.currentFIPSMode", new Object[]{n}));
                }
                if (null == FIPSMode || "off".equalsIgnoreCase(FIPSMode)) {
                    if (n == 1) {
                        fipsModeActive = true;
                    }
                    bl3 = false;
                } else if ("on".equalsIgnoreCase(FIPSMode)) {
                    if (n == 1) {
                        if (!bl) {
                            log.info((Object)sm.getString("aprListener.skipFIPSInitialization"));
                        }
                        fipsModeActive = true;
                        bl3 = false;
                    } else {
                        if (bl) {
                            throw new IllegalStateException(sm.getString("aprListener.FIPSProviderNotDefault", new Object[]{FIPSMode}));
                        }
                        bl3 = true;
                    }
                } else {
                    if ("require".equalsIgnoreCase(FIPSMode)) {
                        if (n == 1) {
                            fipsModeActive = true;
                            bl3 = false;
                            break block25;
                        } else {
                            if (bl) {
                                throw new IllegalStateException(sm.getString("aprListener.FIPSProviderNotDefault", new Object[]{FIPSMode}));
                            }
                            throw new IllegalStateException(sm.getString("aprListener.requireNotInFIPSMode"));
                        }
                    }
                    if (!"enter".equalsIgnoreCase(FIPSMode)) {
                        throw new IllegalArgumentException(sm.getString("aprListener.wrongFIPSMode", new Object[]{FIPSMode}));
                    }
                    if (n == 0) {
                        if (bl) {
                            throw new IllegalStateException(sm.getString("aprListener.FIPSProviderNotDefault", new Object[]{FIPSMode}));
                        }
                        bl3 = true;
                    } else {
                        if (!bl) {
                            throw new IllegalStateException(sm.getString("aprListener.enterAlreadyInFIPSMode", new Object[]{n}));
                        }
                        fipsModeActive = true;
                        bl3 = false;
                    }
                }
            }
            if (bl3) {
                log.info((Object)sm.getString("aprListener.initializingFIPS"));
                n = SSL.fipsModeSet((int)1);
                if (n != 1) {
                    String string2 = sm.getString("aprListener.initializeFIPSFailed");
                    log.error((Object)string2);
                    throw new IllegalStateException(string2);
                }
                fipsModeActive = true;
                log.info((Object)sm.getString("aprListener.initializeFIPSSuccess"));
            }
            if (bl && fipsModeActive) {
                log.info((Object)sm.getString("aprListener.usingFIPSProvider"));
            }
        }
        log.info((Object)sm.getString("aprListener.initializedOpenSSL", new Object[]{SSL.versionString()}));
    }

    public String getSSLEngine() {
        return SSLEngine;
    }

    public void setSSLEngine(String string) {
        if (!string.equals(SSLEngine)) {
            if (sslInitialized) {
                throw new IllegalStateException(sm.getString("aprListener.tooLateForSSLEngine"));
            }
            SSLEngine = string;
        }
    }

    public String getSSLRandomSeed() {
        return SSLRandomSeed;
    }

    public void setSSLRandomSeed(String string) {
        if (!string.equals(SSLRandomSeed)) {
            if (sslInitialized) {
                throw new IllegalStateException(sm.getString("aprListener.tooLateForSSLRandomSeed"));
            }
            SSLRandomSeed = string;
        }
    }

    public String getFIPSMode() {
        return FIPSMode;
    }

    public void setFIPSMode(String string) {
        if (!string.equals(FIPSMode)) {
            if (sslInitialized) {
                throw new IllegalStateException(sm.getString("aprListener.tooLateForFIPSMode"));
            }
            FIPSMode = string;
        }
    }

    public boolean isFIPSModeActive() {
        return fipsModeActive;
    }

    public void setUseOpenSSL(boolean bl) {
        if (bl != AprStatus.getUseOpenSSL()) {
            AprStatus.setUseOpenSSL((boolean)bl);
        }
    }

    public static boolean getUseOpenSSL() {
        return AprStatus.getUseOpenSSL();
    }

    public static boolean isInstanceCreated() {
        return AprStatus.isInstanceCreated();
    }
}

