/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import org.thymeleaf.engine.IEngineProcessable;
import org.thymeleaf.engine.ITemplateHandler;
import org.thymeleaf.engine.Model;
import org.thymeleaf.engine.ProcessorTemplateHandler;
import org.thymeleaf.engine.TemplateFlowController;
import org.thymeleaf.model.ITemplateEnd;

final class TemplateEndModelProcessable
implements IEngineProcessable {
    private final ITemplateEnd templateEnd;
    private final Model model;
    private final ITemplateHandler modelHandler;
    private final ProcessorTemplateHandler processorTemplateHandler;
    private final ITemplateHandler nextHandler;
    private final TemplateFlowController flowController;
    private int offset;

    TemplateEndModelProcessable(ITemplateEnd templateEnd, Model model, ITemplateHandler modelHandler, ProcessorTemplateHandler processorTemplateHandler, ITemplateHandler nextHandler, TemplateFlowController flowController) {
        this.templateEnd = templateEnd;
        this.model = model;
        this.modelHandler = modelHandler;
        this.processorTemplateHandler = processorTemplateHandler;
        this.nextHandler = nextHandler;
        this.flowController = flowController;
        this.offset = 0;
    }

    @Override
    public boolean process() {
        if (this.flowController.stopProcessing) {
            return false;
        }
        this.offset += this.model.process(this.modelHandler, this.offset, this.flowController);
        if (this.offset < this.model.queueSize || this.flowController.stopProcessing) {
            return false;
        }
        this.nextHandler.handleTemplateEnd(this.templateEnd);
        this.processorTemplateHandler.performTearDownChecks(this.templateEnd);
        return true;
    }
}

