/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleClob;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.CLOB;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class OracleClobWriter
extends Writer {
    private final OracleClobWriterLock lock;
    DBConversion dbConversion;
    OracleClob clob;
    long lobOffset;
    char[] charBuf;
    byte[] nativeBuf;
    int pos;
    int count;
    int chunkSize;
    boolean isClosed;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;

    public OracleClobWriter(CLOB clob, int bufferSize) throws SQLException {
        this((OracleClob)clob, bufferSize);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$6, null, clob, bufferSize);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$6, null);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$6, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleClobWriter(OracleClob clob, int bufferSize) throws SQLException {
        this(clob, bufferSize, 1L);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$7, null, clob, bufferSize);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$7, null);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$7, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$7, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleClobWriter(CLOB clob, int bufferSize, long beginOffset) throws SQLException {
        this((OracleClob)clob, bufferSize, beginOffset);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$8, null, clob, bufferSize, beginOffset);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$8, null);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$8, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleClobWriter(OracleClob clob, int bufferSize, long beginOffset) throws SQLException {
        super(new OracleClobWriterLock());
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$9, null, clob, bufferSize, beginOffset);
            }
            this.lock = (OracleClobWriterLock)((Writer)this).lock;
            if (clob == null || bufferSize <= 0 || clob.getJavaSqlConnection() == null || beginOffset < 1L) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$9, null, illegalArgumentException);
                }
                throw illegalArgumentException;
            }
            this.dbConversion = ((PhysicalConnection)clob.getInternalConnection()).conversion;
            this.clob = clob;
            this.lobOffset = beginOffset;
            this.charBuf = new char[bufferSize];
            this.nativeBuf = new byte[bufferSize * 3];
            this.count = 0;
            this.pos = 0;
            this.chunkSize = bufferSize;
            this.isClosed = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$9, null);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$9, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$9, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void write(char[] cArray, int n2, int n3) throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            int lengthToWrite;
            void cbuf;
            block11: {
                void off;
                void len;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$0, this, cArray, n2, n3);
                }
                OracleClobWriterLock oracleClobWriterLock = this.lock;
                // MONITORENTER : oracleClobWriterLock
                this.ensureOpen();
                lengthToWrite = Math.min((int)len, ((void)cbuf).length - off);
                if (lengthToWrite < 2 * this.chunkSize) break block11;
                if (this.count > 0) {
                    this.flushBuffer();
                }
                try {
                    this.lobOffset += (long)this.clob.putChars(this.lobOffset, (char[])cbuf, (int)off, lengthToWrite);
                }
                catch (SQLException e2) {
                    IOException iOException = (IOException)DatabaseError.createIOException(e2).fillInStackTrace();
                    if (!bl) throw iOException;
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$0, this, iOException);
                    throw iOException;
                }
                if (!bl) return;
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$0, this, null);
                return;
            }
            try {
                int charsWritten;
                void start;
                void end = start + lengthToWrite;
                for (start = off; start < end; start += charsWritten, this.count += charsWritten) {
                    charsWritten = Math.min(this.chunkSize - this.count, (int)(end - start));
                    System.arraycopy(cbuf, (int)start, this.charBuf, this.count, charsWritten);
                    if (this.count < this.chunkSize) continue;
                    this.flushBuffer();
                }
                // MONITOREXIT : oracleClobWriterLock
            }
            catch (Throwable throwable) {
                // MONITOREXIT : oracleClobWriterLock
                Throwable throwable2 = throwable;
                if (!bl) throw throwable2;
                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$0, this, throwable2);
                throw throwable2;
            }
            if (!bl) return;
            ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$0, this);
            ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$0, this, null);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (!bl) throw throwable;
            ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$0, this, throwable3);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$1, this, new Object[0]);
            }
            OracleClobWriterLock oracleClobWriterLock = this.lock;
            synchronized (oracleClobWriterLock) {
                try {
                    this.ensureOpen();
                    this.flushBuffer();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl13 : MonitorExitStatement: MONITOREXIT : var1_2
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$1, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$1, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$2, this, new Object[0]);
            }
            OracleClobWriterLock oracleClobWriterLock = this.lock;
            synchronized (oracleClobWriterLock) {
                try {
                    this.flushBuffer();
                    this.isClosed = true;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl13 : MonitorExitStatement: MONITOREXIT : var1_2
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$2, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$2, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffer() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$3, this, new Object[0]);
            }
            OracleClobWriterLock oracleClobWriterLock = this.lock;
            synchronized (oracleClobWriterLock) {
                try {
                    try {
                        if (this.count > 0) {
                            this.lobOffset += (long)this.clob.putChars(this.lobOffset, this.charBuf, 0, this.count);
                            this.count = 0;
                        }
                    }
                    catch (SQLException e2) {
                        IOException iOException = (IOException)DatabaseError.createIOException(e2).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$3, this, iOException);
                        }
                        throw iOException;
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 5] lbl22 : MonitorExitStatement: MONITOREXIT : var1_2
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$3, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$3, this, throwable3);
            }
            throw throwable;
        }
    }

    void ensureOpen() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$4, this, new Object[0]);
            }
            try {
                if (this.isClosed) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$4, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            catch (SQLException e2) {
                IOException iOException = (IOException)DatabaseError.createIOException(e2).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$4, this, iOException);
                }
                throw iOException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            OracleConnection oracleConnection;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$5, this, new Object[0]);
                }
                try {
                    oracleConnection = this.clob.getInternalConnection();
                    if (!bl) break block7;
                }
                catch (Exception exc) {
                    OracleConnection oracleConnection2 = null;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$5, this, oracleConnection2);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$5, this, null);
                    }
                    return null;
                }
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$5, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$5, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleClobWriter.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$9 = OracleClobWriter.class.getDeclaredConstructor(OracleClob.class, Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleClobWriter.class.getDeclaredConstructor(CLOB.class, Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleClobWriter.class.getDeclaredConstructor(OracleClob.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleClobWriter.class.getDeclaredConstructor(CLOB.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleClobWriter.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleClobWriter.class.getDeclaredMethod("ensureOpen", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleClobWriter.class.getDeclaredMethod("flushBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleClobWriter.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleClobWriter.class.getDeclaredMethod("flush", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleClobWriter.class.getDeclaredMethod("write", char[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    private static final class OracleClobWriterLock {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;

        private OracleClobWriterLock() {
        }

        static {
            try {
                $$$methodRef$$$0 = OracleClobWriterLock.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

