/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.util.LinkedHashMap;
import java.util.Map;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;

final class RowValueBuilder {
    private final RowDescriptor rowDescriptor;
    private final DatatypeCoder datatypeCoder;
    private final LruEncodedStringCache stringCache = new LruEncodedStringCache(50);
    private RowValue rowValue;
    private int currentIndex;

    RowValueBuilder(RowDescriptor rowDescriptor) {
        this.rowDescriptor = rowDescriptor;
        this.rowValue = rowDescriptor.createDefaultFieldValues();
        this.datatypeCoder = rowDescriptor.getDatatypeCoder();
    }

    RowValueBuilder setFieldIndex(int index) {
        this.checkBounds(index);
        this.currentIndex = index;
        return this;
    }

    RowValueBuilder at(int index) {
        return this.setFieldIndex(index);
    }

    RowValueBuilder set(byte[] fieldData) {
        this.rowValue.setFieldData(this.currentIndex, fieldData);
        return this;
    }

    RowValueBuilder setInt(int value) {
        return this.set(this.datatypeCoder.encodeInt(value));
    }

    RowValueBuilder setInt(Number value) {
        if (value != null) {
            return this.setInt(value.intValue());
        }
        return this.set(null);
    }

    RowValueBuilder setShort(int value) {
        return this.setShort((short)value);
    }

    RowValueBuilder setShort(Number value) {
        if (value != null) {
            return this.setShort(value.shortValue());
        }
        return this.set(null);
    }

    RowValueBuilder setShort(short value) {
        return this.set(this.datatypeCoder.encodeShort(value));
    }

    RowValueBuilder setString(String value) {
        return this.set(value != null ? this.stringCache.computeIfAbsent(value, this.datatypeCoder::encodeString) : null);
    }

    byte[] get(int index) {
        this.checkBounds(index);
        return this.rowValue.getFieldData(index);
    }

    RowValueBuilder reset() {
        this.rowValue = this.rowDescriptor.createDefaultFieldValues();
        return this;
    }

    int getSize() {
        return this.rowDescriptor.getCount();
    }

    RowValue toRowValue(boolean initialize) {
        try {
            if (initialize) {
                this.rowValue.initializeFields();
            }
            RowValue rowValue = this.rowValue;
            return rowValue;
        }
        finally {
            this.reset();
        }
    }

    private void checkBounds(int index) {
        if (index < 0 || index >= this.rowDescriptor.getCount()) {
            throw new IndexOutOfBoundsException(String.format("The index '%d' exceeds the expected size (%d) of this RowDescriptorBuilder", index, this.rowDescriptor.getCount()));
        }
    }

    private static final class LruEncodedStringCache
    extends LinkedHashMap<String, byte[]> {
        private static final long serialVersionUID = -901927526404254328L;
        private final int maxCapacity;

        private LruEncodedStringCache(int maxCapacity) {
            super(maxCapacity, 0.75f, true);
            this.maxCapacity = maxCapacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, byte[]> eldest) {
            return this.size() > this.maxCapacity;
        }
    }
}

