/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import org.firebirdsql.jdbc.DbMetadataMediator;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class CatalogMetadataInfo {
    final DbMetadataMediator mediator;

    private CatalogMetadataInfo(DbMetadataMediator mediator) {
        this.mediator = mediator;
    }

    public static CatalogMetadataInfo create(DbMetadataMediator mediator) {
        if (mediator.isUseCatalogAsPackage()) {
            return CatalogAsPackageMetadataInfo.createInstance(mediator);
        }
        return new CatalogMetadataInfo(mediator);
    }

    public String getCatalogSeparator() {
        return null;
    }

    public String getCatalogTerm() {
        return null;
    }

    public boolean isCatalogAtStart() {
        return false;
    }

    public int getMaxCatalogNameLength() {
        return 0;
    }

    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    private static final class CatalogAsPackageMetadataInfo
    extends CatalogMetadataInfo {
        private CatalogAsPackageMetadataInfo(DbMetadataMediator mediator) {
            super(mediator);
        }

        static CatalogMetadataInfo createInstance(DbMetadataMediator mediator) {
            return new CatalogAsPackageMetadataInfo(mediator);
        }

        @Override
        public String getCatalogSeparator() {
            return ".";
        }

        @Override
        public String getCatalogTerm() {
            return "PACKAGE";
        }

        @Override
        public boolean isCatalogAtStart() {
            return true;
        }

        @Override
        public int getMaxCatalogNameLength() {
            return this.mediator.getMetaData().getMaxObjectNameLength();
        }

        @Override
        public boolean supportsCatalogsInDataManipulation() {
            return true;
        }

        @Override
        public boolean supportsCatalogsInProcedureCalls() {
            return true;
        }
    }
}

