/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess;

import com.ibm.db2.cmx.runtime.exception.DataRuntimeException;
import com.ibm.db2.cmx.runtime.internal.CentralStoreKey;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.repository.manager.ConnectionManager;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RepositoryDataFactory;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.LogEntry;
import com.ibm.db2.cmx.runtime.internal.repository.sql.pkg.pk3.AccessMetaDataLite;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.List;

public class LogWriter {
    private CentralStoreKey centralStoreKey_ = null;

    public static LogWriter getInstance() {
        return new LogWriter();
    }

    public void createLog(Connection connection, String string, String string2, String string3, Timestamp timestamp, String string4, String string5, int n2, String string6) {
        ConnectionManager.ConnectionInfo connectionInfo = ConnectionManager.getConnectionInfo(connection);
        AccessMetaDataLite accessMetaDataLite = RepositoryDataFactory.getData(AccessMetaDataLite.class, connection, connectionInfo);
        if (string2 == null) {
            if (this.centralStoreKey_ == null && DataProperties.getGlobalCentralStoreKey() != null) {
                this.centralStoreKey_ = DataProperties.getGlobalCentralStoreKey().cloneKey();
            }
            if (this.centralStoreKey_ != null) {
                string2 = this.centralStoreKey_.getGroupVersion();
            }
        }
        if (string3 != null && string3.length() > 255) {
            string3 = string3.substring(0, 255);
        }
        if (string5 != null && string5.length() > 8) {
            string5 = string5.substring(0, 8);
        }
        try {
            accessMetaDataLite.insertLog(string, string2, string3, timestamp, string4, string5, n2, string6);
        }
        catch (DataRuntimeException dataRuntimeException) {
            String string7 = dataRuntimeException.getSQLState();
            if ("22001".equals(string7) || "72000".equals(string7) && dataRuntimeException.getErrorCode() == 12899) {
                string6 = string6 == null ? string4 : string4 + " | \n" + string6;
                Throwable throwable = dataRuntimeException.getCause();
                if (throwable != null && (string4 = "Log message was not inserted because it was too long. Original message is placed in DUMP column. Error message was: " + throwable.getMessage()) != null && string4.length() > 2048) {
                    string4 = string4.substring(0, 2000);
                }
                accessMetaDataLite.insertLog(string, string2, string3, timestamp, string4, string5, n2, string6);
            }
            throw dataRuntimeException;
        }
    }

    public void insertAll(Connection connection, List<LogEntry> list) {
        ConnectionManager.ConnectionInfo connectionInfo = ConnectionManager.getConnectionInfo(connection);
        AccessMetaDataLite accessMetaDataLite = RepositoryDataFactory.getData(AccessMetaDataLite.class, connection, connectionInfo);
        for (LogEntry logEntry : list) {
            if (logEntry.hostIp != null && logEntry.hostIp.length() > 255) {
                logEntry.hostIp = logEntry.hostIp.substring(0, 255);
            }
            if (logEntry.message != null && logEntry.message.length() > 2048) {
                logEntry.details = logEntry.details == null ? logEntry.message : logEntry.message + " | \n" + logEntry.details;
                logEntry.message = logEntry.message.substring(0, 1024);
            }
            if (logEntry.logLevel == null || logEntry.logLevel.length() <= 8) continue;
            logEntry.logLevel = logEntry.logLevel.substring(0, 8);
        }
        accessMetaDataLite.insertLogBatch(list);
    }
}

