/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.impl;

import com.ibm.db2.cmx.ClientDescriptor;
import com.ibm.db2.cmx.ProductInformation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;

public class DriverDescriptor
implements ClientDescriptor.Driver,
Serializable {
    private static final long serialVersionUID = -9047792894831997654L;
    private transient String driverId_;
    private String clientInstallationUUID_;
    private String[] clientIPAddresses_;
    private ProductInformation.Client clientProductInformation_;
    HashMap<String, Object> clientDriverPropertySettings_;
    private static long currentDriverIdCount_ = 0L;

    public DriverDescriptor(String string, String[] stringArray, ProductInformation.Client client, HashMap<String, Object> hashMap) {
        this.clientInstallationUUID_ = string;
        this.clientIPAddresses_ = stringArray;
        this.clientProductInformation_ = client;
        this.clientDriverPropertySettings_ = hashMap;
        this.driverId_ = DriverDescriptor.getDriverUUID() + "_driverId" + DriverDescriptor.getNextDriverIdCount();
    }

    private static synchronized long getNextDriverIdCount() {
        return ++currentDriverIdCount_;
    }

    private static synchronized String getDriverUUID() {
        return UUID.randomUUID().toString();
    }

    @Override
    public String getDriverId() {
        return this.driverId_;
    }

    @Override
    public String getClientInstallationUUID() {
        return this.clientInstallationUUID_;
    }

    @Override
    public String[] getClientIPAddresses() {
        return this.clientIPAddresses_;
    }

    @Override
    public HashMap<String, Object> getDriverPropertySettings() {
        return this.clientDriverPropertySettings_;
    }

    @Override
    public ProductInformation.Client getClientProductInformation() {
        return this.clientProductInformation_;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + Arrays.hashCode(this.clientIPAddresses_);
        n2 = 31 * n2 + (this.clientInstallationUUID_ == null ? 0 : this.clientInstallationUUID_.hashCode());
        n2 = 31 * n2 + (this.clientProductInformation_ == null ? 0 : this.clientProductInformation_.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DriverDescriptor driverDescriptor = (DriverDescriptor)object;
        if (!Arrays.equals(this.clientIPAddresses_, driverDescriptor.clientIPAddresses_)) {
            return false;
        }
        if (this.clientInstallationUUID_ == null ? driverDescriptor.clientInstallationUUID_ != null : !this.clientInstallationUUID_.equals(driverDescriptor.clientInstallationUUID_)) {
            return false;
        }
        return !(this.clientProductInformation_ == null ? driverDescriptor.clientProductInformation_ != null : !this.clientProductInformation_.equals(driverDescriptor.clientProductInformation_));
    }
}

