/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.async.methods;

import com.aayushatharva.brotli4j.decoder.DecoderJNI;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.Header;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.HttpException;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.CapacityChannel;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.util.Asserts;

public final class InflatingBrotliDataConsumer
implements AsyncDataConsumer {
    private final AsyncDataConsumer downstream;
    private final DecoderJNI.Wrapper decoder;
    private volatile CapacityChannel capacity;

    public InflatingBrotliDataConsumer(AsyncDataConsumer downstream) {
        this.downstream = downstream;
        try {
            this.decoder = new DecoderJNI.Wrapper(8192);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize DecoderJNI", e);
        }
    }

    @Override
    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.capacity = capacityChannel;
        this.downstream.updateCapacity(capacityChannel);
    }

    @Override
    public void consume(ByteBuffer src) throws IOException {
        while (src.hasRemaining()) {
            ByteBuffer in = this.decoder.getInputBuffer();
            int xfer = Math.min(src.remaining(), in.remaining());
            if (xfer == 0) {
                this.decoder.push(0);
                this.pump();
                continue;
            }
            int lim = src.limit();
            src.limit(src.position() + xfer);
            in.put(src);
            src.limit(lim);
            this.decoder.push(xfer);
            this.pump();
        }
        CapacityChannel ch = this.capacity;
        if (ch != null) {
            ch.update(Integer.MAX_VALUE);
        }
    }

    @Override
    public void streamEnd(List<? extends Header> trailers) throws IOException, HttpException {
        this.pump();
        Asserts.check(this.decoder.getStatus() == DecoderJNI.Status.DONE || !this.decoder.hasOutput(), "Truncated brotli stream");
        this.downstream.streamEnd(trailers);
    }

    @Override
    public void releaseResources() {
        try {
            this.decoder.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.downstream.releaseResources();
    }

    private void pump() throws IOException {
        block6: while (true) {
            switch (this.decoder.getStatus()) {
                case OK: {
                    this.decoder.push(0);
                    continue block6;
                }
                case NEEDS_MORE_OUTPUT: {
                    ByteBuffer nativeBuf = this.decoder.pull();
                    if (nativeBuf == null || !nativeBuf.hasRemaining()) continue block6;
                    ByteBuffer copy = ByteBuffer.allocateDirect(nativeBuf.remaining());
                    copy.put(nativeBuf).flip();
                    this.downstream.consume(copy);
                    continue block6;
                }
                case NEEDS_MORE_INPUT: {
                    ByteBuffer copy;
                    ByteBuffer nativeBuf;
                    if (this.decoder.hasOutput() && (nativeBuf = this.decoder.pull()) != null && nativeBuf.hasRemaining()) {
                        copy = ByteBuffer.allocateDirect(nativeBuf.remaining());
                        copy.put(nativeBuf).flip();
                        this.downstream.consume(copy);
                        continue block6;
                    }
                    return;
                }
                case DONE: {
                    ByteBuffer copy;
                    ByteBuffer nativeBuf;
                    if (this.decoder.hasOutput() && (nativeBuf = this.decoder.pull()) != null && nativeBuf.hasRemaining()) {
                        copy = ByteBuffer.allocateDirect(nativeBuf.remaining());
                        copy.put(nativeBuf).flip();
                        this.downstream.consume(copy);
                        continue block6;
                    }
                    return;
                }
            }
            break;
        }
        throw new IOException("Brotli stream corrupted");
    }
}

