/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleRef;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.Datum;
import oracle.sql.REF;
import oracle.sql.StructDescriptor;

public class OracleTypeREF
extends OracleNamedType
implements Serializable {
    private static final String CLASS_NAME = OracleTypeREF.class.getName();
    static final long serialVersionUID = 3186448715463064573L;

    protected OracleTypeREF() {
    }

    public OracleTypeREF(String sql_name, OracleConnection conn) throws SQLException {
        super(sql_name, conn);
    }

    public OracleTypeREF(OracleTypeADT parent, int idx, OracleConnection conn) {
        super(parent, idx, conn);
    }

    @Override
    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        Datum datum = null;
        if (value != null) {
            if (value instanceof REF) {
                datum = (Datum)value;
            } else if (value instanceof OracleRef) {
                datum = (Datum)value;
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, value).fillInStackTrace();
            }
        }
        return datum;
    }

    @Override
    public int getTypeCode() {
        return 2006;
    }

    @Override
    protected Object toObject(byte[] val, int style, Map map) throws SQLException {
        if (val == null || val.length == 0) {
            return null;
        }
        if (style == 1 || style == 2) {
            StructDescriptor desc = this.createStructDescriptor();
            return new REF(desc, (Connection)this.connection, val);
        }
        if (style == 3) {
            return val;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, val).fillInStackTrace();
    }

    StructDescriptor createStructDescriptor() throws SQLException {
        if (this.descriptor == null) {
            if (this.sqlName == null && this.getFullName(false) == null) {
                OracleTypeADT otype = new OracleTypeADT(this.getParent(), this.getOrder(), (Connection)this.connection);
                this.descriptor = new StructDescriptor(otype, (Connection)this.connection);
            } else {
                this.descriptor = StructDescriptor.createDescriptor(this.sqlName, (Connection)this.connection);
            }
        }
        return (StructDescriptor)this.descriptor;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "writeObject", "Invoked", null, null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "readObject", "Invoked", null, null);
    }
}

