/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.Altitude;
import tim.prune.data.AudioClip;
import tim.prune.data.Coordinate;
import tim.prune.data.Distance;
import tim.prune.data.Field;
import tim.prune.data.FieldList;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.data.Photo;
import tim.prune.data.PointCreateOptions;
import tim.prune.data.SourceInfo;
import tim.prune.data.Speed;
import tim.prune.data.Timestamp;
import tim.prune.data.TimestampUtc;
import tim.prune.data.Unit;
import tim.prune.data.UnitSet;

public class DataPoint {
    private String[] _fieldValues;
    private final FieldList _fieldList;
    private Coordinate _latitude = null;
    private Coordinate _longitude = null;
    private Altitude _altitude = null;
    private Speed _hSpeed = null;
    private Speed _vSpeed = null;
    private Timestamp _timestamp = null;
    private SourceInfo _sourceInfo = null;
    private int _originalIndex = -1;
    private Photo _photo = null;
    private AudioClip _audio = null;
    private String _waypointName = null;
    private boolean _startOfSegment = false;
    private int _modifyCount = 0;
    private static FieldList _sharedLatLonAltFieldList = null;

    public DataPoint(String[] stringArray, FieldList fieldList, PointCreateOptions pointCreateOptions) {
        this._fieldValues = stringArray;
        this._fieldList = fieldList;
        DataPoint.removeQuotes(this._fieldValues);
        this.parseFields(null, pointCreateOptions);
    }

    private void parseFields(Field field, PointCreateOptions pointCreateOptions) {
        Object object;
        if (pointCreateOptions == null) {
            pointCreateOptions = new PointCreateOptions();
        }
        if (field == null || field == Field.LATITUDE) {
            this._latitude = Latitude.make(this.getFieldValue(Field.LATITUDE));
        }
        if (field == null || field == Field.LONGITUDE) {
            this._longitude = Longitude.make(this.getFieldValue(Field.LONGITUDE));
        }
        if (field == null || field == Field.ALTITUDE) {
            object = this._altitude != null && this._altitude.getUnit() != null ? this._altitude.getUnit() : pointCreateOptions.getAltitudeUnits();
            this._altitude = new Altitude(this.getFieldValue(Field.ALTITUDE), (Unit)object);
        }
        if (field == null || field == Field.SPEED) {
            object = this._hSpeed != null && this._hSpeed.getUnit() != null ? this._hSpeed.getUnit() : pointCreateOptions.getSpeedUnits();
            this._hSpeed = Speed.createOrNull(this.getFieldValue(Field.SPEED), (Unit)object);
        }
        if (field == null || field == Field.VERTICAL_SPEED) {
            boolean bl;
            if (this._vSpeed != null && this._vSpeed.getUnit() != null) {
                object = this._vSpeed.getUnit();
                bl = this._vSpeed.isInverted();
            } else {
                object = pointCreateOptions.getVerticalSpeedUnits();
                bl = !pointCreateOptions.getVerticalSpeedsUpwards();
            }
            this._vSpeed = Speed.createOrNull(this.getFieldValue(Field.VERTICAL_SPEED), (Unit)object, bl);
        }
        if (field == null || field == Field.TIMESTAMP) {
            this._timestamp = new TimestampUtc(this.getFieldValue(Field.TIMESTAMP));
        }
        if (field == null || field == Field.WAYPT_NAME) {
            this._waypointName = this.getFieldValue(Field.WAYPT_NAME);
        }
        if (field == null || field == Field.NEW_SEGMENT) {
            object = this.getFieldValue(Field.NEW_SEGMENT);
            if (object != null) {
                object = ((String)object).trim();
            }
            this._startOfSegment = object != null && (((String)object).equals("1") || ((String)object).equalsIgnoreCase("Y"));
        }
    }

    public DataPoint(Coordinate coordinate, Coordinate coordinate2) {
        this(coordinate, coordinate2, null);
    }

    public DataPoint(Coordinate coordinate, Coordinate coordinate2, Altitude altitude) {
        this._fieldValues = new String[3];
        this._fieldList = DataPoint.getSharedLatLonFieldList();
        this._latitude = coordinate;
        this._fieldValues[0] = coordinate.toString();
        this._longitude = coordinate2;
        this._fieldValues[1] = coordinate2.toString();
        if (altitude == null) {
            this._altitude = Altitude.NONE;
        } else {
            this._altitude = altitude;
            this._fieldValues[2] = "" + altitude.getValue();
        }
        this._timestamp = new TimestampUtc(null);
    }

    public DataPoint(double d, double d2) {
        this(Latitude.make(d), Longitude.make(d2), null);
    }

    private static FieldList getSharedLatLonFieldList() {
        if (_sharedLatLonAltFieldList == null) {
            Field[] fieldArray = new Field[]{Field.LATITUDE, Field.LONGITUDE, Field.ALTITUDE};
            _sharedLatLonAltFieldList = new FieldList(fieldArray);
        }
        return _sharedLatLonAltFieldList;
    }

    public String getFieldValue(Field field) {
        return this.getFieldValue(this._fieldList.getFieldIndex(field));
    }

    private String getFieldValue(int n) {
        if (this._fieldValues == null || n < 0 || n >= this._fieldValues.length) {
            return null;
        }
        return this._fieldValues[n];
    }

    public void setWaypointName(String string) {
        this.setRawFieldValue(Field.WAYPT_NAME, string);
        this.setModified(false);
        this._waypointName = string;
    }

    public void setFieldValue(Field field, String string, boolean bl) {
        this.setFieldValue(field, string, null, bl);
    }

    public void setFieldValue(Field field, String string, UnitSet unitSet, boolean bl) {
        boolean bl2;
        this.setRawFieldValue(field, string);
        if (field != Field.NEW_SEGMENT) {
            this.setModified(bl);
        }
        if ((bl2 = field == Field.ALTITUDE ? this._altitude == null || this._altitude.getUnit() == null : (field == Field.SPEED ? this._hSpeed == null || this._hSpeed.getUnit() == null : (field == Field.VERTICAL_SPEED ? this._vSpeed == null || this._vSpeed.getUnit() == null : false))) && unitSet == null && string != null && !string.equals("")) {
            throw new IllegalArgumentException("Units required to set field " + field.getName());
        }
        this.parseFields(field, unitSet == null ? null : unitSet.getDefaultOptions());
    }

    private void setRawFieldValue(Field field, String string) {
        if (field == null) {
            return;
        }
        int n = this._fieldList.getFieldIndex(field);
        if (n < 0) {
            if (string == null || string.equals("")) {
                return;
            }
            n = this._fieldList.addField(field);
        }
        if (n >= this._fieldValues.length) {
            this.resizeValueArray(n);
        }
        this._fieldValues[n] = string;
    }

    public void setModified(boolean bl) {
        this._modifyCount = !bl ? ++this._modifyCount : --this._modifyCount;
    }

    public FieldList getFieldList() {
        return this._fieldList;
    }

    public void setSegmentStart(boolean bl) {
        this.setFieldValue(Field.NEW_SEGMENT, bl ? "1" : null, false);
    }

    public Coordinate getLatitude() {
        return this._latitude;
    }

    public Coordinate getLongitude() {
        return this._longitude;
    }

    public boolean hasAltitude() {
        return this._altitude != null && this._altitude.isValid();
    }

    public Altitude getAltitude() {
        return this._altitude;
    }

    public boolean hasHSpeed() {
        return this._hSpeed != null && this._hSpeed.isValid();
    }

    public Speed getHSpeed() {
        return this._hSpeed;
    }

    public boolean hasVSpeed() {
        return this._vSpeed != null && this._vSpeed.isValid();
    }

    public Speed getVSpeed() {
        return this._vSpeed;
    }

    public boolean hasTimestamp() {
        return this._timestamp != null && this._timestamp.isValid();
    }

    public Timestamp getTimestamp() {
        return this._timestamp;
    }

    public String getWaypointName() {
        return this._waypointName;
    }

    public boolean getSegmentStart() {
        return this._startOfSegment;
    }

    public boolean isWaypoint() {
        return this._waypointName != null && !this._waypointName.equals("");
    }

    public boolean isModified() {
        return this._modifyCount > 0;
    }

    public boolean isDuplicate(DataPoint dataPoint) {
        if (dataPoint == null) {
            return false;
        }
        if (this._longitude == null || this._latitude == null || dataPoint._longitude == null || dataPoint._latitude == null) {
            return false;
        }
        if (this._photo != null) {
            return false;
        }
        if (!this._longitude.equals(dataPoint._longitude) || !this._latitude.equals(dataPoint._latitude)) {
            return false;
        }
        if (!this.isWaypoint()) {
            return !dataPoint.isWaypoint();
        }
        return dataPoint._waypointName != null && dataPoint._waypointName.equals(this._waypointName);
    }

    public void setAltitude(String string, Unit unit, boolean bl) {
        this._altitude = new Altitude(string, unit);
        this.setFieldValue(Field.ALTITUDE, string, bl);
        this.setModified(bl);
    }

    public void setAltitude(Altitude altitude) {
        this._altitude = new Altitude(altitude);
        this.setFieldValue(Field.ALTITUDE, this._altitude.getStringValue(null), false);
        this.setModified(false);
    }

    public void setPhoto(Photo photo) {
        this._photo = photo;
        ++this._modifyCount;
    }

    public Photo getPhoto() {
        return this._photo;
    }

    public void setAudio(AudioClip audioClip) {
        this._audio = audioClip;
        ++this._modifyCount;
    }

    public AudioClip getAudio() {
        return this._audio;
    }

    public boolean isValid() {
        return this._latitude != null && this._longitude != null;
    }

    public boolean hasMedia() {
        return this._photo != null || this._audio != null;
    }

    public String getMediaName() {
        String string = null;
        if (this._photo != null) {
            string = this._photo.getName();
        }
        if (this._audio != null) {
            string = string == null ? this._audio.getName() : String.valueOf(string) + ", " + this._audio.getName();
        }
        return string;
    }

    public static double calculateRadiansBetween(DataPoint dataPoint, DataPoint dataPoint2) {
        if (dataPoint == null || dataPoint2 == null) {
            return 0.0;
        }
        double d = dataPoint.getLatitude().getDouble();
        double d2 = dataPoint2.getLatitude().getDouble();
        double d3 = dataPoint.getLongitude().getDouble();
        double d4 = dataPoint2.getLongitude().getDouble();
        return Distance.calculateRadiansBetween(d, d3, d2, d4);
    }

    private void resizeValueArray(int n) {
        int n2 = n + 1;
        if (n2 > this._fieldValues.length) {
            String[] stringArray = new String[n2];
            System.arraycopy(this._fieldValues, 0, stringArray, 0, this._fieldValues.length);
            this._fieldValues = stringArray;
        }
    }

    public DataPoint clonePoint() {
        String[] stringArray = new String[this._fieldValues.length];
        System.arraycopy(this._fieldValues, 0, stringArray, 0, this._fieldValues.length);
        PointCreateOptions pointCreateOptions = new PointCreateOptions();
        if (this._altitude != null) {
            pointCreateOptions.setAltitudeUnits(this._altitude.getUnit());
        }
        DataPoint dataPoint = new DataPoint(stringArray, this._fieldList, pointCreateOptions);
        if (this.hasHSpeed()) {
            dataPoint.getHSpeed().copyFrom(this._hSpeed);
        }
        if (this.hasVSpeed()) {
            dataPoint.getVSpeed().copyFrom(this._vSpeed);
        }
        return dataPoint;
    }

    public void setSourceInfo(SourceInfo sourceInfo) {
        this._sourceInfo = sourceInfo;
    }

    public SourceInfo getSourceInfo() {
        return this._sourceInfo;
    }

    public void setOriginalIndex(int n) {
        this._originalIndex = n;
    }

    public int getOriginalIndex() {
        return this._originalIndex;
    }

    private static void removeQuotes(String[] stringArray) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = DataPoint.removeQuotes(stringArray[n]);
                ++n;
            }
        }
    }

    private static String removeQuotes(String string) {
        char c;
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n <= 1) {
            return string;
        }
        char c2 = string.charAt(0);
        if (c2 == (c = string.charAt(n - 1)) && (c2 == '\"' || c2 == '\'')) {
            return string.substring(1, n - 1);
        }
        return string;
    }

    public String toString() {
        return "[Lat=" + this.getLatitude().toString() + ", Lon=" + this.getLongitude().toString() + "]";
    }
}

