/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.visitors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.picocontainer.PicoException;
import org.picocontainer.PicoVisitor;

public abstract class AbstractPicoVisitor
implements PicoVisitor {
    private boolean traversal;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object traverse(final Object node) {
        this.traversal = true;
        Object retval = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return node.getClass().getMethod("accept", PicoVisitor.class);
                }
                catch (NoSuchMethodException e) {
                    return e;
                }
            }
        });
        try {
            if (retval instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)retval;
            }
            Method accept = (Method)retval;
            accept.invoke(node, this);
            Class<Void> clazz = Void.TYPE;
            return clazz;
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
        }
        finally {
            this.traversal = false;
        }
        throw new IllegalArgumentException(node.getClass().getName() + " is not a valid type for traversal");
    }

    protected void checkTraversal() {
        if (!this.traversal) {
            throw new PicoVisitorTraversalException(this);
        }
    }

    public static class PicoVisitorTraversalException
    extends PicoException {
        public PicoVisitorTraversalException(PicoVisitor visitor) {
            super("Traversal for PicoVisitor of type " + visitor.getClass().getName() + " must start with the visitor's traverse method");
        }
    }
}

