/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.indent;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.DBeaverNotifications;
import org.jkiss.dbeaver.ui.editors.sql.indent.SQLBlockCompletionInfo;
import org.jkiss.dbeaver.ui.editors.sql.indent.SQLBlockCompletions;
import org.jkiss.dbeaver.ui.editors.sql.indent.SQLBlockCompletionsCollection;
import org.jkiss.dbeaver.ui.editors.sql.indent.SQLHeuristicScanner;
import org.jkiss.dbeaver.ui.editors.sql.indent.SQLIndenter;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class SQLAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    private static final Log log = Log.getLog(SQLAutoIndentStrategy.class);
    static final SQLBlockCompletions DEFAULT_SQL_BLOCK_COMPLETIONS = new SQLBlockCompletionsCollection(){
        {
            this.registerCompletionPair("BEGIN", "END");
            this.registerCompletionPair("CASE", "END");
            this.registerCompletionPair("LOOP", "END", "LOOP");
            this.registerCompletionInfo("IF", new String[]{" THEN", SQLBlockCompletions.NEW_LINE_COMPLETION_PART, "\t", SQLBlockCompletions.NEW_LINE_COMPLETION_PART, "END IF", SQLBlockCompletions.NEW_LINE_COMPLETION_PART}, "END", "IF");
        }
    };
    private static final int MINIMUM_SOUCE_CODE_LENGTH = 10;
    private static final boolean KEYWORD_INDENT_ENABLED = false;
    private final String oneIndent = SQLIndenter.createIndent().toString();
    private String partitioning;
    private ISourceViewer sourceViewer;
    private SQLSyntaxManager syntaxManager;
    private String[] delimiters;

    public SQLAutoIndentStrategy(String partitioning, ISourceViewer sourceViewer, SQLSyntaxManager syntaxManager) {
        this.partitioning = partitioning;
        this.sourceViewer = sourceViewer;
        this.syntaxManager = syntaxManager;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (command.offset < 0) {
            return;
        }
        if (command.text != null && command.text.length() > 10) {
            if (this.syntaxManager.getPreferenceStore().getBoolean("SQLEditor.format.extractFromSource") && this.transformSourceCode(document, command)) {
                DBeaverNotifications.showNotification((String)"generic", (String)"SQL transformation (click to undo)", (String)"SQL query was extracted from the source code", (DBPMessageType)DBPMessageType.INFORMATION, () -> {
                    if (this.sourceViewer instanceof ITextOperationTarget) {
                        ((ITextOperationTarget)this.sourceViewer).doOperation(1);
                    }
                });
            }
        } else if (command.length == 0 && command.text != null) {
            boolean lineDelimiter = this.isLineDelimiter(document, command.text);
            boolean isKeywordCaseUpdated = false;
            try {
                String typeAtLine;
                boolean isPrevLetter = command.offset > 0 && Character.isJavaIdentifierPart(document.getChar(command.offset - 1));
                boolean isQuote = this.isIdentifierQuoteString(command.text);
                if (command.offset > 1 && isPrevLetter && !isQuote && (lineDelimiter || command.text.length() == 1 && !Character.isJavaIdentifierPart(command.text.charAt(0))) && this.syntaxManager.getPreferenceStore().getBoolean("SQLEditor.format.keywordCaseAuto") && "__dftl_partition_content_type".equals(typeAtLine = TextUtilities.getContentType((IDocument)document, (String)"___sql_partitioning", (int)(command.offset - 1), (boolean)true))) {
                    isKeywordCaseUpdated = this.updateKeywordCase(document, command);
                }
            }
            catch (BadLocationException e) {
                log.debug((Object)e);
            }
            if (lineDelimiter) {
                this.smartIndentAfterNewLine(document, command, isKeywordCaseUpdated);
            }
        }
    }

    private boolean isIdentifierQuoteString(String str) {
        String[][] quoteStrings = this.syntaxManager.getIdentifierQuoteStrings();
        if (quoteStrings != null) {
            for (String[] qs : quoteStrings) {
                if (!str.equals("'") && !str.equals(qs[0]) && !str.equals(qs[1])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean transformSourceCode(IDocument document, DocumentCommand command) {
        char ch;
        int i;
        String sourceCode = command.text;
        int quoteStart = -1;
        int quoteEnd = -1;
        for (i = 0; i < sourceCode.length(); ++i) {
            ch = sourceCode.charAt(i);
            if (ch == '\"') {
                quoteStart = i;
                break;
            }
            if (!Character.isUnicodeIdentifierPart(ch) && ch != '{' && ch != '<' && ch != '[') continue;
            return false;
        }
        for (i = sourceCode.length() - 1; i >= 0; --i) {
            ch = sourceCode.charAt(i);
            if (ch == '\"') {
                quoteEnd = i;
                break;
            }
            if (!Character.isUnicodeIdentifierPart(ch)) continue;
            return false;
        }
        if (quoteStart == -1 || quoteEnd == -1) {
            return false;
        }
        int wsCount = 0;
        for (int i2 = quoteStart + 1; i2 < quoteEnd; ++i2) {
            if (!Character.isWhitespace(sourceCode.charAt(i2))) continue;
            ++wsCount;
        }
        if (wsCount < 3) {
            return false;
        }
        StringBuilder result = new StringBuilder(sourceCode.length());
        int prevChar = 65535;
        char escapeChar = '\\';
        boolean inString = false;
        boolean inComment = false;
        CommentType commentType = CommentType.Unknown;
        for (int i3 = quoteStart; i3 < quoteEnd; ++i3) {
            char ch2;
            block36: {
                block34: {
                    block35: {
                        ch2 = sourceCode.charAt(i3);
                        if (!inString) break block34;
                        if (prevChar != escapeChar) break block35;
                        switch (ch2) {
                            case 'n': {
                                if (!this.endsWithLF(result, '\n')) {
                                    result.append("\n");
                                    break;
                                }
                                break block36;
                            }
                            case 'r': {
                                if (!this.endsWithLF(result, '\r')) {
                                    result.append("\r");
                                    break;
                                }
                                break block36;
                            }
                            case 't': {
                                result.append("\t");
                                break;
                            }
                            default: {
                                result.append(ch2);
                                break;
                            }
                        }
                        break block36;
                    }
                    switch (ch2) {
                        case '\"': {
                            inString = false;
                            break;
                        }
                        default: {
                            if (ch2 == escapeChar) break;
                            result.append(ch2);
                            break;
                        }
                    }
                    break block36;
                }
                if (inComment) {
                    if (commentType == CommentType.Unknown && prevChar == 47 && ch2 == '*') {
                        commentType = CommentType.Block;
                    } else if (commentType == CommentType.Unknown && prevChar == 47 && ch2 == '/') {
                        commentType = CommentType.EndOfLine;
                    } else if (commentType == CommentType.Block && prevChar == 42 && ch2 == '/') {
                        inComment = false;
                    } else if (commentType == CommentType.EndOfLine && ch2 == '\n') {
                        inComment = false;
                    }
                } else {
                    switch (ch2) {
                        case '/': {
                            inComment = true;
                            commentType = CommentType.Unknown;
                            break;
                        }
                        case '\"': {
                            inString = true;
                            break;
                        }
                        case '\n': 
                        case '\r': {
                            if (result.length() <= 0 || this.endsWithLF(result, '\n') || this.endsWithLF(result, '\r')) break;
                            result.append(ch2 == '\n' ? "\n" : "\r");
                        }
                    }
                }
            }
            prevChar = ch2;
        }
        try {
            document.replace(command.offset, command.length, command.text);
            document.replace(command.offset, command.text.length(), result.toString());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        command.caretOffset = command.offset + result.length();
        command.text = null;
        command.length = 0;
        command.doit = false;
        return true;
    }

    private boolean endsWithLF(StringBuilder result, char lfChar) {
        char lch;
        boolean endsWithLF = false;
        for (int k = result.length(); k > 0 && Character.isWhitespace(lch = result.charAt(k - 1)); --k) {
            if (lch != lfChar) continue;
            endsWithLF = true;
            break;
        }
        return endsWithLF;
    }

    private boolean updateKeywordCase(IDocument document, DocumentCommand command) throws BadLocationException {
        String fixedKeyword;
        char ch;
        int pos;
        String commandPrefix = this.syntaxManager.getControlCommandPrefix();
        for (pos = command.offset - 1; pos >= 0 && Character.isWhitespace(document.getChar(pos)); --pos) {
        }
        int endPos = pos + 1;
        while (pos >= 0 && (Character.isJavaIdentifierPart(ch = document.getChar(pos)) || commandPrefix != null && commandPrefix.indexOf(ch) != -1)) {
            --pos;
        }
        int startPos = pos + 1;
        String keyword = document.get(startPos, endPos - startPos);
        if (this.syntaxManager.getDialect().getKeywordType(keyword) == DBPKeywordType.KEYWORD && !(fixedKeyword = this.syntaxManager.getKeywordCase().transform(keyword)).equals(keyword)) {
            command.addCommand(startPos, endPos - startPos, fixedKeyword, null);
            command.doit = false;
            return true;
        }
        return false;
    }

    private void smartIndentAfterNewLine(@NotNull IDocument document, @NotNull DocumentCommand command, boolean isLastTokenCaseUpdated) {
        String indent;
        int docLength = document.getLength();
        if (docLength == 0) {
            return;
        }
        SQLHeuristicScanner scanner = new SQLHeuristicScanner(document, this.syntaxManager);
        SQLIndenter indenter = new SQLIndenter(document, this.syntaxManager, scanner);
        int previousToken = scanner.previousToken(command.offset - 1, -2);
        int previousTokenPos = scanner.getPosition();
        String lastTokenString = scanner.getLastToken();
        int nextToken = scanner.nextToken(command.offset, -2);
        SQLBlockCompletionInfo completion = this.isBlocksCompletionEnabled() ? DEFAULT_SQL_BLOCK_COMPLETIONS.findCompletionByHead(previousToken) : null;
        int prevPreviousToken = completion == null || completion.getHeadCancelTokenId() == null ? -1 : scanner.previousToken(previousTokenPos, -2);
        boolean autoCompletionSupported = completion != null && (completion.getHeadCancelTokenId() == null || completion.getHeadCancelTokenId() != prevPreviousToken);
        String beginIndentaion = "";
        if (autoCompletionSupported) {
            indent = indenter.computeIndentation(command.offset);
            beginIndentaion = indenter.getReferenceIndentation(command.offset);
        } else {
            indent = indenter.getReferenceIndentation(command.offset);
        }
        if (indent == null) {
            indent = "";
        }
        try {
            int p = command.offset == docLength ? command.offset - 1 : command.offset;
            int line = document.getLineOfOffset(p);
            StringBuilder buf = new StringBuilder(command.text + indent);
            IRegion reg = document.getLineInformation(line);
            int lineEnd = reg.getOffset() + reg.getLength();
            int contentStart = this.findEndOfWhiteSpace(document, command.offset, lineEnd);
            command.length = Math.max(contentStart - command.offset, 0);
            int start = reg.getOffset();
            ITypedRegion region = TextUtilities.getPartition((IDocument)document, (String)this.partitioning, (int)start, (boolean)true);
            if ("sql_multiline_comment".equals(region.getType())) {
                start = document.getLineInformationOfOffset(region.getOffset()).getOffset();
            }
            command.caretOffset = command.offset + buf.length();
            if (autoCompletionSupported && this.getBlockBalance(document, command.offset, completion) > 0 && this.getTokenCount(start, command.offset, scanner, previousToken) > 0) {
                buf.setLength(0);
                for (String part : completion.getCompletionParts()) {
                    if (part == SQLBlockCompletions.NEW_LINE_COMPLETION_PART) {
                        buf.append(SQLAutoIndentStrategy.getLineDelimiter(document));
                        buf.append(beginIndentaion);
                        continue;
                    }
                    if (part.equals("\t")) {
                        buf.append(this.oneIndent);
                        continue;
                    }
                    String token = isLastTokenCaseUpdated ? this.syntaxManager.getKeywordCase().transform(lastTokenString) : lastTokenString;
                    buf.append(SQLAutoIndentStrategy.adjustCase(token, part));
                }
                if (completion.getTailEndTokenId() != null) {
                    command.caretOffset = command.offset;
                }
            } else {
                command.caretOffset = command.offset + buf.length();
            }
            command.shiftsCaret = false;
            command.text = buf.toString();
        }
        catch (BadLocationException e) {
            log.error((Object)e);
        }
    }

    private static String adjustCase(String example, String value) {
        return SQLAutoIndentStrategy.isLowerCase(example) ? value.toLowerCase() : value.toUpperCase();
    }

    private static boolean isLowerCase(String value) {
        int l = value.length();
        for (int i = 0; i < l; ++i) {
            if (!Character.isUpperCase(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static String getLineDelimiter(IDocument document) {
        try {
            if (document.getNumberOfLines() > 1) {
                return document.getLineDelimiter(0);
            }
        }
        catch (BadLocationException e) {
            log.error((Object)e);
        }
        return GeneralUtils.getDefaultLineSeparator();
    }

    private boolean isLineDelimiter(IDocument document, String text) {
        if (this.delimiters == null) {
            this.delimiters = document.getLegalLineDelimiters();
        }
        return this.delimiters != null && TextUtilities.equals((String[])this.delimiters, (String)text) > -1;
    }

    private boolean isBlocksCompletionEnabled() {
        return DBWorkbench.getPlatform().getPreferenceStore().getBoolean("SQLEditor.closeBlocks");
    }

    private int getTokenCount(int startOffset, int endOffset, SQLHeuristicScanner scanner, int token) {
        int tokenCount = 0;
        while (startOffset < endOffset) {
            int nextToken = scanner.nextToken(startOffset, endOffset);
            int position = scanner.getPosition();
            if (nextToken != -1 && nextToken == token) {
                ++tokenCount;
            }
            startOffset = position;
        }
        return tokenCount;
    }

    private int getBlockBalance(IDocument document, int offset, SQLBlockCompletionInfo blockInfo) {
        if (offset < 1) {
            return -1;
        }
        if (offset >= document.getLength()) {
            return 1;
        }
        int begin = offset;
        int end = offset;
        SQLHeuristicScanner scanner = new SQLHeuristicScanner(document, this.syntaxManager);
        do {
            begin = scanner.findOpeningPeer(begin, blockInfo);
            end = scanner.findClosingPeer(end, blockInfo);
            if (begin == -1 && end == -1) {
                return 0;
            }
            if (begin != -1) continue;
            return -1;
        } while (end != -1);
        return 1;
    }

    private static enum CommentType {
        Unknown,
        Block,
        EndOfLine;

    }
}

