﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/quicksight/QuickSight_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace QuickSight {
namespace Model {
class GetSessionEmbedUrlResult {
 public:
  AWS_QUICKSIGHT_API GetSessionEmbedUrlResult() = default;
  AWS_QUICKSIGHT_API GetSessionEmbedUrlResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_QUICKSIGHT_API GetSessionEmbedUrlResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A single-use URL that you can put into your server-side web page to embed
   * your Quick Suite session. This URL is valid for 5 minutes. The API operation
   * provides the URL with an <code>auth_code</code> value that enables one (and only
   * one) sign-on to a user session that is valid for 10 hours. </p>
   */
  inline const Aws::String& GetEmbedUrl() const { return m_embedUrl; }
  template <typename EmbedUrlT = Aws::String>
  void SetEmbedUrl(EmbedUrlT&& value) {
    m_embedUrlHasBeenSet = true;
    m_embedUrl = std::forward<EmbedUrlT>(value);
  }
  template <typename EmbedUrlT = Aws::String>
  GetSessionEmbedUrlResult& WithEmbedUrl(EmbedUrlT&& value) {
    SetEmbedUrl(std::forward<EmbedUrlT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The HTTP status of the request.</p>
   */
  inline int GetStatus() const { return m_status; }
  inline void SetStatus(int value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline GetSessionEmbedUrlResult& WithStatus(int value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetSessionEmbedUrlResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_embedUrl;

  int m_status{0};

  Aws::String m_requestId;
  bool m_embedUrlHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace QuickSight
}  // namespace Aws
