/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.entity.OWLEntityCreationSet;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.util.OWLEntitySetProvider;

public abstract class OWLObjectHierarchyCreator<E extends OWLEntity> {
    private OWLEditorKit editorKit;
    private OWLEntitySetProvider<E> entitySetProvider;
    private OWLObjectHierarchyProvider<E> hierarchyProvider;

    protected OWLObjectHierarchyCreator(OWLEditorKit editorKit, OWLEntitySetProvider<E> entitySetProvider, OWLObjectHierarchyProvider<E> hierarchyProvider) {
        this.editorKit = editorKit;
        this.entitySetProvider = entitySetProvider;
        this.hierarchyProvider = hierarchyProvider;
    }

    public abstract OWLEntityCreationSet<E> createEntity();

    public void createNewEntity() {
        OWLEntityCreationSet<E> creationSet = this.createEntity();
        this.editorKit.getModelManager().applyChanges(creationSet.getOntologyChanges());
    }

    public void createChildEntity() {
        OWLEntityCreationSet<E> creationSet = this.createEntity();
        ArrayList changes = new ArrayList();
        changes.addAll(changes);
        changes.addAll(this.createChild(this.entitySetProvider.getEntities(), creationSet.getOWLEntity()));
        this.editorKit.getModelManager().applyChanges(changes);
    }

    protected abstract List<OWLOntologyChange> createChild(Set<E> var1, E var2);

    protected abstract List<OWLOntologyChange> createSibling(Set<E> var1, E var2);
}

