/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.store.rca.hot_node;

import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.opensearch.performanceanalyzer.rca.store.rca.hot_node.ThreadMetric;

public class ThreadMetricsSlidingWindow {
    private final Map<String, Deque<ThreadMetric>> metricsByThreadName = new HashMap<String, Deque<ThreadMetric>>();
    private final Map<String, Double> metricSumMap = new HashMap<String, Double>();
    private static final long SLIDING_WINDOW_SIZE_IN_SECONDS = 60L;

    public void next(long timestamp, List<ThreadMetric> threadMetricList) {
        HashSet<String> newThreadNames = new HashSet<String>();
        for (ThreadMetric threadMetric : threadMetricList) {
            LinkedList<ThreadMetric> windowDeque;
            if (this.metricsByThreadName.containsKey(threadMetric.getName())) {
                windowDeque = this.metricsByThreadName.get(threadMetric.getName());
                this.pruneExpiredEntries(threadMetric.getTimeStamp(), windowDeque);
            } else {
                windowDeque = new LinkedList();
                this.metricsByThreadName.put(threadMetric.getName(), windowDeque);
            }
            windowDeque.addFirst(threadMetric);
            this.addValue(threadMetric);
            newThreadNames.add(threadMetric.getName());
        }
        for (Map.Entry entry : this.metricsByThreadName.entrySet()) {
            if (newThreadNames.contains(entry.getKey())) continue;
            this.pruneExpiredEntries(timestamp, (Deque)entry.getValue());
        }
        this.metricsByThreadName.entrySet().removeIf(e -> ((Deque)e.getValue()).size() == 0);
    }

    private void pruneExpiredEntries(long endTimeStamp, Deque<ThreadMetric> windowDeque) {
        while (!windowDeque.isEmpty() && TimeUnit.MILLISECONDS.toSeconds(endTimeStamp - windowDeque.peekLast().getTimeStamp()) > 60L) {
            ThreadMetric prunedData = windowDeque.pollLast();
            if (prunedData == null) continue;
            this.removeValue(prunedData);
        }
    }

    private void removeValue(ThreadMetric prunedData) {
        this.updateValue(prunedData, false);
    }

    private void addValue(ThreadMetric prunedData) {
        this.updateValue(prunedData, true);
    }

    private void updateValue(ThreadMetric tm, boolean add) {
        String threadName = tm.getName();
        if (this.metricSumMap.containsKey(threadName)) {
            double sign = add ? 1.0 : -1.0;
            double newVal = this.metricSumMap.get(threadName) + sign * tm.getValue();
            if (newVal == 0.0) {
                this.metricSumMap.remove(threadName);
            } else {
                this.metricSumMap.put(threadName, newVal);
            }
        } else if (add) {
            this.metricSumMap.put(threadName, tm.getValue());
        }
    }

    public int getCountExceedingThreshold(double threshold) {
        return (int)this.metricSumMap.values().stream().filter(val -> val > threshold).count();
    }

    public double getMaxSum() {
        return this.metricSumMap.size() > 0 ? Collections.max(this.metricSumMap.values()) : 0.0;
    }
}

