/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.math.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import org.tribuo.math.util.VectorNormalizer;
import org.tribuo.util.onnx.ONNXContext;
import org.tribuo.util.onnx.ONNXInitializer;
import org.tribuo.util.onnx.ONNXNode;
import org.tribuo.util.onnx.ONNXOperators;
import org.tribuo.util.onnx.ONNXRef;

public class Normalizer
implements VectorNormalizer,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public double[] normalize(double[] input) {
        double[] output = Arrays.copyOf(input, input.length);
        this.normalizeInPlace(output);
        return output;
    }

    @Override
    public void normalizeInPlace(double[] input) {
        int i;
        double min = Double.MAX_VALUE;
        for (int i2 = 0; i2 < input.length; ++i2) {
            if (!(min > input[i2])) continue;
            min = input[i2];
        }
        min -= 0.01;
        double sum = 0.0;
        for (i = 0; i < input.length; ++i) {
            int n = i;
            input[n] = input[n] - min;
            sum += input[i];
        }
        i = 0;
        while (i < input.length) {
            int n = i++;
            input[n] = input[n] / sum;
        }
    }

    @Override
    public ONNXNode exportNormalizer(ONNXNode input) {
        ONNXContext onnx = input.onnxContext();
        ONNXInitializer sumAxes = onnx.array("sum_axes", new long[]{1L});
        ONNXNode min = input.apply(ONNXOperators.REDUCE_MIN, Collections.singletonMap("axes", new int[]{1}));
        ONNXNode sub = input.apply(ONNXOperators.SUB, (ONNXRef)min);
        ONNXNode sum = sub.apply(ONNXOperators.REDUCE_SUM, (ONNXRef)sumAxes);
        return sub.apply(ONNXOperators.DIV, (ONNXRef)sum);
    }
}

