"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class DSLFacet {
  constructor(client) {
    this.client = client;

    _defineProperty(this, "fetch", async (request, format, responseFormat) => {
      const res = {
        success: false,
        data: {}
      };

      try {
        const params = {
          query: JSON.stringify(request.body)
        };
        const queryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        const dslDataSource = queryRes;
        res['success'] = true;
        res['data'] = dslDataSource;
      } catch (err) {
        console.error(err);
        res['data'] = err.body;
      }

      return res;
    });

    _defineProperty(this, "describeQuery", async request => {
      return this.fetch(request, 'dsl.dslQuery', 'json');
    });

    this.client = client;
  }

}

exports.default = DSLFacet;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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