"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PPLQueryParser = void 0;

var _ppl_syntax_parser = require("../antlr/ppl_syntax_parser");

var _stats_ast_builder = require("../ast/builder/stats_ast_builder");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class PPLQueryParser {
  constructor() {
    _defineProperty(this, "parser", null);

    _defineProperty(this, "visitor", null);

    _defineProperty(this, "rawQuery", '');
  }

  parse(pplQuery) {
    this.rawQuery = pplQuery;
    this.parser = new _ppl_syntax_parser.PPLSyntaxParser().parse(this.rawQuery);
    return this;
  }

  getStats() {
    this.visitor = new _stats_ast_builder.StatsAstBuilder();
    return this.visitor.visitRoot(this.parser.root()).getTokens();
  }

}

exports.PPLQueryParser = PPLQueryParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInBwbF9xdWVyeV9wYXJzZXIudHMiXSwibmFtZXMiOlsiUFBMUXVlcnlQYXJzZXIiLCJwYXJzZSIsInBwbFF1ZXJ5IiwicmF3UXVlcnkiLCJwYXJzZXIiLCJQUExTeW50YXhQYXJzZXIiLCJnZXRTdGF0cyIsInZpc2l0b3IiLCJTdGF0c0FzdEJ1aWxkZXIiLCJ2aXNpdFJvb3QiLCJyb290IiwiZ2V0VG9rZW5zIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBS0E7O0FBRUE7Ozs7QUFFTyxNQUFNQSxjQUFOLENBQXFCO0FBQUE7QUFBQSxvQ0FDVyxJQURYOztBQUFBLHFDQUVYLElBRlc7O0FBQUEsc0NBR1AsRUFITztBQUFBOztBQUsxQkMsRUFBQUEsS0FBSyxDQUFDQyxRQUFELEVBQW1CO0FBQ3RCLFNBQUtDLFFBQUwsR0FBZ0JELFFBQWhCO0FBQ0EsU0FBS0UsTUFBTCxHQUFjLElBQUlDLGtDQUFKLEdBQXNCSixLQUF0QixDQUE0QixLQUFLRSxRQUFqQyxDQUFkO0FBQ0EsV0FBTyxJQUFQO0FBQ0Q7O0FBRURHLEVBQUFBLFFBQVEsR0FBRztBQUNULFNBQUtDLE9BQUwsR0FBZSxJQUFJQyxrQ0FBSixFQUFmO0FBQ0EsV0FBTyxLQUFLRCxPQUFMLENBQWFFLFNBQWIsQ0FBdUIsS0FBS0wsTUFBTCxDQUFhTSxJQUFiLEVBQXZCLEVBQTRDQyxTQUE1QyxFQUFQO0FBQ0Q7O0FBZHlCIiwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQgeyBQUExTeW50YXhQYXJzZXIgfSBmcm9tICcuLi9hbnRsci9wcGxfc3ludGF4X3BhcnNlcic7XG5pbXBvcnQgeyBPcGVuU2VhcmNoUFBMUGFyc2VyIH0gZnJvbSAnLi4vYW50bHIvb3V0cHV0L09wZW5TZWFyY2hQUExQYXJzZXInO1xuaW1wb3J0IHsgU3RhdHNBc3RCdWlsZGVyIH0gZnJvbSAnLi4vYXN0L2J1aWxkZXIvc3RhdHNfYXN0X2J1aWxkZXInO1xuXG5leHBvcnQgY2xhc3MgUFBMUXVlcnlQYXJzZXIge1xuICBwYXJzZXI6IE9wZW5TZWFyY2hQUExQYXJzZXIgfCBudWxsID0gbnVsbDtcbiAgdmlzaXRvcjogYW55ID0gbnVsbDtcbiAgcmF3UXVlcnk6IHN0cmluZyA9ICcnO1xuXG4gIHBhcnNlKHBwbFF1ZXJ5OiBzdHJpbmcpIHtcbiAgICB0aGlzLnJhd1F1ZXJ5ID0gcHBsUXVlcnk7XG4gICAgdGhpcy5wYXJzZXIgPSBuZXcgUFBMU3ludGF4UGFyc2VyKCkucGFyc2UodGhpcy5yYXdRdWVyeSk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICBnZXRTdGF0cygpIHtcbiAgICB0aGlzLnZpc2l0b3IgPSBuZXcgU3RhdHNBc3RCdWlsZGVyKCk7XG4gICAgcmV0dXJuIHRoaXMudmlzaXRvci52aXNpdFJvb3QodGhpcy5wYXJzZXIhLnJvb3QoKSkuZ2V0VG9rZW5zKCk7XG4gIH1cbn1cbiJdfQ==