/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_da extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arabisk";
        final String metaValue_hy = "armensk";
        final String metaValue_ban = "balinesisk";
        final String metaValue_bn = "bengali";
        final String metaValue_zbl = "blissymboler";
        final String metaValue_bug = "buginesisk";
        final String metaValue_ccp = "chakma";
        final String metaValue_chr = "cherokee";
        final String metaValue_cop = "koptisk";
        final String metaValue_ka = "georgisk";
        final String metaValue_got = "gotisk";
        final String metaValue_el = "gr\u00e6sk";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "hebraisk";
        final String metaValue_jv = "javanesisk";
        final String metaValue_ja = "japansk";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "koreansk";
        final String metaValue_kpe = "kpelle";
        final String metaValue_lo = "lao";
        final String metaValue_men = "mende";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongolsk";
        final String metaValue_my = "burmesisk";
        final String metaValue_or = "oriya";
        final String metaValue_pal = "pahlavi";
        final String metaValue_phn = "f\u00f8nikisk";
        final String metaValue_si = "singalesisk";
        final String metaValue_su = "sundanesisk";
        final String metaValue_syr = "syrisk";
        final String metaValue_te = "telugu";
        final String metaValue_tl = "tagalog";
        final String metaValue_bo = "tibetansk";
        final String metaValue_vai = "vai";
        final String metaValue_peo = "oldpersisk";
        final String metaValue_ssy = "saho";
        final Object[][] data = new Object[][] {
            { "001", "Verden" },
            { "002", "Afrika" },
            { "003", "Nordamerika" },
            { "005", "Sydamerika" },
            { "009", "Oceanien" },
            { "011", "Vestafrika" },
            { "013", "Mellemamerika" },
            { "014", "\u00d8stafrika" },
            { "015", "Nordafrika" },
            { "017", "Centralafrika" },
            { "018", "Det sydlige Afrika" },
            { "019", "Nord-, Mellem- og Sydamerika" },
            { "021", "Det nordlige Amerika" },
            { "029", "Caribien" },
            { "030", "\u00d8stasien" },
            { "034", "Sydasien" },
            { "035", "Syd\u00f8stasien" },
            { "039", "Sydeuropa" },
            { "053", "Australasien" },
            { "054", "Melanesien" },
            { "057", "Mikronesiske omr\u00e5de" },
            { "061", "Polynesien" },
            { "142", "Asien" },
            { "143", "Centralasien" },
            { "145", "Vestasien" },
            { "150", "Europa" },
            { "151", "\u00d8steuropa" },
            { "154", "Nordeuropa" },
            { "155", "Vesteuropa" },
            { "202", "Subsaharisk Afrika" },
            { "419", "Latinamerika" },
            { "AC", "Ascension\u00f8en" },
            { "AD", "Andorra" },
            { "AE", "De Forenede Arabiske Emirater" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua og Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albanien" },
            { "AM", "Armenien" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentina" },
            { "AS", "Amerikansk Samoa" },
            { "AT", "\u00d8strig" },
            { "AU", "Australien" },
            { "AW", "Aruba" },
            { "AX", "\u00c5land" },
            { "AZ", "Aserbajdsjan" },
            { "BA", "Bosnien-Hercegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgien" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarien" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "De tidligere Nederlandske Antiller" },
            { "BR", "Brasilien" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet\u00f8en" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Canada" },
            { "CC", "Cocos\u00f8erne" },
            { "CD", "Congo-Kinshasa" },
            { "CF", "Den Centralafrikanske Republik" },
            { "CG", "Congo-Brazzaville" },
            { "CH", "Schweiz" },
            { "CI", "Elfenbenskysten" },
            { "CK", "Cook\u00f8erne" },
            { "CL", "Chile" },
            { "CM", "Cameroun" },
            { "CN", "Kina" },
            { "CO", "Colombia" },
            { "CP", "Clipperton\u00f8en" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Kap Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Jule\u00f8en" },
            { "CY", "Cypern" },
            { "CZ", "Tjekkiet" },
            { "DE", "Tyskland" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Danmark" },
            { "DM", "Dominica" },
            { "DO", "Den Dominikanske Republik" },
            { "DZ", "Algeriet" },
            { "EA", "Ceuta og Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estland" },
            { "EG", "Egypten" },
            { "EH", "Vestsahara" },
            { "ER", "Eritrea" },
            { "ES", "Spanien" },
            { "ET", "Etiopien" },
            { "EU", "Den Europ\u00e6iske Union" },
            { "EZ", "eurozonen" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Falklands\u00f8erne" },
            { "FM", "Mikronesien" },
            { "FO", "F\u00e6r\u00f8erne" },
            { "FR", "Frankrig" },
            { "GA", "Gabon" },
            { "GB", "Storbritannien" },
            { "GD", "Grenada" },
            { "GE", "Georgien" },
            { "GF", "Fransk Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Gr\u00f8nland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "\u00c6kvatorialguinea" },
            { "GR", "Gr\u00e6kenland" },
            { "GS", "South Georgia og De Sydlige Sandwich\u00f8er" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "SAR Hongkong" },
            { "HM", "Heard Island og McDonald Islands" },
            { "HN", "Honduras" },
            { "HR", "Kroatien" },
            { "HT", "Haiti" },
            { "HU", "Ungarn" },
            { "IC", "Kanariske \u00f8er" },
            { "ID", "Indonesien" },
            { "IE", "Irland" },
            { "IL", "Israel" },
            { "IM", "Isle of Man" },
            { "IN", "Indien" },
            { "IO", "Det Britiske Territorium i Det Indiske Ocean" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italien" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "KE", "Kenya" },
            { "KG", "Kirgisistan" },
            { "KH", "Cambodja" },
            { "KI", "Kiribati" },
            { "KM", "Comorerne" },
            { "KN", "Saint Kitts og Nevis" },
            { "KP", "Nordkorea" },
            { "KR", "Sydkorea" },
            { "KW", "Kuwait" },
            { "KY", "Cayman\u00f8erne" },
            { "KZ", "Kasakhstan" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Litauen" },
            { "LU", "Luxembourg" },
            { "LV", "Letland" },
            { "LY", "Libyen" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshall\u00f8erne" },
            { "MK", "Nordmakedonien" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongoliet" },
            { "MO", "SAR Macao" },
            { "MP", "Nordmarianerne" },
            { "MQ", "Martinique" },
            { "MR", "Mauretanien" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldiverne" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "NC", "Ny Kaledonien" },
            { "NE", "Niger" },
            { "NF", "Norfolk Island" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Nederlandene" },
            { "NO", "Norge" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "New Zealand" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Fransk Polynesien" },
            { "PG", "Papua Ny Guinea" },
            { "PH", "Filippinerne" },
            { "PK", "Pakistan" },
            { "PL", "Polen" },
            { "PM", "Saint Pierre og Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "De pal\u00e6stinensiske omr\u00e5der" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Ydre Oceanien" },
            { "RE", "R\u00e9union" },
            { "RO", "Rum\u00e6nien" },
            { "RS", "Serbien" },
            { "RU", "Rusland" },
            { "RW", "Rwanda" },
            { "SA", "Saudi-Arabien" },
            { "SB", "Salomon\u00f8erne" },
            { "SC", "Seychellerne" },
            { "SD", "Sudan" },
            { "SE", "Sverige" },
            { "SG", "Singapore" },
            { "SH", "St. Helena" },
            { "SI", "Slovenien" },
            { "SJ", "Svalbard og Jan Mayen" },
            { "SK", "Slovakiet" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Surinam" },
            { "SS", "Sydsudan" },
            { "ST", "S\u00e3o Tom\u00e9 og Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syrien" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks- og Caicos\u00f8erne" },
            { "TD", "Tchad" },
            { "TF", "De Franske Besiddelser i Det Sydlige Indiske Ocean og Antarktis" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tadsjikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunesien" },
            { "TO", "Tonga" },
            { "TR", "Tyrkiet" },
            { "TT", "Trinidad og Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Ukraine" },
            { "UG", "Uganda" },
            { "UM", "Amerikanske overs\u00f8iske \u00f8er" },
            { "UN", "De Forenede Nationer" },
            { "US", "USA" },
            { "UY", "Uruguay" },
            { "UZ", "Usbekistan" },
            { "VA", "Vatikanstaten" },
            { "VC", "Saint Vincent og Grenadinerne" },
            { "VE", "Venezuela" },
            { "VG", "De Britiske Jomfru\u00f8er" },
            { "VI", "De Amerikanske Jomfru\u00f8er" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis og Futuna" },
            { "WS", "Samoa" },
            { "XA", "pseudo-accenter" },
            { "XB", "pseudo-bidi" },
            { "XK", "Kosovo" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "Sydafrika" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Ukendt omr\u00e5de" },
            { "aa", "afar" },
            { "ab", "abkhasisk" },
            { "ae", "avestan" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amharisk" },
            { "an", "aragonesisk" },
            { "ar", metaValue_ar },
            { "as", "assamesisk" },
            { "av", "avarisk" },
            { "ay", "aymara" },
            { "az", "aserbajdsjansk" },
            { "ba", "bashkir" },
            { "be", "belarusisk" },
            { "bg", "bulgarsk" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "bretonsk" },
            { "bs", "bosnisk" },
            { "ca", "catalansk" },
            { "ce", "tjetjensk" },
            { "ch", "chamorro" },
            { "co", "korsikansk" },
            { "cr", "cree" },
            { "cs", "tjekkisk" },
            { "cu", "kirkeslavisk" },
            { "cv", "chuvash" },
            { "cy", "walisisk" },
            { "da", "dansk" },
            { "de", "tysk" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", metaValue_el },
            { "en", "engelsk" },
            { "eo", "esperanto" },
            { "es", "spansk" },
            { "et", "estisk" },
            { "eu", "baskisk" },
            { "fa", "persisk" },
            { "ff", "fulah" },
            { "fi", "finsk" },
            { "fj", "fijiansk" },
            { "fo", "f\u00e6r\u00f8sk" },
            { "fr", "fransk" },
            { "fy", "vestfrisisk" },
            { "ga", "irsk" },
            { "gd", "skotsk g\u00e6lisk" },
            { "gl", "galicisk" },
            { "gn", "guarani" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "ho", "hirimotu" },
            { "hr", "kroatisk" },
            { "ht", "haitisk" },
            { "hu", "ungarsk" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonesisk" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "sichuan yi" },
            { "ik", "inupiaq" },
            { "io", "ido" },
            { "is", "islandsk" },
            { "it", "italiensk" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "kongo" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kasakhisk" },
            { "kl", "gr\u00f8nlandsk" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "kashmiri" },
            { "ku", "kurdisk" },
            { "kv", "komi" },
            { "kw", "cornisk" },
            { "ky", "kirgisisk" },
            { "la", "latin" },
            { "lb", "luxembourgsk" },
            { "lg", "ganda" },
            { "li", "limburgsk" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "litauisk" },
            { "lu", "luba-Katanga" },
            { "lv", "lettisk" },
            { "mg", "malagassisk" },
            { "mh", "marshallese" },
            { "mi", "maori" },
            { "mk", "makedonsk" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathisk" },
            { "ms", "malajisk" },
            { "mt", "maltesisk" },
            { "my", metaValue_my },
            { "na", "nauru" },
            { "nb", "bokm\u00e5l" },
            { "nd", "nordndebele" },
            { "ne", "nepalesisk" },
            { "ng", "ndonga" },
            { "nl", "nederlandsk" },
            { "nn", "nynorsk" },
            { "no", "norsk" },
            { "nr", "sydndebele" },
            { "nv", "navajo" },
            { "ny", "nyanja" },
            { "oc", "occitansk" },
            { "oj", "ojibwa" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "ossetisk" },
            { "pa", "punjabisk" },
            { "pi", "pali" },
            { "pl", "polsk" },
            { "ps", "pashto" },
            { "pt", "portugisisk" },
            { "qu", "quechua" },
            { "rm", "r\u00e6toromansk" },
            { "rn", "rundi" },
            { "ro", "rum\u00e6nsk" },
            { "ru", "russisk" },
            { "rw", "kinyarwanda" },
            { "sa", "sanskrit" },
            { "sc", "sardinsk" },
            { "sd", "sindhi" },
            { "se", "nordsamisk" },
            { "sg", "sango" },
            { "sh", "serbokroatisk" },
            { "si", metaValue_si },
            { "sk", "slovakisk" },
            { "sl", "slovensk" },
            { "sm", "samoansk" },
            { "sn", "shona" },
            { "so", "somali" },
            { "sq", "albansk" },
            { "sr", "serbisk" },
            { "ss", "swati" },
            { "st", "sydsotho" },
            { "su", metaValue_su },
            { "sv", "svensk" },
            { "sw", "swahili" },
            { "ta", "tamil" },
            { "te", metaValue_te },
            { "tg", "tadsjikisk" },
            { "th", "thai" },
            { "ti", "tigrinya" },
            { "tk", "turkmensk" },
            { "tl", metaValue_tl },
            { "tn", "tswana" },
            { "to", "tongansk" },
            { "tr", "tyrkisk" },
            { "ts", "tsonga" },
            { "tt", "tatarisk" },
            { "tw", "twi" },
            { "ty", "tahitiansk" },
            { "ug", "uygurisk" },
            { "uk", "ukrainsk" },
            { "ur", "urdu" },
            { "uz", "usbekisk" },
            { "ve", "venda" },
            { "vi", "vietnamesisk" },
            { "vo", "volapyk" },
            { "wa", "vallonsk" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "jiddisch" },
            { "yo", "yoruba" },
            { "za", "zhuang" },
            { "zh", "kinesisk" },
            { "zu", "zulu" },
            { "ace", "achinesisk" },
            { "ach", "acoli" },
            { "ada", "adangme" },
            { "ady", "adyghe" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ainu" },
            { "akk", "akkadisk" },
            { "ale", "aleutisk" },
            { "alt", "sydaltaisk" },
            { "ang", "oldengelsk" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "aram\u00e6isk" },
            { "arn", "mapudungun" },
            { "arp", "arapaho" },
            { "ars", "Najd-arabisk" },
            { "arw", "arawak" },
            { "asa", "asu" },
            { "ast", "asturisk" },
            { "atj", "atikamekw" },
            { "awa", "awadhi" },
            { "bal", "baluchi" },
            { "ban", metaValue_ban },
            { "bas", "basaa" },
            { "bax", "bamun" },
            { "bbj", "ghomala" },
            { "bej", "beja" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bfd", "bafut" },
            { "bgn", "vestbaluchi" },
            { "bho", "bhojpuri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bkm", "kom" },
            { "bla", "siksika" },
            { "bra", "braj" },
            { "brx", "bodo" },
            { "bss", "bakossi" },
            { "bua", "buriatisk" },
            { "bug", metaValue_bug },
            { "bum", "bulu" },
            { "byn", "blin" },
            { "byv", "medumba" },
            { "cad", "caddo" },
            { "car", "caribisk" },
            { "cay", "cayuga" },
            { "cch", "atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "cebuano" },
            { "cgg", "chiga" },
            { "chb", "chibcha" },
            { "chg", "chagatai" },
            { "chk", "chuukese" },
            { "chm", "mari" },
            { "chn", "chinook" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "cheyenne" },
            { "ckb", "sorani" },
            { "clc", "chilcotin" },
            { "cop", metaValue_cop },
            { "crg", "michif" },
            { "crh", "krimtatarisk" },
            { "crj", "syd\u00f8stcree" },
            { "crk", "plains cree" },
            { "crl", "nord\u00f8stcree" },
            { "crm", "Moose-cree" },
            { "crr", "carolina algonquisk" },
            { "crs", "seselwa (kreol-fransk)" },
            { "csb", "kasjubisk" },
            { "csw", "swampy cree" },
            { "dak", "dakota" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "del", "delaware" },
            { "den", "athapaskisk" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "nedersorbisk" },
            { "dua", "duala" },
            { "dum", "middelhollandsk" },
            { "dyo", "jola-fonyi" },
            { "dyu", "dyula" },
            { "dzg", "dazaga" },
            { "ebu", "kiembu" },
            { "efi", "efik" },
            { "egy", "oldegyptisk" },
            { "eka", "ekajuk" },
            { "elx", "elamitisk" },
            { "enm", "middelengelsk" },
            { "ewo", "ewondo" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filippinsk" },
            { "fon", "fon" },
            { "frc", "cajunfransk" },
            { "frm", "middelfransk" },
            { "fro", "oldfransk" },
            { "frr", "nordfrisisk" },
            { "frs", "\u00f8stfrisisk" },
            { "fur", "friulisk" },
            { "gaa", "ga" },
            { "gag", "gagauzisk" },
            { "gan", "gan-kinesisk" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gez", "geez" },
            { "gil", "gilbertesisk" },
            { "gmh", "middelh\u00f8jtysk" },
            { "goh", "oldh\u00f8jtysk" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "grb", "grebo" },
            { "grc", "oldgr\u00e6sk" },
            { "gsw", "schweizertysk" },
            { "guz", "gusii" },
            { "gwi", "gwichin" },
            { "hai", "haida" },
            { "hak", "hakka-kinesisk" },
            { "haw", "hawaiiansk" },
            { "hax", "sydhaida" },
            { "hil", "hiligaynon" },
            { "hit", "hittitisk" },
            { "hmn", "hmong" },
            { "hsb", "\u00f8vresorbisk" },
            { "hsn", "xiang-kinesisk" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "vestcanadisk inuktitut" },
            { "ilo", "iloko" },
            { "inh", "ingush" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "jpr", "j\u00f8disk-persisk" },
            { "jrb", "j\u00f8disk-arabisk" },
            { "kaa", "karakalpakisk" },
            { "kab", "kabylisk" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", "kawi" },
            { "kbd", "kabardian" },
            { "kbl", "kanembu" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "kapverdisk" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "khasi" },
            { "kho", "khotanesisk" },
            { "khq", "koyra-chiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "koi", "komi-permjakisk" },
            { "kok", "konkani" },
            { "kos", "kosraean" },
            { "kpe", metaValue_kpe },
            { "krc", "karatjai-balkar" },
            { "krl", "karelsk" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "k\u00f6lsch" },
            { "kum", "kymyk" },
            { "kut", "kutenaj" },
            { "kwk", "kwak\u02bcwala" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezghian" },
            { "lil", "lillooet" },
            { "lkt", "lakota" },
            { "lol", "mongo" },
            { "lou", "Louisiana-kreolsk" },
            { "loz", "lozi" },
            { "lrc", "nordluri" },
            { "lsm", "saamia" },
            { "lua", "luba-Lulua" },
            { "lui", "luiseno" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "lushai" },
            { "luy", "luyana" },
            { "mad", "madurese" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makasar" },
            { "man", "mandingo" },
            { "mas", "masai" },
            { "mde", "maba" },
            { "mdf", "moksha" },
            { "mdr", "mandar" },
            { "men", metaValue_men },
            { "mer", "meru" },
            { "mfe", "morisyen" },
            { "mga", "middelirsk" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mnc", "manchu" },
            { "mni", "manipuri" },
            { "moe", "innu-aimun" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mua", "mundang" },
            { "mul", "flere sprog" },
            { "mus", "creek" },
            { "mwl", "mirandesisk" },
            { "mwr", "marwari" },
            { "mye", "myene" },
            { "myv", "erzya" },
            { "mzn", "mazenisk" },
            { "nan", "min-kinesisk" },
            { "nap", "napolitansk" },
            { "naq", "nama" },
            { "nds", "nedertysk" },
            { "new", "newari" },
            { "nia", "nias" },
            { "niu", "niueansk" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogai" },
            { "non", "oldislandsk" },
            { "nqo", "n-ko" },
            { "nso", "nordsotho" },
            { "nus", "nuer" },
            { "nwc", "klassisk newarisk" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro-sprog" },
            { "nzi", "nzima" },
            { "ojb", "nordvestojibwa" },
            { "ojc", "centralojibwa" },
            { "ojs", "oji-cree" },
            { "ojw", "vestojibwa" },
            { "oka", "okanagan" },
            { "osa", "osage" },
            { "ota", "osmannisk tyrkisk" },
            { "pag", "pangasinan" },
            { "pal", metaValue_pal },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palauansk" },
            { "pcm", "nigeriansk pidgin" },
            { "peo", metaValue_peo },
            { "phn", metaValue_phn },
            { "pis", "pijin" },
            { "pon", "ponape" },
            { "pqm", "maliseet-passamaquoddy" },
            { "prg", "preussisk" },
            { "pro", "oldprovencalsk" },
            { "quc", "quich\u00e9" },
            { "raj", "rajasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotonga" },
            { "rhg", "rohingya" },
            { "rof", "rombo" },
            { "rom", "romani" },
            { "rup", "arum\u00e6nsk" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "jakutisk" },
            { "sam", "samaritansk aram\u00e6isk" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "siciliansk" },
            { "sco", "skotsk" },
            { "sdh", "sydkurdisk" },
            { "see", "seneca" },
            { "seh", "sena" },
            { "sel", "selkupisk" },
            { "ses", "koyraboro senni" },
            { "sga", "oldirsk" },
            { "shi", "tachelhit" },
            { "shn", "shan" },
            { "shu", "tchadisk arabisk" },
            { "sid", "sidamo" },
            { "slh", "sydlushootseed" },
            { "sma", "sydsamisk" },
            { "smj", "lulesamisk" },
            { "smn", "enaresamisk" },
            { "sms", "skoltesamisk" },
            { "snk", "soninke" },
            { "sog", "sogdiansk" },
            { "srn", "sranan tongo" },
            { "srr", "serer" },
            { "ssy", metaValue_ssy },
            { "str", "straits salish" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumerisk" },
            { "swb", "shimaore" },
            { "syc", "klassisk syrisk" },
            { "syr", metaValue_syr },
            { "tce", "sydtutchone" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "tetum" },
            { "tgx", "tagish" },
            { "tht", "tahltan" },
            { "tig", "tigre" },
            { "tiv", "tivi" },
            { "tkl", "tokelau" },
            { "tlh", "klingon" },
            { "tli", "tlingit" },
            { "tmh", "tamashek" },
            { "tog", "nyasa tongansk" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "trv", "taroko" },
            { "tsi", "tsimshisk" },
            { "ttm", "nordtutchone" },
            { "tum", "tumbuka" },
            { "tvl", "tuvaluansk" },
            { "twq", "tasawaq" },
            { "tyv", "tuvinian" },
            { "tzm", "centralmarokkansk tamazight" },
            { "udm", "udmurt" },
            { "uga", "ugaristisk" },
            { "umb", "umbundu" },
            { "und", "ukendt sprog" },
            { "vai", metaValue_vai },
            { "vot", "votisk" },
            { "vun", "vunjo" },
            { "wae", "walsertysk" },
            { "wal", "walamo" },
            { "war", "waray" },
            { "was", "washo" },
            { "wbp", "walbiri" },
            { "wuu", "wu-kinesisk" },
            { "xal", "kalmyk" },
            { "xog", "soga" },
            { "yao", "yao" },
            { "yap", "yapese" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nheengatu" },
            { "yue", "kantonesisk" },
            { "zap", "zapotec" },
            { "zbl", metaValue_zbl },
            { "zen", "zenaga" },
            { "zgh", "tamazight" },
            { "zun", "zuni" },
            { "zxx", "intet sprogligt indhold" },
            { "zza", "zaza" },
            { "Adlm", "adlam" },
            { "Afak", "afaka" },
            { "Arab", metaValue_ar },
            { "Aran", "nastaliq" },
            { "Armi", "armi" },
            { "Armn", metaValue_hy },
            { "Avst", "avestansk" },
            { "Bali", metaValue_ban },
            { "Bamu", "bamum" },
            { "Bass", "bassa" },
            { "Batk", "batak" },
            { "Beng", metaValue_bn },
            { "Blis", metaValue_zbl },
            { "Bopo", "bopomofo" },
            { "Brah", "bramisk" },
            { "Brai", "punktskrift" },
            { "Bugi", metaValue_bug },
            { "Buhd", "buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "oprindelige canadiske symboler" },
            { "Cari", "kariansk" },
            { "Cham", "cham" },
            { "Cher", metaValue_chr },
            { "Cirt", "cirt" },
            { "Copt", metaValue_cop },
            { "Cprt", "cypriotisk" },
            { "Cyrl", "kyrillisk" },
            { "Cyrs", "kyrillisk - oldkirkeslavisk variant" },
            { "Deva", "devanagari" },
            { "Dsrt", "deseret" },
            { "Dupl", "Duploya-stenografi" },
            { "Egyd", "egyptisk demotisk" },
            { "Egyh", "egyptisk hieratisk" },
            { "Egyp", "egyptiske hieroglyffer" },
            { "Ethi", "etiopisk" },
            { "Geok", "georgisk kutsuri" },
            { "Geor", metaValue_ka },
            { "Glag", "glagolitisk" },
            { "Goth", metaValue_got },
            { "Gran", "grantha" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhi" },
            { "Hanb", "han med bopomofo" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanunoo" },
            { "Hans", "forenklet" },
            { "Hant", "traditionelt" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hluw", "anatolske hieroglyffer" },
            { "Hmng", "pahawh hmong" },
            { "Hrkt", "japanske skrifttegn" },
            { "Hung", "oldungarsk" },
            { "Inds", "indus" },
            { "Ital", "Olditalisk" },
            { "Jamo", "jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Jurc", "jurchen" },
            { "Kali", "kaya li" },
            { "Kana", "katakana" },
            { "Khar", "kharoshti" },
            { "Khmr", metaValue_km },
            { "Khoj", "khojki" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kpel", metaValue_kpe },
            { "Kthi", "kthi" },
            { "Lana", "lanna" },
            { "Laoo", metaValue_lo },
            { "Latf", "latinsk - frakturvariant" },
            { "Latg", "latinsk - g\u00e6lisk variant" },
            { "Latn", "latinsk" },
            { "Lepc", "lepcha" },
            { "Limb", "limbu" },
            { "Lina", "line\u00e6r A" },
            { "Linb", "line\u00e6r B" },
            { "Lisu", "lisu" },
            { "Loma", "loma" },
            { "Lyci", "lykisk" },
            { "Lydi", "lydisk" },
            { "Mand", "mandaisk" },
            { "Mani", "manik\u00e6isk" },
            { "Maya", "mayahieroglyffer" },
            { "Mend", metaValue_men },
            { "Merc", "metroitisk sammenh\u00e6ngende" },
            { "Mero", "meroitisk" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "moon" },
            { "Mroo", "mroo" },
            { "Mtei", "meitei-mayek" },
            { "Mymr", metaValue_my },
            { "Narb", "gammelt nordarabisk" },
            { "Nbat", "nabateisk" },
            { "Nkgb", "nakhi geba" },
            { "Nkoo", "n\u2019ko" },
            { "Nshu", "n\u00fcshu" },
            { "Ogam", "ogham" },
            { "Olck", "ol-chiki" },
            { "Orkh", "orkhon" },
            { "Orya", metaValue_or },
            { "Osma", "osmannisk" },
            { "Palm", "palmyrensk" },
            { "Perm", "oldpermisk" },
            { "Phag", "phags-pa" },
            { "Phli", "phli" },
            { "Phlp", "phlp" },
            { "Phlv", metaValue_pal },
            { "Phnx", metaValue_phn },
            { "Plrd", "pollardtegn" },
            { "Prti", "prti" },
            { "Qaag", "zawgyi" },
            { "Rjng", "rejang" },
            { "Rohg", "hanifi" },
            { "Roro", "rongo-rongo" },
            { "Runr", "runer" },
            { "Samr", "samaritansk" },
            { "Sara", "sarati" },
            { "Sarb", "olds\u00f8rarabisk" },
            { "Saur", "saurashtra" },
            { "Sgnw", "tegnskrift" },
            { "Shaw", "shavisk" },
            { "Shrd", "sharada" },
            { "Sind", "khudawadi" },
            { "Sinh", metaValue_si },
            { "Sora", "sora" },
            { "Sund", metaValue_su },
            { "Sylo", "syloti nagri" },
            { "Syrc", metaValue_syr },
            { "Syre", "syrisk - estrangelovariant" },
            { "Syrj", "vestsyrisk" },
            { "Syrn", "\u00f8stsyriakisk" },
            { "Tagb", "tagbanwa" },
            { "Takr", "takri" },
            { "Tale", "tai le" },
            { "Talu", "tai lue" },
            { "Taml", "tamilsk" },
            { "Tang", "tangut" },
            { "Tavt", "tavt" },
            { "Telu", metaValue_te },
            { "Teng", "tengwar" },
            { "Tfng", "tifinagh" },
            { "Tglg", metaValue_tl },
            { "Thaa", "thaana" },
            { "Thai", "thailandsk" },
            { "Tibt", metaValue_bo },
            { "Tirh", "tirhuta" },
            { "Ugar", "ugaritisk" },
            { "Vaii", metaValue_vai },
            { "Visp", "synlig tale" },
            { "Wara", "varang kshiti" },
            { "Wole", "woleai" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "sumero-akkadisk cuneiform" },
            { "Yiii", "yi" },
            { "Zinh", "arvet" },
            { "Zmth", "matematisk notation" },
            { "Zsye", "emoji" },
            { "Zsym", "symboler" },
            { "Zxxx", "uden skriftsprog" },
            { "Zyyy", "f\u00e6lles" },
            { "Zzzz", "ukendt skriftsprog" },
            { "de_AT", "\u00f8strigsk tysk" },
            { "de_CH", "schweizerh\u00f8jtysk" },
            { "en_AU", "australsk engelsk" },
            { "en_CA", "canadisk engelsk" },
            { "en_GB", "britisk engelsk" },
            { "en_US", "amerikansk engelsk" },
            { "es_ES", "europ\u00e6isk spansk" },
            { "es_MX", "mexicansk spansk" },
            { "fa_AF", "dari" },
            { "fr_CA", "canadisk fransk" },
            { "fr_CH", "schweizisk fransk" },
            { "nl_BE", "flamsk" },
            { "pt_BR", "brasiliansk portugisisk" },
            { "pt_PT", "europ\u00e6isk portugisisk" },
            { "ro_MD", "moldovisk" },
            { "sw_CD", "congolesisk swahili" },
            { "%%1901", "traditionel tysk retskrivning" },
            { "%%1994", "standardiseret Resi-ortografi" },
            { "%%1996", "tysk retskrivning fra 1996" },
            { "ar_001", "moderne standardarabisk" },
            { "es_419", "latinamerikansk spansk" },
            { "key.ca", "kalender" },
            { "key.cf", "valutaformat" },
            { "key.co", "sorteringsr\u00e6kkef\u00f8lge" },
            { "key.cu", "valuta" },
            { "key.hc", "timeur (12 vs. 24)" },
            { "key.lb", "linjeskift" },
            { "key.ms", "m\u00e5lesystem" },
            { "key.nu", "tal" },
            { "key.tz", "Tidszone" },
            { "key.va", "Sprogvariant" },
            { "%%ALUKU", "aluku-dialekt" },
            { "%%BISKE", "San Giorgio-/Bila-dialekt" },
            { "%%BOONT", "boontling" },
            { "%%JAUER", "jauer" },
            { "%%KKCOR", "almindelig ortografi" },
            { "%%KSCOR", "standardortografi" },
            { "%%LIPAW", "lipovaz" },
            { "%%NEDIS", "Natisone-dialekt" },
            { "%%NJIVA", "Gniva-/Nijva-dialekt" },
            { "%%NULIK", "moderne volap\u00fck" },
            { "%%OSOJS", "Oseacco-/Osojane-dialekt" },
            { "%%POSIX", "computer" },
            { "%%RIGIK", "klassisk volap\u00fck" },
            { "%%ROZAJ", "Resi" },
            { "%%SAAHO", metaValue_ssy },
            { "%%UCCOR", "forenet ortografi" },
            { "zh_Hans", "forenklet kinesisk" },
            { "zh_Hant", "traditionelt kinesisk" },
            { "%%DAJNKO", "Dajnko-alfabet" },
            { "%%FONIPA", "det internationale fonetiske alfabet" },
            { "%%FONUPA", "det uraliske fonetiske alfabet" },
            { "%%NDYUKA", "Ndyuka-dialekt" },
            { "%%PAMAKA", "Pamaka-dialekt" },
            { "%%PINYIN", "pinyin" },
            { "%%SCOUSE", "scouse" },
            { "%%TARASK", "Taraskievica-ortografi" },
            { "%%UCRCOR", "forenet revideret ortografi" },
            { "%%ULSTER", "ulster" },
            { "%%ALALC97", "ALA-LC-romanisering fra 1997" },
            { "%%AREVELA", "\u00f8starmensk" },
            { "%%AREVMDA", "vestarmensk" },
            { "%%BAUDDHA", "bauddha" },
            { "%%BOHORIC", "Bohori\u010d-alfabet" },
            { "%%EMODENG", "tidlig moderne engelsk" },
            { "%%HEPBURN", "Hepburn-romanisering" },
            { "%%ITIHASA", "itihasa" },
            { "%%LAUKIKA", "laukika" },
            { "%%METELKO", "Metelko-alfabet" },
            { "%%MONOTON", "monotonisk" },
            { "%%POLYTON", "polytonisk" },
            { "%%REVISED", "revideret retskrivning" },
            { "%%SURSILV", "sursilv" },
            { "%%SUTSILV", "sutsilv" },
            { "%%VAIDIKA", "vaidika" },
            { "%%1606NICT", "sen middelfransk frem til 1606" },
            { "%%1694ACAD", "tidlig moderne fransk" },
            { "%%1959ACAD", "akademisk" },
            { "%%BAKU1926", "forenet tyrkisk-latinsk alfabet" },
            { "%%BISCAYAN", "biscayisk" },
            { "%%FONXSAMP", "fonxsamp" },
            { "%%HOGNORSK", "h\u00f8gnorsk" },
            { "%%JYUTPING", "jyutping" },
            { "%%SCOTLAND", "skotsk standardengelsk" },
            { "%%SURMIRAN", "surmiran" },
            { "%%VALENCIA", "valenciansk" },
            { "%%VALLADER", "vallader" },
            { "%%WADEGILE", "Wade-Giles" },
            { "type.ca.roc", "kalender for Republikken Kina" },
            { "type.co.eor", "europ\u00e6isk sorteringsr\u00e6kkef\u00f8lge" },
            { "type.hc.h11", "12-timersur (0-11)" },
            { "type.hc.h12", "12-timersur (1-12)" },
            { "type.hc.h23", "24-timersur (0-23)" },
            { "type.hc.h24", "24-timersur (1-24)" },
            { "type.m0.bgn", "BGN" },
            { "type.nu.arab", "hindu-arabiske tal" },
            { "type.nu.armn", "armenske tal" },
            { "type.nu.bali", "Balinesiske tal" },
            { "type.nu.beng", "bengali tal" },
            { "type.nu.brah", "Brahmi-tal" },
            { "type.nu.cakm", "chakma-tal" },
            { "type.nu.cham", "Cham-tal" },
            { "type.nu.deva", "devanagariske tal" },
            { "type.nu.ethi", "etiopiske tal" },
            { "type.nu.geor", "georgiske tal" },
            { "type.nu.grek", "gr\u00e6ske tal" },
            { "type.nu.gujr", "gujarati tal" },
            { "type.nu.guru", "gurmukhi tal" },
            { "type.nu.hans", "forenklede kinesiske tal" },
            { "type.nu.hant", "traditionelle kinesiske tal" },
            { "type.nu.hebr", "hebraiske tal" },
            { "type.nu.java", "javanesiske tal" },
            { "type.nu.jpan", "japanske tal" },
            { "type.nu.kali", "Kayah Li-tal" },
            { "type.nu.khmr", "khmer tal" },
            { "type.nu.knda", "kannada tal" },
            { "type.nu.lana", "Tai Tham Hora-tal" },
            { "type.nu.laoo", "laotiske tal" },
            { "type.nu.latn", "arabertal" },
            { "type.nu.lepc", "Lepcha-tal" },
            { "type.nu.limb", "Limbu-tal" },
            { "type.nu.mlym", "malayalamske tal" },
            { "type.nu.mong", "Mongolske tal" },
            { "type.nu.mtei", "Meetei Mayek-tal" },
            { "type.nu.mymr", "Myanmar-tal" },
            { "type.nu.nkoo", "N\u2019Ko-tal" },
            { "type.nu.olck", "ol chiki-tal" },
            { "type.nu.orya", "oriya-tal" },
            { "type.nu.osma", "Osmanya-tal" },
            { "type.nu.saur", "Saurashtra-tal" },
            { "type.nu.shrd", "Sharada-tal" },
            { "type.nu.sora", "Sora Sompeng-tal" },
            { "type.nu.sund", "Sundanesiske tal" },
            { "type.nu.takr", "Takri-tal" },
            { "type.nu.talu", "Nye Tai Lue-tal" },
            { "type.nu.taml", "traditionelle tamilske tal" },
            { "type.nu.telu", "telugu-tal" },
            { "type.nu.thai", "thailandske tal" },
            { "type.nu.tibt", "tibetanske tal" },
            { "type.nu.vaii", "vai-tal" },
            { "type.ca.dangi", "dangi-kalender" },
            { "type.co.ducet", "Unicode-standardsorteringsr\u00e6kkef\u00f8lge" },
            { "type.lb.loose", "l\u00f8st linjeskift" },
            { "type.nu.roman", "romertal" },
            { "type.ca.coptic", "koptisk kalender" },
            { "type.ca.hebrew", "j\u00f8disk kalender" },
            { "type.ca.indian", "indisk nationalkalender" },
            { "type.co.compat", "tidligere sorteringsr\u00e6kkef\u00f8lge, kompatibilitet" },
            { "type.co.pinyin", "pinyin-baseret sorteringsr\u00e6kkef\u00f8lge" },
            { "type.co.search", "generel s\u00f8gning" },
            { "type.co.stroke", "stregbaseret sorteringsr\u00e6kkef\u00f8lge" },
            { "type.co.unihan", "sortering efter streger i rodtegn" },
            { "type.co.zhuyin", "zhuyin-sorteringsr\u00e6kkef\u00f8lge" },
            { "type.d0.fwidth", "fuld bredde" },
            { "type.d0.hwidth", "halv bredde" },
            { "type.lb.normal", "normalt linjeskift" },
            { "type.lb.strict", "h\u00e5rdt linjeskift" },
            { "type.m0.ungegn", "UNGEGN" },
            { "type.ms.metric", "metersystem" },
            { "type.nu.native", "nationale tal" },
            { "type.ca.chinese", "kinesisk kalender" },
            { "type.ca.islamic", "islamisk kalender" },
            { "type.ca.iso8601", "ISO-8601-kalender" },
            { "type.ca.persian", "persisk kalender" },
            { "type.cf.account", "format for regnskabsvaluta" },
            { "type.co.big5han", "sorteringsr\u00e6kkef\u00f8lge uforkortet kinesisk - Big5" },
            { "type.d0.npinyin", "Numerisk" },
            { "type.nu.arabext", "udvidede hindu-arabiske tal" },
            { "type.nu.armnlow", "armenske tal med sm\u00e5 bogstaver" },
            { "type.nu.finance", "Finansielle tal" },
            { "type.nu.greklow", "gr\u00e6ske tal med sm\u00e5 bogstaver" },
            { "type.nu.hanidec", "kinesiske decimaltal" },
            { "type.nu.hansfin", "forenklede kinesiske finansielle tal" },
            { "type.nu.hantfin", "traditionelle kinesiske finansielle tal" },
            { "type.nu.jpanfin", "japanske finansielle tal" },
            { "type.nu.tamldec", "tamilske tal" },
            { "type.ca.buddhist", "buddhistisk kalender" },
            { "type.ca.ethiopic", "etiopisk kalender" },
            { "type.ca.japanese", "japansk kalender" },
            { "type.cf.standard", "format for standardvaluta" },
            { "type.co.phonetic", "fonetisk sorteringsr\u00e6kkef\u00f8lge" },
            { "type.co.reformed", "ny sorteringsr\u00e6kkef\u00f8lge" },
            { "type.co.searchjl", "sort\u00e9r efter den f\u00f8rste konsonant i hangul" },
            { "type.co.standard", "standardsorteringsr\u00e6kkef\u00f8lge" },
            { "type.ms.uksystem", "britisk m\u00e5lesystem" },
            { "type.ms.ussystem", "amerikansk m\u00e5lesystem" },
            { "type.nu.fullwide", "tal i fuld bredde" },
            { "type.nu.lanatham", "Tai Tham Tahm-tal" },
            { "type.nu.mymrshan", "Myanmar Shan-tal" },
            { "type.nu.romanlow", "romertal med sm\u00e5 bogstaver" },
            { "type.ca.gregorian", "gregoriansk kalender" },
            { "type.co.gb2312han", "sorteringsr\u00e6kkef\u00f8lge forkortet kinesisk - GB2312" },
            { "type.co.phonebook", "sorteringsr\u00e6kkef\u00f8lge i telefonb\u00f8ger" },
            { "type.co.dictionary", "sorteringsr\u00e6kkef\u00f8lge for ordbog" },
            { "type.co.traditional", "traditionel sorteringsr\u00e6kkef\u00f8lge" },
            { "type.nu.traditional", "Traditionelle tal" },
            { "type.ca.islamic-rgsa", "islamisk kalender (Saudi-Arabien, observation)" },
            { "type.ca.islamic-tbla", "islamisk kalender (tabellarisk, astronomisk epoke)" },
            { "type.ca.islamic-civil", "verdslig islamisk kalender" },
            { "type.ca.islamic-umalqura", "islamisk kalender (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "etiopisk amete-alem-kalender" },
        };
        return data;
    }
}
